/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;

public class ExternalLogbookStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExternalLogbookStep.class);
    private String fileName;
    private JsonNode model;

    public ExternalLogbookStep(World world) {
        super(world);
    }

    public JsonNode getModel() {
        return this.model;
    }

    public void setModel(JsonNode model) {
        this.model = model;
    }

    @Given(value="^un fichier de logbook operation nomm\u00e9 (.*)$")
    public void a_sip_named(String fileName) {
        this.fileName = fileName;
    }

    @Then(value="^j'importe un journal d'op\u00e9ration correct$")
    public void createExternalLogbook() {
        this.callAdminExternal("CREATED");
    }

    @Then(value="^j'importe un journal d'op\u00e9ration incorrect$")
    public void createExternalLogbookKO() {
        this.callAdminExternal("BAD_REQUEST");
    }

    private void callAdminExternal(String expectedStatus) {
        Path logbookFile = Paths.get(this.world.getBaseDirectory(), this.fileName);
        try {
            GUID operationGuid = GUIDFactory.newOperationLogbookGUID((int)this.world.getTenantId());
            String logbookString = JsonHandler.unprettyPrint((Object)JsonHandler.getFromFile((File)logbookFile.toFile()));
            logbookString = logbookString.replace("REPLACE_ME", operationGuid.getId());
            LogbookOperationParameters logbookOperationParams = (LogbookOperationParameters)JsonHandler.getFromString((String)logbookString, LogbookOperationParameters.class);
            RequestResponse response = this.world.getAdminClient().createExternalOperation(new VitamContext(Integer.valueOf(this.world.getTenantId())), logbookOperationParams);
            Response.Status statusExpected = Response.Status.CREATED;
            switch (expectedStatus) {
                case "CREATED": {
                    statusExpected = Response.Status.CREATED;
                    break;
                }
                case "BAD_REQUEST": {
                    statusExpected = Response.Status.BAD_REQUEST;
                }
            }
            Assertions.assertThat((int)response.getHttpCode()).isEqualTo(statusExpected.getStatusCode());
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
        }
        catch (Exception e) {
            Assertions.fail((String)"should not produce this exception", (Throwable)e);
        }
    }
}

