/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;

public class CommonStep {
    protected final World world;

    public CommonStep(World world) {
        this.world = world;
    }

    protected void checkOperationStatus(String operationId, StatusCode ... statuses) throws VitamException {
        Assertions.assertThat((String)operationId).isNotNull();
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean process_timeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 1800, 1000L, TimeUnit.MILLISECONDS);
        if (!process_timeout) {
            Assertions.fail((String)("Operation " + operationId + " timed out."));
        }
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId());
        RequestResponse operationProcessExecutionDetails = this.world.getAdminClient().getOperationProcessExecutionDetails(vitamContext, operationId);
        Assertions.assertThat((boolean)operationProcessExecutionDetails.isOk()).isTrue();
        Assertions.assertThat((Comparable)((ItemStatus)((RequestResponseOK)operationProcessExecutionDetails).getFirstResult()).getGlobalStatus()).isIn((Object[])statuses);
    }

    protected void runInVitamThread(MyRunnable r) {
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)VitamThreadFactory.getInstance());
        CompletionStage task = CompletableFuture.runAsync(() -> {
            try {
                r.run();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, executorService).exceptionally(e -> {
            Assertions.fail((String)"Test failed with error", (Throwable)e);
            return null;
        });
        ((CompletableFuture)task).join();
    }

    public static interface MyRunnable {
        public void run() throws Exception;
    }
}

