/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;

public class ArchiveUnitProfileStep
extends CommonStep {
    private String fileName;
    private JsonNode model;

    public ArchiveUnitProfileStep(World world) {
        super(world);
    }

    @Given(value="^un document type nomm\u00e9 (.*)$")
    public void an_archive_profile_named(String fileName) {
        this.fileName = fileName;
    }

    @When(value="je fais un import du document type")
    public void create_profile() throws InvalidParseOperationException, IOException, AccessExternalClientException {
        Path profil = Paths.get(this.world.getBaseDirectory(), this.fileName);
        RequestResponse response = this.world.getAdminClient().createArchiveUnitProfile(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), Files.newInputStream(profil, StandardOpenOption.READ));
        if (response.isOk()) {
            ((RequestResponseOK)response).getResults().stream().findFirst().ifPresent(o -> {
                this.model = o;
            });
        }
        String httpCode = String.valueOf(response.getHttpCode());
        ObjectNode responseCode = JsonHandler.createObjectNode();
        responseCode.put("Code", httpCode);
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        result.add((JsonNode)responseCode);
        this.world.setResults(result);
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
    }

    @When(value="^je cherche un document type nomm\u00e9 (.*)")
    public void search_profiles(String name) throws AccessExternalClientException, InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.match((String)"Name", (String)name));
        ObjectNode query = select.getFinalSelect();
        RequestResponse requestResponse = this.world.getAdminClient().findArchiveUnitProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)query);
        if (requestResponse.isOk()) {
            this.model = (JsonNode)((RequestResponseOK)requestResponse).getResultsAsJsonNodes().get(0);
        }
    }

    @Then(value="^le document type existe$")
    public void contract_found_are() {
        Assertions.assertThat((Iterable)this.model).isNotNull();
    }

    @Then(value="^les m\u00e9tadonn\u00e9es du document type sont$")
    public void metadata_are(DataTable dataTable) throws Throwable {
        List raws = dataTable.cells();
        for (List raw : raws) {
            String index = (String)raw.get(0);
            String value = (String)raw.get(1);
            Assertions.assertThat((String)this.model.get(index).asText()).contains(new CharSequence[]{value});
        }
    }
}

