/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.step;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.access.external.api.AdminCollections;
import fr.gouv.vitam.access.external.client.OperationStatusClient;
import fr.gouv.vitam.access.external.client.VitamPoolingClient;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.FacetBucket;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.PermissionModel;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.utils.JsonSorter;
import fr.gouv.vitam.functionaltest.cucumber.step.CommonStep;
import fr.gouv.vitam.functionaltest.cucumber.step.ContractsStep;
import fr.gouv.vitam.functionaltest.cucumber.step.World;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import io.cucumber.java.fr.Etantdonn\u00e9;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;

public class AccessStep
extends CommonStep {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessStep.class);
    public static final String CONTEXT_IDENTIFIER = "CT-000001";
    public static final String INGEST_CONTRACT_IDENTIFIER = "contrat_de_rattachement_TNR";
    private static final String INHERITED_RULES = "InheritedRules";
    private static final String UNIT_GUID = "UNIT_GUID";
    private static final String CONTRACT_WITH_LINK = "[{\"Identifier\":\"contrat_de_rattachement_TNR\",\"Name\":\"contrat_de_rattachement_TNR\",\"Description\":\"Rattachant les SIP \u00e0 une AU\",\"Status\" : \"ACTIVE\",\"LastUpdate\":\"10/12/2016\",\"CreationDate\":\"10/12/2016\",\"ActivationDate\":\"10/12/2016\",\"DeactivationDate\":\"10/12/2016\",\"LinkParentId\": \"UNIT_GUID\"}]";
    private static final String OPERATION_ID = "Operation-Id";
    private static final String NAMED_OPERATION_ID_PREFIX = "Named-Operation-Id<";
    private static final String NAMED_OPERATION_ID_SUFFIX = ">";
    private static final String ELIMINATION_OPERATION_ID = "Elimination-Operation-Id";
    private static final String UNIT_PREFIX = "unit:";
    private static final String REGEX = "(\\{\\{(.*?)\\}\\})";
    private JsonNode selectedInheritedCategoryResult;
    private List<FacetResult> facetResults;
    private static String savedUnit;
    private RequestResponse<?> requestResponse;

    public AccessStep(World world) {
        super(world);
    }

    @Then(value="^le r\u00e9sultat pour la facet (.*) contient (\\d+) valeurs (.*)$")
    public void facetmetadata_contains_values_count(String facetName, int count, String value) throws Throwable {
        Optional<FacetResult> facetResult = this.facetResults.stream().filter(item -> item.getName().equals(facetName)).findFirst();
        ((OptionalAssert)Assertions.assertThat(facetResult).as("facetResult with name " + facetName + " was not found", new Object[0])).isPresent();
        Optional<FacetBucket> facetBucket = facetResult.get().getBuckets().stream().filter(item -> item.getValue().equals(value)).findFirst();
        ((OptionalAssert)Assertions.assertThat(facetBucket).as("facetResult with name " + facetName + " does not contains value " + value, new Object[0])).isPresent();
        Assertions.assertThat((long)facetBucket.get().getCount()).isEqualTo((long)count);
    }

    @Then(value="^le r\u00e9sultat pour la facet (.*) ne contient pas la valeur (.*)$")
    public void facetmetadata_does_not_contains_value(String facetName, String value) throws Throwable {
        Optional<FacetResult> facetResult = this.facetResults.stream().filter(item -> item.getName().equals(facetName)).findFirst();
        ((OptionalAssert)Assertions.assertThat(facetResult).as("facetResult with name " + facetName + " was not found", new Object[0])).isPresent();
        Optional<FacetBucket> facetBucket = facetResult.get().getBuckets().stream().filter(item -> item.getValue().equals(value)).findFirst();
        ((OptionalAssert)Assertions.assertThat(facetBucket).as("facetResult with name " + facetName + " contains value " + value, new Object[0])).isNotPresent();
    }

    @Then(value="^les metadonn\u00e9es sont$")
    public void metadata_are(DataTable dataTable) throws Throwable {
        this.metadata_are_for_particular_result(0, dataTable);
    }

    @Then(value="^les metadonn\u00e9es pour le r\u00e9sultat (\\d+)$")
    public void metadata_are_for_particular_result(int resultNumber, DataTable dataTable) throws Throwable {
        ArrayList<JsonNode> transformedResults = new ArrayList<JsonNode>();
        for (JsonNode result : this.world.getResults()) {
            String resultAsString = JsonHandler.unprettyPrint((Object)result);
            String resultAsStringTransformed = this.transformUnitTitleToGuid(resultAsString);
            transformedResults.add(JsonHandler.getFromString((String)resultAsStringTransformed));
        }
        DataTable transformedDataTable = this.getTransformedDataTable(dataTable);
        this.world.getAccessService().checkResultsForParticularData(transformedResults, resultNumber, transformedDataTable);
    }

    private DataTable getTransformedDataTable(DataTable dataTable) throws Throwable {
        ArrayList modifiedRaws = new ArrayList();
        List raws = dataTable.cells();
        for (List raw : raws) {
            ArrayList<String> modifiedSubRaws = new ArrayList<String>();
            for (String subRaw : raw) {
                modifiedSubRaws.add(this.transformUnitTitleToGuid(subRaw));
            }
            modifiedRaws.add(modifiedSubRaws);
        }
        return DataTable.create(modifiedRaws);
    }

    @When(value="^j'importe le contrat d'entr\u00e9e avec le noeud de rattachement dont le titre est (.*)")
    public void upload_contract_ingest_with_noeud(String title) throws Throwable {
        boolean exists = false;
        try {
            String unitGuid = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), title);
            String newContract = CONTRACT_WITH_LINK.replace(UNIT_GUID, unitGuid);
            this.world.getAdminClient().createIngestContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), (InputStream)new ByteArrayInputStream(newContract.getBytes()));
        }
        catch (AccessExternalClientException | InvalidParseOperationException | IllegalStateException e) {
            LOGGER.warn("Contrat d'entr\u00e9e est d\u00e9j\u00e0 import\u00e9");
            exists = true;
        }
        if (!exists) {
            RequestResponse res = this.world.getAdminClient().findContextById(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), CONTEXT_IDENTIFIER);
            Assertions.assertThat((boolean)res.isOk()).isTrue();
            ContextModel contextModel = (ContextModel)((RequestResponseOK)res).getFirstResult();
            Assertions.assertThat((Object)contextModel).isNotNull();
            List permissions = contextModel.getPermissions();
            Assertions.assertThat((List)permissions).isNotEmpty();
            boolean changed = false;
            for (PermissionModel p : permissions) {
                if (p.getTenant().intValue() != this.world.getTenantId()) continue;
                if (null == p.getIngestContract()) {
                    p.setIngestContract(new HashSet());
                }
                changed = p.getIngestContract().add(INGEST_CONTRACT_IDENTIFIER) || changed;
            }
            if (changed) {
                ContractsStep.updateContext(this.world.getAdminClient(), this.world.getApplicationSessionId(), CONTEXT_IDENTIFIER, permissions, true);
            }
        }
    }

    private String transformUnitTitleToGuid(String result) throws Throwable {
        Matcher matcher = Pattern.compile(REGEX).matcher(result);
        String resultCopy = result;
        HashMap<String, String> unitToGuid = new HashMap<String, String>();
        while (matcher.find()) {
            String unitGuid;
            String unit = matcher.group(1);
            String unitTitle = unit.substring(2, unit.length() - 2).replace(UNIT_PREFIX, "").trim();
            if (unitToGuid.get(unitTitle) != null) {
                unitGuid = (String)unitToGuid.get(unitTitle);
            } else {
                unitGuid = this.getUnitGuidByTitle(unitTitle);
                unitToGuid.put(unitTitle, unitGuid);
            }
            resultCopy = resultCopy.replace(unit, unitGuid);
        }
        return resultCopy;
    }

    private String transformLoadedUnitTitleToGuid(String result) throws Throwable {
        Matcher matcher = Pattern.compile(REGEX).matcher(result);
        String resultCopy = result;
        HashMap<String, String> unitToGuid = new HashMap<String, String>();
        while (matcher.find()) {
            String unitGuid;
            String unit = matcher.group(1);
            String unitTitle = unit.substring(2, unit.length() - 2).replace(UNIT_PREFIX, "").trim();
            if (unitToGuid.get(unitTitle) != null) {
                unitGuid = (String)unitToGuid.get(unitTitle);
            } else {
                unitGuid = this.selectLoadedUnitGuidByTitle(unitTitle);
                unitToGuid.put(unitTitle, unitGuid);
            }
            resultCopy = resultCopy.replace(unit, unitGuid);
        }
        return resultCopy;
    }

    private String getUnitGuidByTitle(String unitTitle) throws InvalidCreateOperationException, VitamClientException {
        String unitGuid = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), unitTitle);
        return unitGuid;
    }

    private String selectLoadedUnitGuidByTitle(String unitTitle) {
        List<JsonNode> results = this.world.getResults();
        for (JsonNode result : results) {
            if (!result.get("Title").asText().equals(unitTitle)) continue;
            return result.get(VitamFieldsHelper.id()).asText();
        }
        Fail.fail((String)("No such unit with title '" + unitTitle + "'"));
        throw new AssertionError((Object)"Never reached");
    }

    private String getValueFromResult(String field, int numResult) {
        List<JsonNode> results = this.world.getResults();
        if (results.size() < numResult) {
            Fail.fail((String)("numResult " + numResult + " > result size " + results.size()));
        }
        JsonNode result = (JsonNode)Iterables.get(results, (int)numResult);
        result = result.get(field);
        return result.textValue();
    }

    @Then(value="^le nombre de r\u00e9sultat est (\\d+)$")
    public void number_of_result_are(int numberOfResult) {
        Assertions.assertThat(this.world.getResults()).hasSize(numberOfResult);
    }

    @Then(value="^tous les r\u00e9sultats contiennent la propri\u00e9t\u00e9 \"([^\"]*)\" dont la valeur est \"([^\"]*)\"$")
    public void results_contains_key_value(String fieldKey, String fieldValue) {
        this.world.getResults().forEach(result -> Assertions.assertThat((String)result.get(fieldKey).textValue()).isEqualTo(fieldValue));
    }

    @Then(value="^le statut de select r\u00e9sultat est (.*)$")
    public void the_status_of_the_select_result(String status) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        this.requestResponse = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        this.the_status_of_the_request(status);
    }

    @Then(value="^le message d'erreur renvoy\u00e9 est (.*)$")
    public void the_description_message_of_the_select_result(String message) throws Throwable {
        String expectedMessage = ((VitamError)this.requestResponse).getDescription();
        Assertions.assertThat((String)expectedMessage).isNotNull();
        Assertions.assertThat((String)expectedMessage).isEqualTo("Projection field $rules is no longer supported.");
    }

    @Then(value="^le statut de la requete est (.*)$")
    public void the_status_of_the_request(String status) throws Throwable {
        Response.Status expectedStatus = Response.Status.fromStatusCode((int)this.requestResponse.getHttpCode());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)expectedStatus).as("Invalid status %d", new Object[]{this.requestResponse.getHttpCode()})).isNotNull();
        Assertions.assertThat((String)expectedStatus.getReasonPhrase()).isEqualTo(status);
    }

    @Then(value="^le statut de update r\u00e9sultat est (.*)$")
    public void the_status_of_the_update_result(String status) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        Object s = null;
        String unitId = this.getValueFromResult("#id", 0);
        RequestResponse requestResponse = this.world.getAccessClient().updateUnitbyId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON, unitId);
        Assertions.assertThat((boolean)requestResponse.isOk()).isFalse();
        VitamError vitamError = (VitamError)requestResponse;
        Assertions.assertThat((int)Response.Status.valueOf((String)status.toUpperCase()).getStatusCode()).isEqualTo(vitamError.getHttpCode());
    }

    @When(value="^j'utilise le fichier de requ\u00eate suivant (.*)$")
    public void i_use_the_following_file_query(String queryFilename) throws Throwable {
        Path queryFile = Paths.get(this.world.getBaseDirectory(), queryFilename);
        String query = FileUtil.readFile((File)queryFile.toFile());
        query = this.replaceOperationIds(query);
        this.world.setQuery(query);
    }

    @When(value="^j'utilise dans la requ\u00eate le param\u00e8tre (.*) avec la valeur (.*)$")
    public void i_use_the_following_parameter_query_with_values(String parameter, String value) throws Throwable {
        String query = this.world.getQuery().replace(parameter, value);
        this.world.setQuery(query);
    }

    @When(value="^j'utilise dans la requ\u00eate le param\u00e8tre (.*) avec l'id$")
    public void i_use_the_following_parameter_query_with_an_id(String parameter) throws Throwable {
        String query = this.world.getQuery().replace(parameter, this.world.getUnitId());
        this.world.setQuery(query);
    }

    @When(value="^j'utilise dans la requ\u00eate le GUID de l'unit\u00e9 archivistique pour le titre (.*)$")
    public void i_use_the_following_unit_guid_for_title(String title) throws Throwable {
        String unitGuid = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), title);
        String query = this.world.getQuery().replace("{{guid}}", unitGuid);
        this.world.setQuery(query);
    }

    @When(value="^j'utilise la requ\u00eate suivante$")
    public void i_use_the_following_query(String query) throws Throwable {
        String queryTmp = query;
        queryTmp = this.replaceOperationIds(queryTmp);
        queryTmp = this.transformUnitTitleToGuid(queryTmp);
        this.world.setQuery(queryTmp);
    }

    @Then(value="^je nomme l'identifiant de l'op\u00e9ration (.*)$")
    public void saveOperationId(String operationIdName) throws Throwable {
        this.world.setNamedOperationId(operationIdName, this.world.getOperationId());
    }

    private String replaceOperationIds(String query) {
        if (this.world.getEliminationOperationId() != null) {
            query = query.replace(ELIMINATION_OPERATION_ID, this.world.getEliminationOperationId());
        }
        while (query.contains(NAMED_OPERATION_ID_PREFIX)) {
            int startIndex = query.indexOf(NAMED_OPERATION_ID_PREFIX);
            int endIndex = query.indexOf(NAMED_OPERATION_ID_SUFFIX, startIndex);
            String name = query.substring(startIndex + NAMED_OPERATION_ID_PREFIX.length(), endIndex);
            query = query.replace(NAMED_OPERATION_ID_PREFIX + name + NAMED_OPERATION_ID_SUFFIX, this.world.getNamedOperationId(name));
        }
        if (this.world.getOperationId() != null) {
            query = query.replace(OPERATION_ID, this.world.getOperationId());
        }
        return query;
    }

    @When(value="^je recherche les unit\u00e9s archivistiques$")
    public void search_archive_unit() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
            this.facetResults = requestResponseOK.getFacetResults();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche les unit\u00e9s archivistiques pour trouver l'unite (.*)$")
    public void search_archive_unit(String originatingSystemId) throws Throwable {
        String queryTmp = this.world.getQuery().replace("Originating_System_Id", originatingSystemId);
        this.world.setQuery(queryTmp);
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
            this.facetResults = requestResponseOK.getFacetResults();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche l'unit\u00e9 archivistique ayant l'identifiant p\u00e9renne (.*)$")
    public void search_archive_unit_by_persistent_identifier(String persistentIdentifier) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnitsByUnitPersistentIdentifier(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON, persistentIdentifier);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
            this.facetResults = requestResponseOK.getFacetResults();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je t\u00e9l\u00e9charge l'objet ayant le qualifier (.*) rattach\u00e9 \u00e0 une unit\u00e9 archivistique ayant l'identifiant p\u00e9renne (.*)$")
    public void download_object_by_qualifier_and_persistent_identifier(String qualifier, String persistentIdentifier) throws Throwable {
        this.download_object_by_qualifier_and_version_persistent_identifier(qualifier, null, persistentIdentifier);
    }

    @When(value="^je t\u00e9l\u00e9charge l'objet ayant le qualifier (.*) et la version (.*) rattach\u00e9 \u00e0 une unit\u00e9 archivistique ayant l'identifiant p\u00e9renne (.*)$")
    public void download_object_by_qualifier_and_version_persistent_identifier(String qualifier, String version, String persistentIdentifier) throws Throwable {
        Response response = this.world.getAccessClient().getObjectByUnitPersistentIdentifier(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), persistentIdentifier, qualifier, version);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            File tempFile = Files.createTempFile("TRANSFER-" + this.world.getOperationId(), ".bin", new FileAttribute[0]).toFile();
            try (InputStream inputStream = (InputStream)response.readEntity(InputStream.class);){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.world.setTransferFile(tempFile.toPath());
            this.world.getAccessClient().consumeAnyEntityAndClose(response);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)("request download object returned an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je t\u00e9l\u00e9charge l'objet ayant l'identifiant p\u00e9renne (.*)$")
    public void download_object_by_persistent_identifier(String persistentIdentifier) throws Throwable {
        Response response = this.world.getAccessClient().downloadObjectByObjectPersistentIdentifier(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), persistentIdentifier);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            File tempFile = Files.createTempFile("TRANSFER-" + this.world.getOperationId(), ".bin", new FileAttribute[0]).toFile();
            try (InputStream inputStream = (InputStream)response.readEntity(InputStream.class);){
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.world.setTransferFile(tempFile.toPath());
            this.world.getAccessClient().consumeAnyEntityAndClose(response);
        } else {
            VitamError vitamError = (VitamError)this.requestResponse;
            Fail.fail((String)("request download object returned an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche l'objet ayant l'identifiant p\u00e9renne (.*)$")
    public void get_object_by_persistent_identifier(String persistentIdentifier) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().getObjectByObjectPersistentIdentifier(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON, persistentIdentifier);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request getObjectByObjectPersistentIdentifier return an error: " + vitamError.getCode()));
        }
    }

    @Then(value="^le hash (.*) du fichier transf\u00e9r\u00e9 est (.*)$")
    public void check_downloaded_object_message_digest(String algorithm, String expectedDigest) throws Throwable {
        Path transferFile = this.world.getTransferFile();
        DigestType digestType = DigestType.fromValue((String)algorithm);
        Digest digest = new Digest(digestType);
        digest.update(transferFile.toFile());
        Assertions.assertThat((String)digest.toString()).isEqualTo(expectedDigest);
    }

    @When(value="^je recherche une unit\u00e9 archivistique et je recup\u00e8re son id$")
    public void search_one_archive_unit() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            JsonNode unit = (JsonNode)requestResponseOK.getResults().iterator().next();
            this.world.setUnitId(unit.get("#id").asText());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche les unit\u00e9s archivistiques avec leurs r\u00e8gles de gestion h\u00e9rit\u00e9es$")
    public void search_archive_units_with_inherited_rules() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnitsWithInheritedRules(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
            this.selectedInheritedCategoryResult = null;
            this.facetResults = requestResponseOK.getFacetResults();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnitsWithInheritedRules return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je s\u00e9lectionne la cat\u00e9gorie (.*) pour l'unit\u00e9 (.*)$")
    public void metadata_are_for_particular_result(String category, String unitTitle) throws Throwable {
        JsonNode unitJson = this.selectUnitInheritedRulesByTitle(unitTitle);
        JsonNode categoryJson = unitJson.get(category);
        if (categoryJson == null) {
            Fail.fail((String)("No such category " + category));
        }
        this.selectedInheritedCategoryResult = categoryJson;
    }

    @Then(value="^la cat\u00e9gorie contient (\\d+) r\u00e8gles et (\\d+) propri\u00e9t\u00e9s h\u00e9rit\u00e9es$")
    public void rule_category_rules_and_properties_count_check(int nbRules, int nbProperties) throws Throwable {
        Assertions.assertThat((Iterable)this.selectedInheritedCategoryResult.get("Rules")).hasSize(nbRules);
        Assertions.assertThat((Iterable)this.selectedInheritedCategoryResult.get("Properties")).hasSize(nbProperties);
    }

    @When(value="^je recherche les groupes d'objets$")
    public void search_object_groups() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectObjects(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
            this.facetResults = requestResponseOK.getFacetResults();
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectObjects return an error: " + vitamError.getCode()));
        }
    }

    @Then(value="^la cat\u00e9gorie contient une r\u00e8gle (.*) h\u00e9rit\u00e9e depuis l'unit\u00e9 (.*) avec pour m\u00e9tadonn\u00e9es$")
    public void check_rule_metadata(String ruleId, String unitTitle, DataTable dataTable) throws Throwable {
        String unitGuid = this.getUnitGuidByTitle(unitTitle);
        JsonNode rule = null;
        for (JsonNode foundRule : this.selectedInheritedCategoryResult.get("Rules")) {
            if (!foundRule.get("UnitId").asText().equals(unitGuid) || !foundRule.get("Rule").asText().equals(ruleId)) continue;
            rule = foundRule;
            break;
        }
        if (rule == null) {
            Fail.fail((String)("No such rule " + ruleId + " inherited from unit " + unitTitle));
        }
        DataTable transformedDataTable = this.getTransformedDataTable(dataTable);
        this.world.getAccessService().checkResultsForParticularData(rule, transformedDataTable);
    }

    @Then(value="^la cat\u00e9gorie contient une propri\u00e9t\u00e9 (.*) h\u00e9rit\u00e9e depuis l'unit\u00e9 (.*) avec pour m\u00e9tadonn\u00e9es$")
    public void check_property_metadata(String propertyName, String unitTitle, DataTable dataTable) throws Throwable {
        String unitGuid = this.getUnitGuidByTitle(unitTitle);
        JsonNode property = null;
        for (JsonNode foundProperty : this.selectedInheritedCategoryResult.get("Properties")) {
            if (!foundProperty.get("UnitId").asText().equals(unitGuid) || !foundProperty.get("PropertyName").asText().equals(propertyName)) continue;
            property = foundProperty;
            break;
        }
        if (property == null) {
            Fail.fail((String)("No such property " + propertyName + " inherited from unit " + unitTitle));
        }
        DataTable transformedDataTable = this.getTransformedDataTable(dataTable);
        this.world.getAccessService().checkResultsForParticularData(property, transformedDataTable);
    }

    @Then(value="^les m\u00e9tadonn\u00e9es de gestion correspondent au fichier json (.+)$")
    public void json_metadata_are_for_particular_result(String filename) throws Throwable {
        JsonNode expectedJson;
        ((ListAssert)Assertions.assertThat(this.world.getResults()).withFailMessage("Expecting single result", new Object[0])).hasSize(1);
        JsonNode foundNode = this.world.getResults().get(0).get(VitamFieldsHelper.management());
        ((IterableAssert)Assertions.assertThat((Iterable)foundNode).withFailMessage("No such field found " + filename, new Object[0])).isNotNull();
        Path file = Paths.get(this.world.getBaseDirectory(), filename);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            expectedJson = JsonHandler.getFromInputStream((InputStream)inputStream);
        }
        this.assertManagementJsonEquals(foundNode, expectedJson);
    }

    @Then(value="^les r\u00e8gles h\u00e9rit\u00e9s de l'unit\u00e9 (.*) correspondent au fichier json (.*)$")
    public void check_unit_inherited_rules_json(String unitTitle, String filename) throws Throwable {
        JsonNode expectedJson;
        JsonNode actualJson = this.selectUnitInheritedRulesByTitle(unitTitle);
        Path file = Paths.get(this.world.getBaseDirectory(), filename);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            String refJsonWithUnitTitles = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String refJsonWithUnitGuids = this.transformLoadedUnitTitleToGuid(refJsonWithUnitTitles);
            expectedJson = JsonHandler.getFromString((String)refJsonWithUnitGuids);
        }
        this.assertManagementJsonEquals(actualJson, expectedJson);
    }

    private void assertManagementJsonEquals(JsonNode actualJson, JsonNode expectedJson) {
        List<String> orderedKeys = Arrays.asList("PropertyName", "Rule", "UnitId");
        JsonSorter.sortJsonEntriesByKeys((JsonNode)actualJson, orderedKeys);
        JsonSorter.sortJsonEntriesByKeys((JsonNode)expectedJson, orderedKeys);
        String actual = JsonHandler.unprettyPrint((Object)actualJson);
        String expected = JsonHandler.unprettyPrint((Object)expectedJson);
        try {
            JsonAssert.assertJsonEquals((Object)expected, (Object)actual, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
        }
        catch (AssertionError e) {
            System.out.println("Actual  : " + actual);
            System.out.println("Expected: " + expected);
            throw e;
        }
    }

    private JsonNode selectUnitInheritedRulesByTitle(String unitTitle) {
        String unitGuid = this.selectLoadedUnitGuidByTitle(unitTitle);
        JsonNode unitJson = null;
        for (JsonNode result : this.world.getResults()) {
            if (!result.get(VitamFieldsHelper.id()).asText().equals(unitGuid)) continue;
            unitJson = result;
            break;
        }
        if (unitJson == null) {
            return (JsonNode)Fail.fail((String)("No such unit with id '" + unitGuid + "' (title: " + unitTitle + ") in result set"));
        }
        if (!unitJson.has(INHERITED_RULES)) {
            return (JsonNode)Fail.fail((String)"Expected inherited rules definition");
        }
        return unitJson.get(INHERITED_RULES);
    }

    @When(value="^je recherche une unit\u00e9 archivistique ayant un groupe d'objets et je recup\u00e8re son id et son objet$")
    public void search_one_object_group() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            Assertions.assertThat((List)requestResponseOK.getResults()).isNotEmpty();
            this.world.setResults(requestResponseOK.getResults());
            JsonNode unit = (JsonNode)requestResponseOK.getResults().iterator().next();
            this.world.setUnitId(unit.get("#id").asText());
            this.world.setObjectGroupId(unit.get("#object").asText());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je modifie les unit\u00e9s archivistiques$")
    public void update_archive_unit() throws Throwable {
        String unitId;
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        savedUnit = unitId = this.getValueFromResult("#id", 0);
        RequestResponse requestResponse = this.world.getAccessClient().updateUnitbyId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON, unitId);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            this.world.setResults(requestResponseOK.getResults());
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectUnit return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je modifie l'unit\u00e9 archivistique avec la requete$")
    public void update_archive_unit_with_query(String query) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)query);
        this.requestResponse = this.world.getAccessClient().updateUnitbyId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()), queryJSON, savedUnit);
    }

    @When(value="^je recherche les groupes d'objets des unit\u00e9s archivistiques$")
    public void search_archive_unit_object_group() throws Throwable {
        RequestResponse requestResponseUnit;
        ObjectNode queryJSON = (ObjectNode)JsonHandler.getFromString((String)this.world.getQuery());
        if (queryJSON.get("$projection") == null) {
            queryJSON.set("$projection", (JsonNode)JsonHandler.createObjectNode());
        }
        if (queryJSON.get("$projection").get("$fields") == null) {
            ((ObjectNode)queryJSON.get("$projection")).set("$fields", (JsonNode)JsonHandler.createObjectNode());
        }
        if (queryJSON.get("$projection").get("$fields").get("#object") == null) {
            ((ObjectNode)queryJSON.get("$projection").get("$fields")).put("#object", 1);
        }
        if ((requestResponseUnit = this.world.getAccessClient().selectUnits(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)queryJSON)).isOk()) {
            RequestResponseOK responseOK = (RequestResponseOK)requestResponseUnit;
            List unitResults = responseOK.getResults();
            RequestResponseOK objectGroupsResponseOK = new RequestResponseOK();
            for (JsonNode unitResult : unitResults) {
                RequestResponse responseObjectGroup = this.world.getAccessClient().selectObjectMetadatasByUnitId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)new SelectMultiQuery().getFinalSelectById(), unitResult.get("#id").asText());
                if (responseObjectGroup.isOk()) {
                    List objectGroupResults = ((RequestResponseOK)responseObjectGroup).getResults();
                    if (objectGroupResults == null || objectGroupResults.isEmpty()) continue;
                    objectGroupsResponseOK.addAllResults(objectGroupResults);
                    continue;
                }
                VitamError vitamError = (VitamError)responseObjectGroup;
                Fail.fail((String)("request selectObject return an error: " + vitamError.getCode()));
            }
            this.world.setResults(objectGroupsResponseOK.getResults());
        } else {
            VitamError vitamError = (VitamError)requestResponseUnit;
            Fail.fail((String)("request selectUnit for GOT return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche les groupes d'objets de l'unit\u00e9 archivistique dont le titre est (.*)$")
    public void search_archive_unit_object_group(String title) throws Throwable {
        String unitId = this.world.getAccessService().findUnitGUIDByTitleAndOperationId(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId(), title);
        RequestResponse responseObjectGroup = this.world.getAccessClient().selectObjectMetadatasByUnitId(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), (JsonNode)new SelectMultiQuery().getFinalSelectById(), unitId);
        if (responseObjectGroup.isOk()) {
            List results = ((RequestResponseOK)responseObjectGroup).getResults();
            this.world.setResults(results);
        } else {
            VitamError vitamError = (VitamError)responseObjectGroup;
            Fail.fail((String)("request selectObject return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^je recherche les journaux d'op\u00e9ration$")
    public void search_logbook_operation() throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().selectOperations(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
        if (requestResponse.isOk()) {
            RequestResponseOK requestResponseOK = (RequestResponseOK)requestResponse;
            List results = requestResponseOK.getResultsAsJsonNodes();
            this.world.setResults(results);
        } else {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request selectOperation return an error: " + vitamError.getCode()));
        }
    }

    @When(value="^(?:je |j')(.*) le fichier nomm\u00e9 (.*) (?:pour|dans) le r\u00e9f\u00e9rentiel (.*)$")
    public void i_import_or_check_the_file_for_the_admin_collection(String action, String filename, String collection) throws Throwable {
        Path file = Paths.get(this.world.getBaseDirectory(), filename);
        try (InputStream inputStream = Files.newInputStream(file, StandardOpenOption.READ);){
            AdminCollections adminCollection = AdminCollections.valueOf((String)collection);
            int status = 0;
            ArrayList<JsonNode> results = new ArrayList<JsonNode>();
            if ("v\u00e9rifie".equals(action)) {
                status = this.actionVerify(inputStream, adminCollection);
            } else if ("importe".equals(action)) {
                status = this.actionImport(filename, inputStream, adminCollection);
            }
            if (status != 0) {
                results.add((JsonNode)JsonHandler.createObjectNode().put("Code", String.valueOf(status)));
            }
            this.world.setResults(results);
        }
        catch (Exception e) {
            LOGGER.warn("Referentiels collection already imported", (Throwable)e);
        }
    }

    private int actionVerify(InputStream inputStream, AdminCollections adminCollection) throws VitamClientException {
        int status = 0;
        VitamContext context = new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId());
        if (AdminCollections.FORMATS.equals((Object)adminCollection)) {
            status = this.world.getAdminClient().checkFormats(context, inputStream).getStatus();
        } else if (AdminCollections.RULES.equals((Object)adminCollection)) {
            status = this.world.getAdminClient().checkRules(context, inputStream).getStatus();
        } else if (AdminCollections.AGENCIES.equals((Object)adminCollection)) {
            status = this.world.getAdminClient().checkAgencies(context, inputStream).getStatus();
        }
        return status;
    }

    private int actionImport(String filename, InputStream inputStream, AdminCollections adminCollection) throws AccessExternalClientException, InvalidParseOperationException {
        int status = 0;
        RequestResponse response = null;
        if (AdminCollections.FORMATS.equals((Object)adminCollection)) {
            response = this.world.getAdminClient().createFormats(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, filename);
            status = response.getHttpCode();
        } else if (AdminCollections.RULES.equals((Object)adminCollection)) {
            response = this.world.getAdminClient().createRules(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, filename);
            status = response.getHttpCode();
        } else if (AdminCollections.AGENCIES.equals((Object)adminCollection)) {
            response = this.world.getAdminClient().createAgencies(new VitamContext(Integer.valueOf(this.world.getTenantId())).setApplicationSessionId(this.world.getApplicationSessionId()), inputStream, filename);
            status = response.getHttpCode();
        }
        if (response != null) {
            String operationId = response.getHeaderString("X-Request-Id");
            this.world.setOperationId(operationId);
        }
        return status;
    }

    @When(value="^je recherche les donn\u00e9es dans le r\u00e9f\u00e9rentiel (.*)$")
    public void search_in_admin_collection(String collection) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        AdminCollections adminCollection = AdminCollections.valueOf((String)collection);
        RequestResponse requestResponse = switch (adminCollection) {
            case AdminCollections.FORMATS -> this.world.getAdminClient().findFormats(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.RULES -> this.world.getAdminClient().findRules(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.ACCESS_CONTRACTS -> this.world.getAdminClient().findAccessContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.INGEST_CONTRACTS -> this.world.getAdminClient().findIngestContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.MANAGEMENT_CONTRACTS -> this.world.getAdminClient().findManagementContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.CONTEXTS -> this.world.getAdminClient().findContexts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.PROFILE -> this.world.getAdminClient().findProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.ARCHIVE_UNIT_PROFILE -> this.world.getAdminClient().findArchiveUnitProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.SECURITY_PROFILES -> this.world.getAdminClient().findSecurityProfiles(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            case AdminCollections.AGENCIES -> this.world.getAdminClient().findAgencies(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryJSON);
            default -> throw new RuntimeException("Unknown collection " + String.valueOf(adminCollection));
        };
        if (requestResponse != null && requestResponse.isOk()) {
            List results = ((RequestResponseOK)requestResponse).getResultsAsJsonNodes();
            this.world.setResults(results);
        } else if (requestResponse != null) {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request findDocuments return an error: " + vitamError.getCode()));
        } else {
            Fail.fail((String)("Collection not found " + collection));
        }
    }

    private String get_contract_id_by_name(String name) throws InvalidParseOperationException, VitamClientException {
        String QUERY = "{\"$query\":{\"$and\":[{\"$eq\":{\"Name\":\"" + name + "\"}}]},\"$filter\":{},\"$projection\":{}}";
        JsonNode queryDsl = JsonHandler.getFromString((String)QUERY);
        RequestResponse requestResponse = this.world.getAdminClient().findAccessContracts(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(null).setApplicationSessionId(this.world.getApplicationSessionId()), queryDsl);
        if (requestResponse.isOk()) {
            return ((AccessContractModel)((RequestResponseOK)requestResponse).getFirstResult()).getId();
        }
        throw new VitamClientException("Access contract was found");
    }

    @When(value="^je lance une analyse d'\u00e9limination avec pour date le (.*) qui se termine avec le statut (.*)$")
    public void start_elimination_analysis(String analysisDate, String status) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().startEliminationAnalysis(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), new EliminationRequestBody(analysisDate, queryJSON));
        if (!requestResponse.isOk()) {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request startEliminationAnalysis return an error: " + vitamError.getCode()));
        }
        String eliminationOperationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setEliminationOperationId(eliminationOperationId);
        this.checkOperationStatus(eliminationOperationId, StatusCode.valueOf((String)status));
    }

    @When(value="^je lance une \u00e9limination d\u00e9finitive avec pour date le (.*) qui se termine avec le statut (.*)$")
    public void start_elimination_action(String deleteDate, String status) throws Throwable {
        JsonNode queryJSON = JsonHandler.getFromString((String)this.world.getQuery());
        RequestResponse requestResponse = this.world.getAccessClient().startEliminationAction(new VitamContext(Integer.valueOf(this.world.getTenantId())).setAccessContract(this.world.getContractId()).setApplicationSessionId(this.world.getApplicationSessionId()), new EliminationRequestBody(deleteDate, queryJSON));
        if (!requestResponse.isOk()) {
            VitamError vitamError = (VitamError)requestResponse;
            Fail.fail((String)("request startEliminationAction return an error: " + vitamError.getCode()));
        }
        String eliminationOperationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setEliminationOperationId(eliminationOperationId);
        this.checkOperationStatus(eliminationOperationId, StatusCode.valueOf((String)status));
    }

    @When(value="^je lance la v\u00e9rification des journaux de s\u00e9curisation$")
    public void linked_check_traceability() throws VitamException {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode jsonNode = JsonHandler.getFromString((String)query);
        RequestResponse response = this.world.getAdminClient().checkTraceabilityOperations(vitamContext, jsonNode);
        Assertions.assertThat((boolean)response.isOk()).isTrue();
        String operationId = response.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Assertions.fail((String)"dip processing not finished. Timeout exceeded.");
        }
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
    }

    @Etantdonn\u00e9(value="l'ingest date d'au moins {int} secondes")
    public void wait_old_ingest_for_lfc_traceability(Integer duration) {
        this.runInVitamThread(() -> {
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.world.getTenantId()));
            RequestResponse<LogbookOperation> requestResponse = this.world.getLogbookService().getLogbookOperation(this.world.getAccessClient(), this.world.getTenantId(), this.world.getContractId(), this.world.getApplicationSessionId(), this.world.getOperationId());
            if (!(requestResponse instanceof RequestResponseOK)) {
                Assertions.fail((String)("could not retrieve logbook operation for " + this.world.getOperationId()));
                return;
            }
            RequestResponseOK logbookResponseOK = (RequestResponseOK)requestResponse;
            LogbookOperation master = (LogbookOperation)logbookResponseOK.getFirstResult();
            if (master == null) {
                Assertions.fail((String)("could not retrieve logbook operation for " + this.world.getOperationId()));
                return;
            }
            LogbookEventOperation lastEvent = (LogbookEventOperation)Iterables.getLast((Iterable)master.getEvents());
            int elapsed = (int)Duration.between(LocalDateUtil.parseMongoFormattedDate((String)lastEvent.getEvDateTime()), LocalDateUtil.now()).getSeconds();
            int remainingDurationToSleep = duration - elapsed + 1;
            if (remainingDurationToSleep > 0) {
                LOGGER.warn("Logbook is not old enough... Waiting " + remainingDurationToSleep + " seconds");
                TimeUnit.SECONDS.sleep(remainingDurationToSleep);
                LOGGER.warn("Ingest should be old enough for traceability");
            }
        });
    }

    @When(value="^je lance l'op\u00e9ration de reclassification$")
    public void reclassification() throws Exception {
        VitamContext vitamContext = new VitamContext(Integer.valueOf(this.world.getTenantId()));
        vitamContext.setApplicationSessionId(this.world.getApplicationSessionId());
        vitamContext.setAccessContract(this.world.getContractId());
        String query = this.world.getQuery();
        JsonNode queryString = JsonHandler.getFromString((String)query);
        RequestResponse requestResponse = this.world.getAccessClient().reclassification(vitamContext, queryString);
        Assertions.assertThat((boolean)requestResponse.isOk()).isTrue();
        String operationId = requestResponse.getHeaderString("X-Request-Id");
        this.world.setOperationId(operationId);
        ((AbstractStringAssert)Assertions.assertThat((String)operationId).as(String.format("%s not found for request", "X-Request-Id"), new Object[0])).isNotNull();
        VitamPoolingClient vitamPoolingClient = new VitamPoolingClient((OperationStatusClient)this.world.getAdminClient());
        boolean processTimeout = vitamPoolingClient.wait(this.world.getTenantId(), operationId, ProcessState.COMPLETED, 100, 1000L, TimeUnit.MILLISECONDS);
        if (!processTimeout) {
            Assertions.fail((String)"reclassification processing not finished. Timeout exceeded.");
        }
    }
}

