/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functionaltest.cucumber.report;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functionaltest.cucumber.report.Report;
import fr.gouv.vitam.functionaltest.cucumber.report.Reports;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.WriteEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class VitamReporter
implements ConcurrentEventListener {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamReporter.class);
    private static final String RESET_COLOR = "\u001b[0m";
    private static final String RED_COLOR = "\u001b[0;31m";
    private static final String GREEN_COLOR = "\u001b[0;32m";
    private final PrintStream out;
    private Reports reports = null;
    private Report report = null;
    private final Map<URI, String> featureNames = new HashMap<URI, String>();

    public VitamReporter(OutputStream out) {
        this.out = new PrintStream(out, false, StandardCharsets.UTF_8);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceParsed.class, this::sourceParsed);
        publisher.registerHandlerFor(TestRunStarted.class, this::runStarted);
        publisher.registerHandlerFor(TestRunFinished.class, this::runFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::caseFinished);
        publisher.registerHandlerFor(TestCaseStarted.class, this::caseStarted);
        publisher.registerHandlerFor(WriteEvent.class, this::writeEvent);
    }

    private void sourceParsed(TestSourceParsed event) {
        if (event.getNodes().size() != 1) {
            throw new CucumberException("There should be exactly one root node");
        }
        Node rootNode = (Node)event.getNodes().iterator().next();
        if (!(rootNode instanceof Feature)) {
            throw new CucumberException("Root node should be a feature");
        }
        Feature feature = (Feature)rootNode;
        this.featureNames.put(feature.getUri(), feature.getName().orElse(""));
    }

    private void runStarted(TestRunStarted event) {
        this.reports = new Reports();
    }

    private void runFinished(TestRunFinished event) {
        this.reports.setEnd(LocalDateTime.ofInstant(event.getInstant(), ZoneOffset.UTC));
        String finalReport = JsonHandler.prettyPrint((Object)this.reports);
        this.out.print(finalReport);
        boolean success = this.reports.getReports().stream().allMatch(Report::isOK);
        VitamReporter.logEvents("\n\n\n#######################\nFULL REPORT:\n#######################\n\n" + finalReport, success);
    }

    private void caseStarted(TestCaseStarted event) {
        this.report = new Report();
        this.report.setStart(LocalDateTime.ofInstant(event.getInstant(), ZoneOffset.UTC));
        this.report.setFeature(this.featureNames.get(event.getTestCase().getUri()));
    }

    private void caseFinished(TestCaseFinished event) {
        TestCase testCase = event.getTestCase();
        this.report.setDescription(testCase.getName());
        this.report.setTags(testCase.getTags().stream().map(tag -> tag.substring(1)).collect(Collectors.toList()));
        this.report.setEnd(LocalDateTime.ofInstant(event.getInstant(), ZoneOffset.UTC));
        Result result = event.getResult();
        Throwable error = result.getError();
        if (error != null) {
            this.report.addError(error.toString());
        }
        this.reports.add(this.report);
        String msg = "\n" + this.report.getFeature() + " - " + this.report.getDescription() + "\n" + JsonHandler.prettyPrint((Object)this.report);
        VitamReporter.logEvents(msg, result.getStatus().isOk());
    }

    private void writeEvent(WriteEvent writeEvent) {
        this.report.setOperationId(writeEvent.getText());
    }

    private static void logEvents(String msg, boolean success) {
        if (success) {
            LOGGER.info(msg);
            System.out.println(GREEN_COLOR + msg + RESET_COLOR);
        } else {
            LOGGER.warn(msg);
            System.out.println(RED_COLOR + msg + RESET_COLOR);
        }
    }
}

