/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.workspace.driver;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.client.configuration.SSLConfiguration;
import fr.gouv.vitam.common.client.configuration.SSLKey;
import fr.gouv.vitam.common.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.driver.AbstractConnection;
import fr.gouv.vitam.storage.driver.AbstractDriver;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.offers.workspace.driver.ConnectionImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

public class DriverImpl
extends AbstractDriver {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DriverImpl.class);
    private static final String DRIVER_NAME = "DefaultOfferDriver";
    private static final String RESOURCE_PATH = "/offer/v1";
    private static final DriverImpl DRIVER_IMPL = new DriverImpl();

    public static DriverImpl getInstance() {
        return DRIVER_IMPL;
    }

    protected VitamClientFactoryInterface<? extends AbstractConnection> addInternalOfferAsFactory(StorageOffer offer, Properties parameters) {
        return new DriverClientFactory(DriverImpl.changeConfigurationFile(offer), RESOURCE_PATH, parameters);
    }

    @Nonnull
    public Connection connect(String offerId) throws StorageDriverException {
        ParametersChecker.checkParameter((String)"The parameter offer is required", (String[])new String[]{offerId});
        VitamClientFactoryInterface factory = (VitamClientFactoryInterface)this.connectionFactories.get(offerId);
        if (factory == null) {
            LOGGER.error("Driver {} has no Offer named {}", (Object)this.getName(), (Object)offerId);
            StorageNotFoundException exception = new StorageNotFoundException("Driver " + this.getName() + " has no Offer named " + offerId);
            throw new StorageDriverException("Driver " + this.getName() + " with Offer " + offerId, exception.getMessage(), false, (Throwable)exception);
        }
        return (Connection)factory.getClient();
    }

    private static ClientConfiguration changeConfigurationFile(StorageOffer offer) {
        ParametersChecker.checkParameter((String)"StorageOffer cannot be null", (Object[])new Object[]{offer});
        try {
            URI url = new URI(offer.getBaseUrl());
            Map param = offer.getParameters();
            if ("https".equalsIgnoreCase(url.getScheme()) || param != null && param.get("keyStore-keyPath") != null) {
                ArrayList<SSLKey> keystoreList = new ArrayList<SSLKey>();
                ArrayList<SSLKey> truststoreList = new ArrayList<SSLKey>();
                keystoreList.add(new SSLKey((String)param.get("keyStore-keyPath"), (String)param.get("keyStore-keyPassword")));
                truststoreList.add(new SSLKey((String)param.get("trustStore-keyPath"), (String)param.get("trustStore-keyPassword")));
                return new SecureClientConfigurationImpl(url.getHost(), url.getPort(), true, new SSLConfiguration(keystoreList, truststoreList));
            }
            return new ClientConfigurationImpl(url.getHost(), url.getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot parse the URI: ", e);
        }
    }

    public String getName() {
        return DRIVER_NAME;
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    static class DriverClientFactory
    extends VitamClientFactory<ConnectionImpl> {
        final Properties parameters;

        DriverClientFactory(ClientConfiguration configuration, String resourcePath, Properties parameters) {
            super(configuration, resourcePath);
            this.enableUseAuthorizationFilter();
            this.parameters = parameters;
        }

        public ConnectionImpl getClient() {
            return new ConnectionImpl(DriverImpl.DRIVER_NAME, (VitamClientFactoryInterface<? extends AbstractConnection>)this);
        }
    }
}

