/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.reconstruction;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.metrics.GaugeUtils;
import fr.gouv.vitam.logbook.common.server.reconstruction.LogbookReconstructionMetricsCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LogbookReconstructionMetrics {
    private static final String TENANT_LABEL = "tenant";
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);

    private LogbookReconstructionMetrics() {
    }

    public static synchronized void initialize(LogbookReconstructionMetricsCache reconstructionMetricsCache) {
        if (isInitialized.get()) {
            return;
        }
        GaugeUtils.createCustomGauge((String)"vitam_logbook_reconstruction_operation_latency_seconds", (String)"Logbook operation reconstruction latency (is seconds)", List.of(TENANT_LABEL), () -> LogbookReconstructionMetrics.collectMetrics(reconstructionMetricsCache)).register();
        isInitialized.set(true);
    }

    private static Map<List<String>, Double> collectMetrics(LogbookReconstructionMetricsCache reconstructionMetricsCache) {
        HashMap<List<String>, Double> metricsByLabelValues = new HashMap<List<String>, Double>();
        for (Integer tenant : VitamConfiguration.getTenants()) {
            Duration durationSinceLastReconstruction = reconstructionMetricsCache.getLogbookOperationReconstructionLatency(tenant);
            List<String> labelValues = List.of(Integer.toString(tenant));
            metricsByLabelValues.put(labelValues, LogbookReconstructionMetrics.getReconstructionLatency(durationSinceLastReconstruction));
        }
        return metricsByLabelValues;
    }

    private static double getReconstructionLatency(Duration durationSinceLastReconstruction) {
        return durationSinceLastReconstruction == null ? Double.POSITIVE_INFINITY : Math.max(0.0, (double)durationSinceLastReconstruction.toSeconds());
    }
}

