/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;

public enum LogbookMongoDbName {
    eventIdentifier("evId", LogbookParameterName.eventIdentifier),
    parentEventIdentifier("evParentId", LogbookParameterName.parentEventIdentifier),
    eventType("evType", LogbookParameterName.eventType),
    eventDateTime("evDateTime", LogbookParameterName.eventDateTime),
    eventDetailData("evDetData", LogbookParameterName.eventDetailData),
    eventIdentifierProcess("evIdProc", LogbookParameterName.eventIdentifierProcess),
    eventTypeProcess("evTypeProc", LogbookParameterName.eventTypeProcess),
    outcome("outcome", LogbookParameterName.outcome),
    outcomeDetail("outDetail", LogbookParameterName.outcomeDetail),
    outcomeDetailMessage("outMessg", LogbookParameterName.outcomeDetailMessage),
    agentIdentifier("agId", LogbookParameterName.agentIdentifier),
    agentIdentifierApplication("agIdApp", LogbookParameterName.agentIdentifierApplication),
    agentIdentifierPersonae("agIdPers", LogbookParameterName.agentIdentifierPersonae),
    agentIdentifierApplicationSession("evIdAppSession", LogbookParameterName.agentIdentifierApplicationSession),
    eventIdentifierRequest("evIdReq", LogbookParameterName.eventIdentifierRequest),
    agIdExt("agIdExt", LogbookParameterName.agIdExt),
    rightsStatementIdentifier("rightsStatementIdentifier", LogbookParameterName.rightsStatementIdentifier),
    objectIdentifier("obId", LogbookParameterName.objectIdentifier),
    objectIdentifierRequest("obIdReq", LogbookParameterName.objectIdentifierRequest),
    objectIdentifierIncome("obIdIn", LogbookParameterName.objectIdentifierIncome);

    private final String dbname;
    private final LogbookParameterName parameter;

    private LogbookMongoDbName(String dbname, LogbookParameterName parameter) {
        this.dbname = dbname;
        this.parameter = parameter;
    }

    public final String getDbname() {
        return this.dbname;
    }

    public final LogbookParameterName getLogbookParameterName() {
        return this.parameter;
    }

    public static final LogbookMongoDbName getLogbookMongoDbName(LogbookParameterName name) {
        return LogbookMongoDbName.valueOf(name.toString());
    }

    public static final LogbookMongoDbName getFromDbname(String name) {
        switch (name) {
            case "agId": {
                return agentIdentifier;
            }
            case "agIdApp": {
                return agentIdentifierApplication;
            }
            case "evIdAppSession": {
                return agentIdentifierApplicationSession;
            }
            case "agIdExt": {
                return agIdExt;
            }
            case "rightsStatementIdentifier": {
                return rightsStatementIdentifier;
            }
            case "evDateTime": {
                return eventDateTime;
            }
            case "evId": {
                return eventIdentifier;
            }
            case "evParentId": {
                return parentEventIdentifier;
            }
            case "evIdProc": {
                return eventIdentifierProcess;
            }
            case "evDetData": {
                return eventDetailData;
            }
            case "evIdReq": {
                return eventIdentifierRequest;
            }
            case "evType": {
                return eventType;
            }
            case "evTypeProc": {
                return eventTypeProcess;
            }
            case "obId": {
                return objectIdentifier;
            }
            case "obIdIn": {
                return objectIdentifierIncome;
            }
            case "obIdReq": {
                return objectIdentifierRequest;
            }
            case "outDetail": {
                return outcomeDetail;
            }
            case "outMessg": {
                return outcomeDetailMessage;
            }
            case "outcome": {
                return outcome;
            }
            case "agIdPers": {
                return agentIdentifierPersonae;
            }
        }
        throw new IllegalArgumentException("Unknown name: " + name);
    }
}

