/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.config.LogbookConfiguration;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookElasticsearchAccess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookElasticsearchAccessFactory;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbAccessImpl;
import fr.gouv.vitam.logbook.common.server.exception.LogbookException;
import java.util.ArrayList;

public final class LogbookMongoDbAccessFactory {
    public static LogbookMongoDbAccessImpl create(LogbookConfiguration configuration, OntologyLoader ontologyLoader, ElasticsearchLogbookIndexManager indexManager) {
        LogbookElasticsearchAccess esClient;
        ParametersChecker.checkParameter((String)"configuration", (Object[])new Object[]{configuration});
        try {
            esClient = new LogbookElasticsearchAccessFactory().create(configuration, indexManager);
        }
        catch (LogbookException e1) {
            throw new IllegalArgumentException((Throwable)((Object)e1));
        }
        ArrayList classList = new ArrayList();
        for (LogbookCollections e : (LogbookCollections[])LogbookCollections.class.getEnumConstants()) {
            classList.add(e.getClasz());
        }
        MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)configuration, classList);
        return new LogbookMongoDbAccessImpl(mongoClient, configuration.getDbName(), false, esClient, ontologyLoader);
    }
}

