/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUIDReader;
import java.util.Map;
import org.bson.Document;

public abstract class LogbookDocument<E>
extends Document {
    private static final long serialVersionUID = 4051636259888359930L;
    public static final String ID = "_id";
    public static final String TENANT_ID = "_tenant";
    public static final String VERSION = "_v";
    public static final String LAST_PERSISTED_DATE = "_lastPersistedDate";
    public static final String EVENTS = "events";
    public static final String EVENT_DETAILS = "evDetData";

    public LogbookDocument() {
    }

    public LogbookDocument(String content) {
        super((Map)Document.parse((String)content));
        this.checkId();
    }

    public LogbookDocument(Document content) {
        super((Map)content);
        this.checkId();
    }

    LogbookDocument<E> checkId() {
        String id = this.getId();
        if (id == null) {
            id = this.getString(ID);
        }
        try {
            GUIDReader.getGUID((String)id);
        }
        catch (InvalidGuidOperationException e) {
            throw new IllegalArgumentException("ID is not a GUID: " + id, e);
        }
        return this;
    }

    public abstract String getId();

    public final int getTenantId() {
        return this.getInteger(TENANT_ID);
    }

    public final int getVersion() {
        return this.getInteger(VERSION);
    }

    public String toStringDirect() {
        return super.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + super.toString();
    }
}

