/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server.database.collections;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.collections.VitamCollectionHelper;
import fr.gouv.vitam.common.database.collections.VitamDescriptionLoader;
import fr.gouv.vitam.common.database.collections.VitamDescriptionResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.model.ElasticsearchCollections;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookElasticsearchAccess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroupInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnitInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public enum LogbookCollections {
    OPERATION(LogbookOperation.class),
    LIFECYCLE_UNIT(LogbookLifeCycleUnit.class),
    LIFECYCLE_OBJECTGROUP(LogbookLifeCycleObjectGroup.class),
    LIFECYCLE_UNIT_IN_PROCESS(LogbookLifeCycleUnitInProcess.class),
    LIFECYCLE_OBJECTGROUP_IN_PROCESS(LogbookLifeCycleObjectGroupInProcess.class);

    private final VitamDescriptionResolver vitamDescriptionResolver;
    private final VitamCollection<? extends VitamDocument<?>> vitamCollection;
    public static final String[] MULTI_TENANT_EV_TYPES;

    private LogbookCollections(Class<? extends VitamDocument<?>> clasz) {
        VitamDescriptionLoader vitamDescriptionLoader = new VitamDescriptionLoader(clasz.getSimpleName());
        this.vitamDescriptionResolver = vitamDescriptionLoader.getVitamDescriptionResolver();
        this.vitamCollection = VitamCollectionHelper.getCollection(clasz, (boolean)true, (boolean)false, (String)"", (VitamDescriptionResolver)this.vitamDescriptionResolver);
    }

    public static List<Class<?>> getClasses() {
        ArrayList classes = new ArrayList();
        for (LogbookCollections collection : LogbookCollections.values()) {
            classes.add(collection.getClasz());
        }
        return classes;
    }

    protected void initialize(MongoDatabase db, boolean recreate) {
        this.vitamCollection.initialize(db, recreate);
    }

    protected void initialize(LogbookElasticsearchAccess esClient) {
        this.vitamCollection.initialize((ElasticsearchAccess)esClient);
    }

    public String getName() {
        return this.vitamCollection.getName();
    }

    public <T extends Document> MongoCollection<T> getCollection() {
        return this.vitamCollection.getCollection();
    }

    public <T extends VitamDocument<?>> VitamCollection<T> getVitamCollection() {
        return this.vitamCollection;
    }

    protected Class<? extends VitamDocument<?>> getClasz() {
        return this.vitamCollection.getClasz();
    }

    public LogbookElasticsearchAccess getEsClient() {
        return (LogbookElasticsearchAccess)this.vitamCollection.getEsClient();
    }

    public VitamDescriptionResolver getVitamDescriptionResolver() {
        return this.vitamDescriptionResolver;
    }

    public ElasticsearchCollections getElasticsearchCollection() {
        switch (this) {
            case OPERATION: {
                return ElasticsearchCollections.OPERATION;
            }
            case LIFECYCLE_UNIT: 
            case LIFECYCLE_UNIT_IN_PROCESS: 
            case LIFECYCLE_OBJECTGROUP: 
            case LIFECYCLE_OBJECTGROUP_IN_PROCESS: {
                throw new IllegalStateException("No ES index for collection " + String.valueOf((Object)this));
            }
        }
        throw new IllegalStateException("Unknown collection " + String.valueOf((Object)this));
    }

    static {
        MULTI_TENANT_EV_TYPES = new String[]{Contexts.IMPORT_ONTOLOGY.getEventType(), Contexts.REFERENTIAL_FORMAT_IMPORT.getEventType(), Contexts.REFRENTIAL_FORMAT_DELETE.getEventType()};
    }
}

