/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.common.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.mongodb.VitamMongoCursor;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycle;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroup;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroupInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnit;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnitInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookExecutionException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import java.util.List;

public interface LogbookDbAccess {
    public void close();

    public long getLogbookOperationSize() throws LogbookDatabaseException, LogbookNotFoundException;

    public long getLogbookLifeCyleUnitSize() throws LogbookDatabaseException, LogbookNotFoundException;

    public long getLogbookLifeCyleObjectGroupSize();

    public boolean existsLogbookOperation(String var1) throws LogbookDatabaseException;

    public boolean existsLogbookLifeCycleUnit(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public boolean existsLogbookLifeCycleObjectGroup(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public LogbookOperation getLogbookOperationById(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public LogbookOperation getLogbookOperationById(String var1, JsonNode var2, boolean var3, boolean var4) throws LogbookDatabaseException, LogbookNotFoundException;

    public void updateLogbookLifeCycleUnit(String var1, String var2, LogbookLifeCycleUnitParameters var3) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void updateLogbookLifeCycleUnit(String var1, String var2, LogbookLifeCycleUnitParameters var3, boolean var4) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void updateLogbookLifeCycleObjectGroup(String var1, String var2, LogbookLifeCycleObjectGroupParameters var3) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void updateLogbookLifeCycleObjectGroup(String var1, String var2, LogbookLifeCycleObjectGroupParameters var3, boolean var4) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void rollbackLogbookLifeCycleUnit(String var1, String var2) throws LogbookDatabaseException, LogbookNotFoundException;

    public void rollbackLogbookLifeCycleObjectGroup(String var1, String var2) throws LogbookDatabaseException, LogbookNotFoundException;

    public void createLogbookOperation(String var1, LogbookOperationParameters ... var2) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void createLogbookLifeCycleUnit(String var1, LogbookLifeCycleUnitParameters ... var2) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void createLogbookLifeCycleObjectGroup(String var1, LogbookLifeCycleObjectGroupParameters ... var2) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateLogbookOperation(String var1, LogbookOperationParameters ... var2) throws LogbookDatabaseException, LogbookNotFoundException;

    public void updateLogbookLifeCycleUnit(LogbookLifeCycleUnitParameters ... var1) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public void updateLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupParameters ... var1) throws LogbookDatabaseException, LogbookNotFoundException, LogbookAlreadyExistsException;

    public VitamMongoCursor<LogbookOperation> getLogbookOperations(JsonNode var1, boolean var2) throws LogbookDatabaseException, VitamDBException;

    public VitamMongoCursor<LogbookOperation> getLogbookOperations(JsonNode var1, boolean var2, boolean var3) throws LogbookDatabaseException, VitamDBException;

    public LogbookLifeCycle<?> getOneLogbookLifeCycle(JsonNode var1, boolean var2, LogbookCollections var3) throws LogbookDatabaseException, LogbookNotFoundException, VitamDBException;

    public MongoCursor<LogbookLifeCycle<?>> getLogbookLifeCycles(JsonNode var1, boolean var2, LogbookCollections var3) throws LogbookDatabaseException, LogbookNotFoundException, VitamDBException;

    public MongoCursor<LogbookLifeCycleUnit> getLogbookLifeCycleUnitsFull(LogbookCollections var1, Select var2) throws LogbookDatabaseException;

    public MongoCursor<LogbookLifeCycleObjectGroup> getLogbookLifeCycleObjectGroupsFull(LogbookCollections var1, Select var2) throws LogbookDatabaseException;

    @VisibleForTesting
    public void deleteCollectionForTesting(LogbookCollections var1) throws DatabaseException, LogbookExecutionException;

    public LogbookLifeCycleUnitInProcess getLogbookLifeCycleUnitInProcess(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public LogbookLifeCycleObjectGroupInProcess getLogbookLifeCycleObjectGroupInProcess(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public void createLogbookLifeCycleUnit(LogbookLifeCycleUnitInProcess var1) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void createLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupInProcess var1) throws LogbookDatabaseException, LogbookAlreadyExistsException;

    public void updateLogbookLifeCycleUnit(LogbookLifeCycleUnitInProcess var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public void updateLogbookLifeCycleObjectGroup(LogbookLifeCycleObjectGroupInProcess var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public void rollBackUnitLifeCyclesByOperation(String var1) throws LogbookNotFoundException, LogbookDatabaseException;

    public void rollBackObjectGroupLifeCyclesByOperation(String var1) throws LogbookNotFoundException, LogbookDatabaseException;

    public long getLogbookLifeCyleUnitInProcessSize();

    public long getLogbookLifeCyleObjectGroupInProcessSize();

    public boolean existsLogbookLifeCycleUnitInProcess(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public boolean existsLogbookLifeCycleObjectGroupInProcess(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public String getInfo();

    public void bulkInsert(String var1, LogbookCollections var2, List<? extends LogbookLifeCycleModel> var3) throws DatabaseException;

    public void updateLogbookLifeCycleBulk(LogbookCollections var1, List<LogbookLifeCycleParametersBulk> var2);
}

