/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.audit.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoClient;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.api.impl.VitamElasticsearchRepository;
import fr.gouv.vitam.common.database.api.impl.VitamMongoRepository;
import fr.gouv.vitam.common.database.server.OplogReader;
import fr.gouv.vitam.common.database.server.mongodb.MongoDbAccess;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.server.application.configuration.DataConsistencyAuditConfig;
import fr.gouv.vitam.common.server.application.configuration.DbConfiguration;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import fr.gouv.vitam.common.server.application.configuration.MongoDbShard;
import fr.gouv.vitam.common.server.application.configuration.MongoDbShardConf;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.ObjectGroup;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.BsonTimestamp;
import org.bson.Document;

public class MetadataAuditService {
    private static final String CONTEXT_METADATA_AUDIT = "METADATA_AUDIT";
    private static final String DATABASE_METADATA_AUDIT = "METADATA_AUDIT_DATABASE";
    private static final String LOGBOOK_METADATA_AUDIT = "METADATA_AUDIT_LOGBOOK";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataAuditService.class);
    private static final String AUDIT_CONTAINER_NAME = "dataConsistencyAuditContainer";
    private static final String CODE_VITAM = "code_vitam";
    private static final String AUDIT_DATA_CONSISTENCY_EVT = "DATA_CONSISTENCY_AUDIT";
    private static final String DB_NAME = "admin";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private final ElasticsearchMetadataIndexManager indexManager;
    private static final AlertService alertService = new AlertServiceImpl();
    private VitamElasticsearchRepository elasticsearchUnitsRepository;
    private VitamElasticsearchRepository elasticsearchGotRepository;
    private VitamMongoRepository mongoRepositoryForUnits;
    private VitamMongoRepository mongoRepositoryForGot;
    private final DataConsistencyAuditConfig dataConsistencyAuditConfig;
    private GUID eip;

    @VisibleForTesting
    public MetadataAuditService(WorkspaceClientFactory workspaceClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, VitamRepositoryProvider vitamRepositoryProvider, ElasticsearchMetadataIndexManager indexManager, boolean isDataConsistencyAuditRunnable, boolean enableDataConsistencyRectificationMode, Integer dataConsistencyAuditOplogMaxSize, MongoDbShardConf mongodShardsConf, boolean dbAuthentication) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.indexManager = indexManager;
        this.dataConsistencyAuditConfig = new DataConsistencyAuditConfig(isDataConsistencyAuditRunnable, enableDataConsistencyRectificationMode, dataConsistencyAuditOplogMaxSize, mongodShardsConf, Boolean.valueOf(dbAuthentication));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response auditDataConsistencyMongoEs() throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        VitamError entityResponse;
        Response.Status responseStatus = Response.Status.OK;
        LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (this.isAuditAlreadyRunning(logbookClient)) {
                responseStatus = Response.Status.BAD_REQUEST;
                VitamError entityResponse2 = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(CONTEXT_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription("A data consistency audit is already running.");
                Response response = Response.status((Response.Status)responseStatus).entity((Object)entityResponse2).build();
                return response;
            }
            if (!this.dataConsistencyAuditConfig.getIsDataConsistencyAuditRunnable() || this.dataConsistencyAuditConfig.getDataConsistencyAuditOplogMaxSize() == null || this.dataConsistencyAuditConfig.getDataConsistencyAuditOplogMaxSize() == 0) {
                responseStatus = Response.Status.BAD_REQUEST;
                VitamError entityResponse3 = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(CONTEXT_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription("The data consistency audit params are not correct.");
                Response response = Response.status((Response.Status)responseStatus).entity((Object)entityResponse3).build();
                return response;
            }
            if (this.dataConsistencyAuditConfig.getMongodShardsConf() == null || this.dataConsistencyAuditConfig.getMongodShardsConf().getMongoDbShards() == null || this.dataConsistencyAuditConfig.getMongodShardsConf().getMongoDbShards().isEmpty()) {
                responseStatus = Response.Status.BAD_REQUEST;
                VitamError entityResponse4 = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(CONTEXT_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription("At least one shard is required for MongoDB configuration.");
                Response response = Response.status((Response.Status)responseStatus).entity((Object)entityResponse4).build();
                return response;
            }
            this.eip = GUIDReader.getGUID((String)VitamThreadUtils.getVitamSession().getRequestId());
            LOGGER.debug("Audit data consistency : Start Reading Config");
            HashMap<String, BsonTimestamp> shardsTimeStampConfigMap = new HashMap<String, BsonTimestamp>();
            this.startLogbookForAudit(logbookClient);
            this.getShardsConfig(shardsTimeStampConfigMap, workspaceClient);
            LOGGER.debug("Audit data consistency : Start Reading Oplog");
            this.mongoRepositoryForUnits = this.vitamRepositoryProvider.getVitamMongoRepository(MetadataCollections.UNIT.getVitamCollection());
            this.mongoRepositoryForGot = this.vitamRepositoryProvider.getVitamMongoRepository(MetadataCollections.OBJECTGROUP.getVitamCollection());
            Map<String, MetadataDocument<?>> metadataOplogFromMongo = this.getOplogDocumentsFromShards(shardsTimeStampConfigMap, workspaceClient);
            LOGGER.debug("Audit data consistency : Start Reading indexes from ES");
            this.elasticsearchUnitsRepository = this.vitamRepositoryProvider.getVitamESRepository(MetadataCollections.UNIT.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(MetadataCollections.UNIT));
            this.elasticsearchGotRepository = this.vitamRepositoryProvider.getVitamESRepository(MetadataCollections.OBJECTGROUP.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(MetadataCollections.OBJECTGROUP));
            Map<String, MetadataDocument> metadataOpLogFromEs = metadataOplogFromMongo.entrySet().stream().map(elmt -> new AbstractMap.SimpleEntry((String)elmt.getKey(), this.getDocumentFromEs((Map.Entry<String, ? extends MetadataDocument<?>>)elmt))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, String> incoherantData = this.generateIncoherantDocuments(metadataOplogFromMongo, metadataOpLogFromEs);
            LOGGER.debug("Audit data consistency : Update Logbook with {} resulted data", (Object)incoherantData.size());
            if (incoherantData.isEmpty()) {
                this.successLogbookForAudit(logbookClient);
            } else {
                String alert = "Audit data consistency : Incoherent documents in ES found. " + StringUtils.truncate((String)incoherantData.toString(), (int)1000);
                LOGGER.warn(alert);
                alertService.createAlert(alert);
                if (this.dataConsistencyAuditConfig.isEnableDataConsistencyRectificationMode()) {
                    this.rectifyDataInElasticsearch(logbookClient, metadataOplogFromMongo, metadataOpLogFromEs, incoherantData);
                }
            }
            Map<String, Integer> responseResults = Map.of("requestId", this.eip.getId(), "IncoherantDataSize", incoherantData.size());
            entityResponse = JsonHandler.toJsonNode(responseResults);
            LOGGER.debug("Audit data consistency : End of audit");
            return Response.status((Response.Status)responseStatus).entity((Object)entityResponse).build();
        }
        catch (InvalidGuidOperationException | InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            this.errorLogbookForAudit(logbookClient, e.getMessage());
            responseStatus = Response.Status.BAD_REQUEST;
            entityResponse = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(CONTEXT_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription(e.getMessage());
            return Response.status((Response.Status)responseStatus).entity((Object)entityResponse).build();
        }
        catch (LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            this.errorLogbookForAudit(logbookClient, e.getMessage());
            LOGGER.error(e);
            responseStatus = Response.Status.BAD_REQUEST;
            entityResponse = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(LOGBOOK_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription(e.getMessage());
            return Response.status((Response.Status)responseStatus).entity((Object)entityResponse).build();
        }
        catch (DatabaseException e) {
            this.errorLogbookForAudit(logbookClient, e.getMessage());
            LOGGER.error((Throwable)e);
            responseStatus = Response.Status.BAD_REQUEST;
            entityResponse = new VitamError(responseStatus.name()).setHttpCode(responseStatus.getStatusCode()).setContext(DATABASE_METADATA_AUDIT).setState(CODE_VITAM).setMessage(responseStatus.getReasonPhrase()).setDescription(e.getMessage());
        }
        return Response.status((Response.Status)responseStatus).entity((Object)entityResponse).build();
    }

    private void rectifyDataInElasticsearch(LogbookOperationsClient logbookClient, Map<String, ? extends MetadataDocument<?>> metadataOplogFromMongo, Map<String, ? extends MetadataDocument<?>> metadataOpLogFromEs, Map<String, String> incoherantData) throws DatabaseException, InvalidParseOperationException, LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        this.updateIncoherantDataFromEs(metadataOplogFromMongo, incoherantData);
        this.deleteIncoherantDataFromEs(metadataOplogFromMongo, metadataOpLogFromEs, incoherantData);
        Map<String, MetadataDocument> metadataOpLogFromEsAfterUpdate = metadataOplogFromMongo.entrySet().stream().map(elmt -> new AbstractMap.SimpleEntry((String)elmt.getKey(), this.getDocumentFromEs((Map.Entry<String, ? extends MetadataDocument<?>>)elmt))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> incoherantDataAfterUpdate = this.generateIncoherantDocuments(metadataOplogFromMongo, metadataOpLogFromEsAfterUpdate);
        if (incoherantDataAfterUpdate.isEmpty()) {
            String msgWarnToDisplay = String.format("Audit data consistency : %s document(s) have been updated in ES", incoherantData.size());
            LOGGER.warn(msgWarnToDisplay);
            this.warningLogbookForAudit(logbookClient, msgWarnToDisplay);
        } else {
            String msgErrorToDisplay = "Audit data consistency : A problem occured when updating documents in ES";
            LOGGER.error("Audit data consistency : A problem occured when updating documents in ES");
            this.errorLogbookForAudit(logbookClient, "Audit data consistency : A problem occured when updating documents in ES");
        }
    }

    private void deleteIncoherantDataFromEs(Map<String, ? extends MetadataDocument<?>> metadataOplogFromMongo, Map<String, ? extends MetadataDocument<?>> metadataOpLogFromEs, Map<String, String> incoherantData) {
        Set documentIdsToDeleteInES = incoherantData.keySet().stream().filter(elmt -> ((MetadataDocument)metadataOplogFromMongo.get(elmt)).isEmpty()).collect(Collectors.toSet());
        if (!documentIdsToDeleteInES.isEmpty()) {
            List documentsToDelete = metadataOpLogFromEs.values().stream().filter(elmt -> documentIdsToDeleteInES.contains(elmt.getId())).collect(Collectors.toList());
            Map<Pair, List> documentsToDeleteByTenant = documentsToDelete.stream().collect(Collectors.toMap(elmt -> Pair.of((Object)elmt.getTenantId(), (Object)(elmt instanceof Unit)), elmt -> new ArrayList<String>(Collections.singleton(elmt.getId())), (oldElmt, newElmt) -> {
                oldElmt.addAll(newElmt);
                return oldElmt;
            }));
            documentsToDeleteByTenant.keySet().forEach(key -> {
                try {
                    if (((Boolean)key.getRight()).booleanValue()) {
                        this.elasticsearchUnitsRepository.delete((List)documentsToDeleteByTenant.get(key), ((Integer)key.getLeft()).intValue());
                    } else {
                        this.elasticsearchGotRepository.delete((List)documentsToDeleteByTenant.get(key), ((Integer)key.getLeft()).intValue());
                    }
                }
                catch (DatabaseException e) {
                    LOGGER.error(e.getMessage());
                }
            });
        }
    }

    private void updateIncoherantDataFromEs(Map<String, ? extends MetadataDocument<?>> metadataOplogFromMongo, Map<String, String> incoherantData) throws DatabaseException {
        List documentsToUpdateInES = metadataOplogFromMongo.values().stream().filter(elmt -> incoherantData.containsKey(elmt.get((Object)"_id"))).collect(Collectors.toList());
        this.elasticsearchUnitsRepository.save(documentsToUpdateInES.stream().filter(elmt -> elmt instanceof Unit).collect(Collectors.toList()));
        this.elasticsearchGotRepository.save(documentsToUpdateInES.stream().filter(elmt -> elmt instanceof ObjectGroup).collect(Collectors.toList()));
    }

    private boolean isAuditAlreadyRunning(LogbookOperationsClient logbookClient) throws LogbookClientServerException, InvalidParseOperationException {
        RequestResponse lastOperationByType = logbookClient.getLastOperationByType(AUDIT_DATA_CONSISTENCY_EVT);
        if (lastOperationByType instanceof RequestResponseOK && !((RequestResponseOK)lastOperationByType).getResults().isEmpty()) {
            LogbookOperation lastLogbook = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)((RequestResponseOK)lastOperationByType).getResults().get(0)), LogbookOperation.class);
            return lastLogbook.getEvents().isEmpty();
        }
        return false;
    }

    private MetadataDocument<?> getDocumentFromEs(Map.Entry<String, ? extends MetadataDocument<?>> entrySet) {
        return entrySet.getValue() instanceof Unit ? new Unit(this.getIndexByDocument(this.elasticsearchUnitsRepository, entrySet)) : new ObjectGroup(this.getIndexByDocument(this.elasticsearchGotRepository, entrySet));
    }

    private Map<String, String> generateIncoherantDocuments(Map<String, ? extends MetadataDocument<?>> metadataOplogFromMongo, Map<String, ? extends MetadataDocument<?>> metadataOpLogFromEs) throws InvalidParseOperationException {
        HashMap<String, String> incoherantData = new HashMap<String, String>();
        for (String documentId : metadataOplogFromMongo.keySet()) {
            if (metadataOpLogFromEs.containsKey(documentId)) {
                JsonNode documentFromEsJsonNode;
                JsonNode documentFromMongoJsonNode = JsonHandler.toJsonNode(metadataOplogFromMongo.get(documentId));
                JsonNode patch = JsonDiff.asJson((JsonNode)documentFromMongoJsonNode, (JsonNode)(documentFromEsJsonNode = JsonHandler.toJsonNode(metadataOpLogFromEs.get(documentId))));
                if (patch.isEmpty()) continue;
                incoherantData.put(documentId, "Incoherant Data detected : " + patch.toString());
                continue;
            }
            incoherantData.put(documentId, "The key dont exist in ES");
        }
        return incoherantData;
    }

    private Document getIndexByDocument(VitamElasticsearchRepository elasticsearchRepository, Map.Entry<String, ? extends MetadataDocument<?>> elmt) {
        try {
            Document result = elasticsearchRepository.getDocumentByIdCrossIndices(elmt.getKey()).orElse(new Document());
            if (!result.isEmpty()) {
                result.put("_id", (Object)elmt.getKey());
            }
            return result;
        }
        catch (DatabaseException e) {
            LOGGER.info("{} does not exist in ES", (Object)elmt.getKey());
            return new Document();
        }
    }

    private void getShardsConfig(Map<String, BsonTimestamp> shardsTimeStampConfigMap, WorkspaceClient workspaceClient) throws ContentAddressableStorageServerException, ContentAddressableStorageNotFoundException, InvalidParseOperationException, IOException {
        if (workspaceClient.isExistingContainer(AUDIT_CONTAINER_NAME)) {
            InputStream stream = (InputStream)workspaceClient.getObject(AUDIT_CONTAINER_NAME, "mongoDbShardsTimestampConfiguration.json").getEntity();
            Map mapFromObject = JsonHandler.getMapFromString((String)IOUtils.toString((InputStream)stream, (String)"UTF-8"));
            shardsTimeStampConfigMap.putAll(mapFromObject.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, BsonTimestamp>((String)e.getKey(), this.convertToBsonTimestamp(e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        } else {
            workspaceClient.createContainer(AUDIT_CONTAINER_NAME);
            for (MongoDbShard mongoDbShard : this.dataConsistencyAuditConfig.getMongodShardsConf().getMongoDbShards()) {
                mongoDbShard.getMongoDbNodes().forEach(dbNode -> shardsTimeStampConfigMap.put(mongoDbShard.getShardName() + ":" + dbNode.getDbHost() + ":" + dbNode.getDbPort(), null));
            }
            this.storeDbShardsConfig(shardsTimeStampConfigMap, workspaceClient);
        }
    }

    private Map<String, ? extends MetadataDocument<?>> getOplogDocumentsFromShards(Map<String, BsonTimestamp> shardsTimeStampConfigMap, WorkspaceClient workspaceClient) {
        boolean isShardsTimeStampConfigMapTouched = false;
        String dbUserName = this.dataConsistencyAuditConfig.getMongodShardsConf().getDbUserName();
        String dbUserPassword = this.dataConsistencyAuditConfig.getMongodShardsConf().getDbPassword();
        List collectionsToScan = Arrays.stream(MetadataCollections.values()).map(collection -> collection.getCollection().getNamespace().getFullName()).collect(Collectors.toList());
        HashMap metadataOplogDocuments = new HashMap();
        for (MongoDbShard mongoDbShard : this.dataConsistencyAuditConfig.getMongodShardsConf().getMongoDbShards()) {
            for (MongoDbNode dbNode : mongoDbShard.getMongoDbNodes()) {
                String shardNameForMapConfig;
                OplogReader oplogReader = this.createOplogReaderInstance(dbUserName, dbUserPassword, dbNode, this.dataConsistencyAuditConfig.isDbAuthentication(), this.dataConsistencyAuditConfig.getDataConsistencyAuditOplogMaxSize());
                Map oplogByShard = oplogReader.readDocumentsFromOplogByShardAndCollections(collectionsToScan, shardsTimeStampConfigMap.get(shardNameForMapConfig = mongoDbShard.getShardName() + ":" + dbNode.getDbHost() + ":" + dbNode.getDbPort()));
                if (oplogByShard.isEmpty()) continue;
                if (metadataOplogDocuments.isEmpty()) {
                    LOGGER.info(oplogByShard.size() + " operations will be added for data consistency audit from " + shardNameForMapConfig);
                    metadataOplogDocuments.putAll(this.getDocumentsFromMongo(oplogByShard));
                } else {
                    Map<String, Document> oplogByShardToAdd = oplogByShard.entrySet().stream().filter(elmt -> !metadataOplogDocuments.keySet().contains(elmt.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    LOGGER.info(oplogByShardToAdd.size() + " operations will be added for data consistency audit from " + shardNameForMapConfig);
                    metadataOplogDocuments.putAll(this.getDocumentsFromMongo(oplogByShardToAdd));
                }
                BsonTimestamp maxTimeStampScanned = oplogByShard.values().stream().map(elmt -> (BsonTimestamp)elmt.get((Object)"ts")).max(BsonTimestamp::compareTo).get();
                if (shardsTimeStampConfigMap.get(shardNameForMapConfig) != null && maxTimeStampScanned.compareTo(shardsTimeStampConfigMap.get(shardNameForMapConfig)) <= 0) continue;
                isShardsTimeStampConfigMapTouched = true;
                shardsTimeStampConfigMap.put(shardNameForMapConfig, maxTimeStampScanned);
            }
        }
        if (isShardsTimeStampConfigMapTouched) {
            this.storeDbShardsConfig(shardsTimeStampConfigMap, workspaceClient);
        }
        return metadataOplogDocuments;
    }

    private OplogReader createOplogReaderInstance(String dbUserName, String dbUserPassword, MongoDbNode dbNode, Boolean dbAuthentication, Integer dataConsistencyAuditOplogMaxSize) {
        LOGGER.info("Connecting to MongoDB Shard Node");
        DbConfigurationImpl dbConfiguration = new DbConfigurationImpl(List.of(dbNode), DB_NAME, dbAuthentication.booleanValue(), dbUserName, dbUserPassword);
        MongoClient mongoClient = MongoDbAccess.createMongoClient((DbConfiguration)dbConfiguration);
        return new OplogReader(mongoClient, dataConsistencyAuditOplogMaxSize);
    }

    private Map<String, MetadataDocument<?>> getDocumentsFromMongo(Map<String, Document> documentsToScan) {
        return documentsToScan.entrySet().stream().map(elmt -> new AbstractMap.SimpleEntry((String)elmt.getKey(), ((Document)elmt.getValue()).get((Object)"ns").toString().equals(MetadataCollections.UNIT.getCollection().getNamespace().getFullName()) ? this.getDocumentFromMongo((Class<? extends MetadataDocument>)Unit.class, (Map.Entry<String, Document>)elmt) : this.getDocumentFromMongo((Class<? extends MetadataDocument>)ObjectGroup.class, (Map.Entry<String, Document>)elmt))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private MetadataDocument<?> getDocumentFromMongo(Class<? extends MetadataDocument> clasz, Map.Entry<String, Document> elmt) {
        try {
            if (clasz == Unit.class) {
                Document unitDoc = this.mongoRepositoryForUnits.getByID(elmt.getKey(), null).orElse(new Document());
                if (!unitDoc.isEmpty()) {
                    return (Unit)unitDoc;
                }
                return new Unit();
            }
            Document gotDoc = this.mongoRepositoryForGot.getByID(elmt.getKey(), null).orElse(new Document());
            if (!gotDoc.isEmpty()) {
                return (ObjectGroup)gotDoc;
            }
            return new ObjectGroup();
        }
        catch (DatabaseException e) {
            LOGGER.info("{} does not exist in Mongo", (Object)elmt.getKey());
            return null;
        }
    }

    private void startLogbookForAudit(LogbookOperationsClient logbookClient) throws LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        LogbookOperationParameters logbookParametersForAuditStart = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)AUDIT_DATA_CONSISTENCY_EVT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.DATA_CONSISTENCY_AUDIT, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)AUDIT_DATA_CONSISTENCY_EVT, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        logbookClient.create(new LogbookOperationParameters[]{logbookParametersForAuditStart});
    }

    private void successLogbookForAudit(LogbookOperationsClient logbookClient) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)VitamConfiguration.getAdminTenant());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)AUDIT_DATA_CONSISTENCY_EVT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.DATA_CONSISTENCY_AUDIT, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)AUDIT_DATA_CONSISTENCY_EVT, (StatusCode)StatusCode.OK), (GUID)this.eip);
        logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void warningLogbookForAudit(LogbookOperationsClient logbookClient, String message) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)VitamConfiguration.getAdminTenant());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)AUDIT_DATA_CONSISTENCY_EVT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.DATA_CONSISTENCY_AUDIT, (StatusCode)StatusCode.WARNING, (String)VitamLogbookMessages.getCodeOp((String)AUDIT_DATA_CONSISTENCY_EVT, (StatusCode)StatusCode.WARNING), (GUID)this.eip);
        ObjectNode msgJson = JsonHandler.createObjectNode();
        msgJson.put("AuditWarnCheck", message);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, msgJson.toString());
        logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void errorLogbookForAudit(LogbookOperationsClient logbookClient, String message) throws LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        GUID eipId = GUIDFactory.newOperationLogbookGUID((int)VitamConfiguration.getAdminTenant());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipId, (String)AUDIT_DATA_CONSISTENCY_EVT, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.DATA_CONSISTENCY_AUDIT, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getCodeOp((String)AUDIT_DATA_CONSISTENCY_EVT, (StatusCode)StatusCode.KO), (GUID)this.eip);
        ObjectNode msgJson = JsonHandler.createObjectNode();
        msgJson.put("AuditErrorCheck", message);
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, msgJson.toString());
        logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private BsonTimestamp convertToBsonTimestamp(Object value) {
        try {
            JsonNode valueToJsonNode = JsonHandler.toJsonNode((Object)value);
            if (!valueToJsonNode.isEmpty() && valueToJsonNode.get("Time") != null && valueToJsonNode.get("Inc") != null) {
                return new BsonTimestamp(valueToJsonNode.get("Time").asInt(), valueToJsonNode.get("Inc").asInt());
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(e.getMessage());
        }
        return null;
    }

    private void storeDbShardsConfig(Map<String, BsonTimestamp> shardsTimeStampConfigMap, WorkspaceClient workspaceClient) {
        try {
            File firstMapTmpFile = File.createTempFile("mongoDbShardsTimestampConfiguration", ".json");
            JsonHandler.writeAsFile((Object)JsonHandler.toJsonNode(shardsTimeStampConfigMap), (File)firstMapTmpFile);
            workspaceClient.putObject(AUDIT_CONTAINER_NAME, "mongoDbShardsTimestampConfiguration.json", (Object)firstMapTmpFile);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

