/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.service.migration;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.security.internal.common.model.CertificateStatus;
import fr.gouv.vitam.security.internal.rest.service.migration.SecurityDataMigrationRepository;
import java.util.concurrent.atomic.AtomicBoolean;

public class SecurityDataMigrationService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SecurityDataMigrationService.class);
    private final SecurityDataMigrationRepository securityDataMigrationRepository;
    private final AtomicBoolean isRunning = new AtomicBoolean();

    @VisibleForTesting
    public SecurityDataMigrationService(SecurityDataMigrationRepository securityDataMigrationRepository) {
        this.securityDataMigrationRepository = securityDataMigrationRepository;
    }

    public boolean isMongoDataUpdateInProgress() {
        return this.isRunning.get();
    }

    public boolean tryStartMongoDataUpdate() {
        boolean lockAcquired = this.isRunning.compareAndSet(false, true);
        if (!lockAcquired) {
            return false;
        }
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                LOGGER.info("Starting security data migration");
                this.updateCertificatesStructure();
            }
            catch (Exception e) {
                LOGGER.error("A fatal error occurred during security data migration", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
                LOGGER.info("Security Data migration finished");
            }
        });
        return true;
    }

    private void updateCertificatesStructure() throws InterruptedException {
        this.securityDataMigrationRepository.migrateCertificatesData(CertificateStatus.VALID);
    }
}

