/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.rest.server;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.security.internal.rest.server.PersonalCertificatePermissionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.collections4.SetUtils;

public class PersonalCertificatePermissionConfigLoader {
    public static PersonalCertificatePermissionConfig loadPersonalCertificatePermissionConfig(String configFile) throws IOException {
        PersonalCertificatePermissionConfig config;
        try (InputStream personalCertificatePermissionIS = PropertiesUtils.getConfigAsStream((String)configFile);){
            config = (PersonalCertificatePermissionConfig)PropertiesUtils.readYaml((InputStream)personalCertificatePermissionIS, PersonalCertificatePermissionConfig.class);
        }
        if (config.getPermissionsRequiringPersonalCertificate() == null) {
            config.setPermissionsRequiringPersonalCertificate(Collections.emptySet());
        }
        if (config.getPermissionsWithoutPersonalCertificate() == null) {
            config.setPermissionsWithoutPersonalCertificate(Collections.emptySet());
        }
        PersonalCertificatePermissionConfigLoader.validateConfiguration(config);
        return config;
    }

    private static void validateConfiguration(PersonalCertificatePermissionConfig config) throws IOException {
        SetUtils.SetView intersection = SetUtils.intersection(config.getPermissionsRequiringPersonalCertificate(), config.getPermissionsWithoutPersonalCertificate());
        if (!intersection.isEmpty()) {
            throw new IllegalStateException("Invalid configuration file. A permission cannot be both requiring and non requiring personal certificate. " + intersection.toString());
        }
    }
}

