/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.simulator;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.tapelibrary.TapeDriveConf;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryConfiguration;
import fr.gouv.vitam.common.storage.tapelibrary.TapeRobotConf;
import fr.gouv.vitam.storage.offers.tape.TapeLibraryFactory;
import fr.gouv.vitam.storage.offers.tape.simulator.TapeLibrarySimulator;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveCommandService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeDriveService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeReadWriteService;
import fr.gouv.vitam.storage.offers.tape.spec.TapeRobotService;
import fr.gouv.vitam.storage.offers.tape.worker.TapeDriveWorker;
import java.nio.file.Path;
import java.util.List;
import org.junit.Assert;
import org.junit.rules.ExternalResource;

public class TapeLibrarySimulatorRule
extends ExternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TapeLibrarySimulatorRule.class);
    private final TapeLibrarySimulator tapeLibrarySimulator;

    public TapeLibrarySimulatorRule(Path inputDirectory, Path tempOutputStorageDirectory, int nbDrives, int nbSlots, int nbTapes, int maxTapeCapacityInBytes, String cartridgeType, int sleepDelayMillis) {
        this.tapeLibrarySimulator = new TapeLibrarySimulator(inputDirectory, tempOutputStorageDirectory, nbDrives, nbSlots, nbTapes, maxTapeCapacityInBytes, cartridgeType, sleepDelayMillis);
        TapeLibraryFactory.TapeServiceCreator tapeServiceCreator = new TapeLibraryFactory.TapeServiceCreator(){

            public TapeRobotService createRobotService(TapeRobotConf tapeRobotConf) {
                return TapeLibrarySimulatorRule.this.tapeLibrarySimulator::getTapeLoadUnloadService;
            }

            public TapeDriveService createTapeDriveService(TapeLibraryConfiguration configuration, final TapeDriveConf tapeDriveConf) {
                return new TapeDriveService(){

                    public TapeReadWriteService getReadWriteService() {
                        return TapeLibrarySimulatorRule.this.tapeLibrarySimulator.getTapeReadWriteServices().get(tapeDriveConf.getIndex());
                    }

                    public TapeDriveCommandService getDriveCommandService() {
                        return TapeLibrarySimulatorRule.this.tapeLibrarySimulator.getTapeDriveCommandServices().get(tapeDriveConf.getIndex());
                    }

                    public TapeDriveConf getTapeDriveConf() {
                        return tapeDriveConf;
                    }
                };
            }
        };
        TapeLibraryFactory.getInstance().overrideTapeServiceCreatorForTesting(tapeServiceCreator);
        TapeDriveWorker.updateInactivitySleepDelayForTesting();
    }

    public TapeLibrarySimulator getTapeLibrarySimulator() {
        return this.tapeLibrarySimulator;
    }

    public void after() {
        TapeLibraryFactory.getInstance().resetTapeLibraryFactoryAfterTests();
        List<Exception> reportedExceptions = this.tapeLibrarySimulator.getFailures();
        if (!reportedExceptions.isEmpty()) {
            for (Exception exception : reportedExceptions) {
                LOGGER.error("Reported exception : " + String.valueOf(exception));
            }
            Assert.fail((String)("Expected no error, got " + String.valueOf(reportedExceptions)));
        }
    }
}

