/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.stream.MultiplexedStreamWriter;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageCompressedFileException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ZipFilesNameNotAllowedException;
import fr.gouv.vitam.workspace.api.model.TimeToLive;
import fr.gouv.vitam.workspace.common.CompressInformation;
import fr.gouv.vitam.workspace.common.WorkspaceFileSystem;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.compress.archivers.ArchiveException;

@Path(value="/v1")
@Tag(name="Worker")
public class WorkspaceResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceResource.class);
    private static final String FOLDER_NAME = "folderName";
    private static final String OBJECT_NAME = "objectName";
    private static final String CONTAINER_NAME = "containerName";
    private final WorkspaceFileSystem workspace;

    WorkspaceResource(StorageConfiguration configuration) {
        try {
            this.workspace = new WorkspaceFileSystem(configuration);
        }
        catch (IOException ex) {
            LOGGER.error("cannot load WorkspaceFileSystem : ", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
        LOGGER.info("init Workspace Resource server");
    }

    @Path(value="/freespace")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="get workspace free space", description="obtenir de l'espace libre du dossier workspace")
    public Response getFreespacePercent() {
        ObjectNode result = JsonHandler.createObjectNode().put("freespace", this.workspace.getWorkspaceFreeSpace());
        return Response.ok((Object)result).build();
    }

    @Path(value="/containers/{containerName}")
    @POST
    @Produces(value={"application/json"})
    @Operation(summary="Create one container", description="Permet de cr\u00e9er un nouveau container")
    public Response createContainer(@PathParam(value="containerName") String containerName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            this.workspace.createContainer(containerName);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageAlreadyExistException e) {
            LOGGER.info(ErrorMessage.CONTAINER_ALREADY_EXIST.getMessage() + containerName);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/containers/{containerName}")
    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Delete container by name", description="Permet de supprimer un container")
    public Response deleteContainer(@PathParam(value="containerName") String containerName, @HeaderParam(value="X-Recursive") boolean recursive) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            this.workspace.deleteContainer(containerName, recursive);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName + " => " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/containers/{containerName}/old_files")
    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="Delete object this from container", description="Permet de supprimer un objet du container")
    public Response purgeOldFilesInContainer(@PathParam(value="containerName") String containerName, TimeToLive timeToLive) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            this.workspace.purgeOldFilesInContainer(containerName, timeToLive);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName + " => " + e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/containers/{containerName}")
    @HEAD
    @Produces(value={"application/json"})
    @Operation(summary="test if this container exists", description="Permet de tester l'existence du Container")
    public Response isExistingContainer(@PathParam(value="containerName") String containerName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            boolean exists = this.workspace.isExistingContainer(containerName);
            if (exists) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/container/{containerName}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="get container informations", description="Permet d'acc\u00e9der aux informations d'un container")
    public Response getContainerInformation(@PathParam(value="containerName") String containerName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            ContainerInformation containerInformation = this.workspace.getContainerInformation(containerName);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)containerInformation).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException exc) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/containers/{containerName}/folders/{folderName:.*}")
    @POST
    @Produces(value={"application/json"})
    @Operation(summary="create operation folder", description="Permet de cr\u00e9er un sous dossier dans le container")
    public Response createFolder(@PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            this.workspace.createFolder(containerName, folderName);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageAlreadyExistException e) {
            LOGGER.info(ErrorMessage.FOLDER_ALREADY_EXIST.getMessage() + containerName + "/" + folderName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.FOLDER_NOT_FOUND.getMessage() + containerName + "/" + folderName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/containers/{containerName}/folders/{folderName:.*}")
    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="delete operation folder", description="Permet de supprimer un sous dossier dans le container")
    public Response deleteFolder(@PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            this.workspace.deleteFolder(containerName, folderName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.FOLDER_NOT_FOUND.getMessage() + containerName + "/" + folderName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)(containerName + "/" + folderName)).build();
    }

    @Path(value="/containers/{containerName}/folders/{folderName:.*}")
    @HEAD
    @Produces(value={"application/json"})
    @Operation(summary="test if operation folder exists", description="Permet de v\u00e9rifier l'existance d'un sous dossier dans le container")
    public Response isExistingFolder(@PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            boolean exists = this.workspace.isExistingFolder(containerName, folderName);
            if (exists) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)(containerName + "/" + folderName)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/containers/{containerName}/folders/{folderName:.*}")
    @PUT
    @Consumes(value={"application/zip", "application/x-gzip", "application/gzip", "application/x-tar", "application/x-bzip2"})
    @Produces(value={"application/json"})
    @Operation(summary="upload zip or tar into that folder", description="Permet d'uploader un ZIP ou TAR avec un unzip/untar automatique sous ce folder, incluant la cr\u00e9ation de sous-folders")
    public Response uncompressObject(InputStream stream, @PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName, @HeaderParam(value="Content-Type") String archiveType) {
        try {
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.uncompressObject(containerName, folderName, archiveType, stream);
            Response response = Response.status((Response.Status)Response.Status.CREATED).build();
            return response;
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            return response;
        }
        catch (ContentAddressableStorageAlreadyExistException e) {
            LOGGER.info(ErrorMessage.CONTAINER_ALREADY_EXIST.getMessage() + containerName, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.CONFLICT).build();
            return response;
        }
        catch (ZipFilesNameNotAllowedException e) {
            LOGGER.error((Throwable)e);
            VitamError vitamError = this.getVitamError(VitamCode.WORKSPACE_NOT_ACCEPTABLE_FILES, e.getMessage());
            Response response = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)vitamError).build();
            return response;
        }
        catch (ContentAddressableStorageCompressedFileException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            VitamError vitamError = this.getVitamError(VitamCode.WORKSPACE_BAD_REQUEST, e.getMessage());
            Response response = Response.status((Response.Status)status).entity((Object)vitamError).build();
            return response;
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
        }
    }

    private VitamError getVitamError(VitamCode vitamCode, String msg) {
        return new VitamError(vitamCode.name()).setMessage(msg).setState("ko").setHttpCode(vitamCode.getStatus().getStatusCode()).setDescription(msg).setContext(vitamCode.getService().getName());
    }

    @Path(value="/containers/{containerName}")
    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="upload zip or tar into that folder", description="Permet d'uploader un ZIP ou TAR avec un unzip/untar automatique sous ce folder, incluant la cr\u00e9ation de sous-folders")
    public Response compress(@PathParam(value="containerName") String containerName, CompressInformation compressInformation) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (Object[])new Object[]{containerName, compressInformation});
            this.workspace.checkWorkspaceContainerSanity(containerName);
            this.workspace.compress(containerName, compressInformation.getFiles(), compressInformation.getOutputFile(), compressInformation.getOutputContainer());
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (IllegalPathException | IOException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ArchiveException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/containers/{containerName}/folders/{folderName:.*}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="get object list from folder", description="Permet de r\u00e9cup\u00e9rer la liste des objets du dossier du container")
    public Response getUriDigitalObjectListByFolder(@PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName) {
        List uriList;
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            uriList = this.workspace.getListUriDigitalObjectFromFolder(containerName, folderName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException eNotFoundException) {
            LOGGER.error(ErrorMessage.FOLDER_NOT_FOUND.getMessage() + containerName + "/" + folderName);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (ContentAddressableStorageException eAddressableStorageException) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)eAddressableStorageException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(Collections.emptyList()).build();
        }
        if (uriList == null || uriList.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity(Collections.emptyList()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)uriList).build();
    }

    @Path(value="/containers/{containerName}/folders/{folderName:.*}/filesWithParams")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get Map of files with params from folder", description="Permet de r\u00e9cup\u00e9rer une Map des objets du dossier du container avec ses propres param\u00e9tres")
    public Response getFilesWithParamsFromFolder(@PathParam(value="containerName") String containerName, @PathParam(value="folderName") String folderName) {
        Map filesWithParamsMap;
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_FOLDER_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, folderName});
            this.workspace.checkWorkspaceDirSanity(containerName, folderName);
            filesWithParamsMap = this.workspace.getFilesWithParamsFromFolder(containerName, folderName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException eNotFoundException) {
            LOGGER.error(ErrorMessage.FOLDER_NOT_FOUND.getMessage() + containerName + "/" + folderName);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(containerName + "/" + folderName)).build();
        }
        catch (ContentAddressableStorageException eAddressableStorageException) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)eAddressableStorageException);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(Collections.emptyList()).build();
        }
        if (filesWithParamsMap == null || filesWithParamsMap.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity(Collections.emptyList()).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)filesWithParamsMap).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/containers/{containerName}/objects/{objectName:.*}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Operation(summary="create new object in container", description="Permet de cr\u00e9er un nouvel objet dans le container")
    public Response putObject(InputStream stream, @PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
            this.workspace.putObject(containerName, objectName, stream);
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)(containerName + "/" + objectName)).build();
            return response;
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            return response;
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/atomic_containers/{containerName}/objects/{objectName:.*}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Operation(summary="create new atomic object in container", description="Permet de cr\u00e9er un nouvel objet atomique dans le container")
    public Response putAtomicObject(InputStream stream, @PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName, @HeaderParam(value="X-Content-Length") long size) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
            if (size < 0L) {
                throw new IllegalArgumentException("Invalid stream size " + size);
            }
            this.workspace.putAtomicObject(containerName, objectName, stream, size);
            Response response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)(containerName + "/" + objectName)).build();
            return response;
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            return response;
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            return response;
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)stream);
        }
    }

    @Path(value="/containers/{containerName}/objects/{objectName:.*}")
    @DELETE
    @Produces(value={"application/json"})
    @Operation(summary="delete an object in container", description="Permet de supprimer un objet dans le container")
    public Response deleteObject(@PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
            this.workspace.deleteObject(containerName, objectName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @Path(value="/containers/{containerName}/objects/{objectName:.*}")
    @GET
    @Produces(value={"application/octet-stream"})
    @Operation(summary="retrieve an object in container", description="Permet de r\u00e9cup\u00e9rer un objet dans le container")
    public Response getObject(@PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName, @HeaderParam(value="X-Vitam-Chunk-Offset") Long chunkOffset, @HeaderParam(value="X-Vitam-Chunk-Max-Size") Long maxChunkSize) {
        return this.getObjectResponse(containerName, objectName, chunkOffset, maxChunkSize);
    }

    @Path(value="/containers/{containerName}/objects")
    @GET
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    @Operation(summary="retrieve an object in container as multiplexed stream", description="Permet de r\u00e9cup\u00e9rer un objet dans le container")
    public Response getBulkObjects(@PathParam(value="containerName") String containerName, List<String> objectURIs) {
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        for (String objectId : objectURIs) {
            try {
                this.workspace.checkWorkspaceFileSanity(containerName, objectId);
                JsonNode objectInformation = this.workspace.getObjectInformation(containerName, objectId);
                fileSizes.add(objectInformation.get("size").asLong());
            }
            catch (IllegalPathException e) {
                LOGGER.error((Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            catch (ContentAddressableStorageNotFoundException e) {
                LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName + " / " + objectId, (Throwable)e);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            catch (ContentAddressableStorageException e) {
                LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            }
        }
        long totalStreamSize = MultiplexedStreamWriter.getTotalStreamSize(fileSizes);
        StreamingOutput streamingOutput = output -> {
            try {
                MultiplexedStreamWriter multiplexedStreamWriter = new MultiplexedStreamWriter(output);
                for (String objectURI : objectURIs) {
                    Response objResponse = null;
                    try {
                        objResponse = this.workspace.getObject(containerName, objectURI, null, null);
                        long size = Long.parseLong(objResponse.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName()));
                        try (InputStream inputStream = (InputStream)objResponse.getEntity();){
                            multiplexedStreamWriter.appendEntry(size, inputStream);
                        }
                        if (objResponse == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (objResponse != null) {
                            StreamUtils.consumeAnyEntityAndClose(objResponse);
                        }
                        throw throwable;
                    }
                    StreamUtils.consumeAnyEntityAndClose((Response)objResponse);
                }
                multiplexedStreamWriter.appendEndOfFile();
            }
            catch (Exception e) {
                LOGGER.error("Could not return bulk objects", (Throwable)e);
                throw new WebApplicationException("Could not return bulk objects", (Throwable)e);
            }
        };
        return Response.ok((Object)streamingOutput).header(VitamHttpHeader.X_CONTENT_LENGTH.getName(), (Object)totalStreamSize).build();
    }

    @Path(value="/containers/{containerName}/objects/{objectName:.*}")
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="retrieve an object in container as json", description="Permet de r\u00e9cup\u00e9rer un objet dans le container")
    public Response getObjectInformation(@PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName) {
        JsonNode jsonResultNode;
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
            jsonResultNode = this.workspace.getObjectInformation(containerName, objectName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)jsonResultNode).build();
    }

    @Path(value="/containers/{containerName}/objects/{objectName:.*}")
    @HEAD
    @Produces(value={"application/json"})
    @Operation(summary="check if object in container exists", description="Permet de v\u00e9rifier l'existance de l'objet dans le container")
    public Response computeObjectDigest(@PathParam(value="containerName") String containerName, @PathParam(value="objectName") String objectName, @HeaderParam(value="X-digest-algorithm") String algo) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        if (algo != null) {
            String messageDigest;
            LOGGER.debug("X-digest-algorithm : " + algo);
            try {
                messageDigest = this.workspace.computeObjectDigest(containerName, objectName, DigestType.fromValue((String)algo));
            }
            catch (ContentAddressableStorageNotFoundException e) {
                LOGGER.error(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
                return Response.status((Response.Status)Response.Status.NOT_FOUND).header("X-digest-algorithm", (Object)algo).build();
            }
            catch (ContentAddressableStorageException e) {
                LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).header("X-digest-algorithm", (Object)algo).build();
            }
            return Response.status((Response.Status)Response.Status.OK).header("X-digest-algorithm", (Object)algo).header("X-digest", (Object)messageDigest).build();
        }
        try {
            boolean exists = this.workspace.isExistingObject(containerName, objectName);
            if (exists) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response getObjectResponse(String containerName, String objectName, Long chunkOffset, Long maxChunkSize) {
        try {
            ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectName});
            this.workspace.checkWorkspaceFileSanity(containerName, objectName);
            Response response = this.workspace.getObject(containerName, objectName, chunkOffset, maxChunkSize);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/octet-stream");
            headers.put(VitamHttpHeader.X_CONTENT_LENGTH.getName(), response.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName()));
            headers.put(VitamHttpHeader.X_CHUNK_LENGTH.getName(), response.getHeaderString(VitamHttpHeader.X_CHUNK_LENGTH.getName()));
            return new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
        }
        catch (IllegalPathException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn(ErrorMessage.OBJECT_NOT_FOUND.getMessage() + containerName, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

