/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.workspace.rest.WorkspaceResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            StorageConfiguration workspaceConfiguration = (StorageConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, StorageConfiguration.class);
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)new WorkspaceResource(workspaceConfiguration));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

