/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.security.internal.exception.VitamSecurityException;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class EndpointPermissionAuthorizationFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(EndpointPermissionAuthorizationFilter.class);
    private final String permission;
    private AdminManagementClient adminManagementClient;

    public EndpointPermissionAuthorizationFilter(String permission) {
        this.permission = permission;
        this.adminManagementClient = AdminManagementClientFactory.getInstance().getClient();
    }

    @VisibleForTesting
    public EndpointPermissionAuthorizationFilter(String permission, AdminManagementClient adminManagementClient) {
        this.permission = permission;
        this.adminManagementClient = adminManagementClient;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String securityProfileIdentifier = VitamThreadUtils.getVitamSession().getSecurityProfileIdentifier();
        try {
            RequestResponse securityProfileResponse = this.adminManagementClient.findSecurityProfileByIdentifier(securityProfileIdentifier);
            if (!securityProfileResponse.isOk()) {
                LOGGER.error("Could not retrieve security profile by identifier " + securityProfileIdentifier);
                VitamError vitamError = (VitamError)securityProfileResponse;
                requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
                return;
            }
            SecurityProfileModel securityProfile = (SecurityProfileModel)((RequestResponseOK)securityProfileResponse).getFirstResult();
            if (securityProfile.getFullAccess().booleanValue()) {
                LOGGER.debug("Full access granted.");
                return;
            }
            if (securityProfile.getPermissions() != null && securityProfile.getPermissions().contains(this.permission)) {
                LOGGER.debug("Access granted with permission " + this.permission);
                return;
            }
            LOGGER.warn("Access denied for permission " + this.permission);
            throw new VitamSecurityException("Access denied.");
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException | ReferentialNotFoundException | VitamSecurityException e) {
            LOGGER.error("An error occured during authorization filter check", e);
            VitamError vitamError = this.generateVitamError((Exception)e, this.permission);
            requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
    }

    private VitamError generateVitamError(Exception e, String permission) {
        VitamError vitamError;
        String description = e.getMessage();
        if (Strings.isNullOrEmpty((String)description)) {
            description = StringUtils.getClassName((Object)e);
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)permission) && permission.equals("units:update")) {
            vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.INTERNAL_SECURITY_MASS_UPDATE_AUTHORIZATION_REJECTED));
            vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.INTERNAL_SECURITY_MASS_UPDATE_AUTHORIZATION_REJECTED.getMessage()).setDescription(description).setState(VitamCode.INTERNAL_SECURITY_MASS_UPDATE_AUTHORIZATION_REJECTED.name()).setHttpCode(VitamCode.INTERNAL_SECURITY_MASS_UPDATE_AUTHORIZATION_REJECTED.getStatus().getStatusCode());
        } else {
            vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.INTERNAL_SECURITY_UNAUTHORIZED));
            vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getMessage()).setDescription(description).setState(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.name()).setHttpCode(VitamCode.INTERNAL_SECURITY_UNAUTHORIZED.getStatus().getStatusCode());
        }
        return vitamError;
    }

    public String getPermission() {
        return this.permission;
    }
}

