/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.net.URI;

public class WorkspaceClientFactory
extends VitamClientFactory<WorkspaceClient> {
    private static final WorkspaceClientFactory WORKSPACE_CLIENT_FACTORY = new WorkspaceClientFactory("/workspace/v1");

    protected WorkspaceClientFactory(String resourcePath) {
        super(null, resourcePath);
    }

    public static WorkspaceClientFactory getInstance(WorkFlowExecutionContext executionContext) {
        switch (executionContext) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VITAM: 
            case COLLECT: 
        }
        return WORKSPACE_CLIENT_FACTORY;
    }

    public WorkspaceClient getClient() {
        return new WorkspaceClient(this);
    }

    public static void changeMode(String serviceUrl, WorkFlowExecutionContext executionContext) {
        ParametersChecker.checkParameter((String)"Server Url can not be null", (String[])new String[]{serviceUrl});
        URI uri = URI.create(serviceUrl);
        ClientConfigurationImpl configuration = new ClientConfigurationImpl(uri.getHost(), uri.getPort());
        WorkspaceClientFactory.changeMode((ClientConfiguration)configuration, executionContext);
    }

    static void changeMode(ClientConfiguration configuration, WorkFlowExecutionContext executionContext) {
        WorkspaceClientFactory instance = WorkspaceClientFactory.getInstance(executionContext);
        instance.initialisation(configuration, instance.getResourcePath());
    }
}

