/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.workspace.client;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;

public class WorkspaceAutoCleanableStreamingOutput
implements StreamingOutput {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceAutoCleanableStreamingOutput.class);
    private final InputStream inputStream;
    private final WorkspaceClient workspaceClient;
    private final String containerName;

    public WorkspaceAutoCleanableStreamingOutput(InputStream is, WorkspaceClient workspaceClient, String containerName) {
        this.inputStream = is;
        this.workspaceClient = workspaceClient;
        this.containerName = containerName;
    }

    public void write(OutputStream outputStream) throws IOException, WebApplicationException {
        try {
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)outputStream);
            if (this.workspaceClient.isExistingContainer(this.containerName)) {
                this.workspaceClient.deleteContainer(this.containerName, true);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.error("Unable to close or clean workspace");
        }
        finally {
            this.workspaceClient.close();
        }
    }
}

