/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.DomainName;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntryWriter;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.MultiplexedStreamReader;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkPutResult;
import fr.gouv.vitam.storage.driver.model.StorageCheckObjectAvailabilityResult;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.request.OfferLogRequest;
import fr.gouv.vitam.storage.engine.common.utils.ContainerUtils;
import fr.gouv.vitam.storage.offers.core.DefaultOfferService;
import fr.gouv.vitam.storage.offers.core.NonUpdatableContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageUnavailableDataFromAsyncOfferException;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TaggedInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.exceptions.ConnectionException;

@Path(value="/offer/v1")
@ApplicationPath(value="webresources")
@Tag(name="Default-Offer")
public class DefaultOfferResource
extends ApplicationStatusResource {
    private static final String MISSING_THE_TENANT_ID_X_TENANT_ID = "Missing the tenant ID (X-Tenant-Id) or wrong object Type";
    private static final String MISSING_THE_BODY = "Missing the body object";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DefaultOfferResource.class);
    public static final String RE_AUTHENTICATION_CALL_STREAM_ALREADY_CONSUMED_BUT_NO_FILE_CREATED = "Caused by re-authentication call. Stream already consumed but no file created, storage engine must retry to re-put object";
    private static final String MISSING_THE_DATA_TYPE_PARAMETER = "Missing Data Type parameter";
    private static final String MISSING_OBJECTS_IDS_LIST_PARAMETER = "Missing Objects Ids List parameter";
    private final DefaultOfferService defaultOfferService;

    public DefaultOfferResource(DefaultOfferService defaultOfferService) {
        LOGGER.debug("DefaultOfferResource initialized");
        this.defaultOfferService = defaultOfferService;
    }

    @HEAD
    @Path(value="/objects/{type}")
    @Produces(value={"application/json"})
    public Response getCapacity(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="type") DataCategory type) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        try {
            ContainerInformation capacity = this.defaultOfferService.getCapacity(containerName);
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.OK);
            response.header("X-Usable-Space", (Object)capacity.getUsableSpace());
            response.header("X-Tenant-Id", (Object)xTenantId);
            return response.build();
        }
        catch (ContentAddressableStorageNotFoundException exc) {
            LOGGER.error(ErrorMessage.CONTAINER_NOT_FOUND.getMessage() + containerName, (Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/objects/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getContainerList(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="type") DataCategory type) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        StreamingOutput streamingOutput = output -> {
            try (CloseShieldOutputStream closeShieldOutputStream = new CloseShieldOutputStream(output);
                 ObjectEntryWriter objectEntryWriter = new ObjectEntryWriter((OutputStream)closeShieldOutputStream);){
                this.defaultOfferService.listObjects(ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId), arg_0 -> ((ObjectEntryWriter)objectEntryWriter).write(arg_0));
                objectEntryWriter.writeEof();
            }
            catch (Exception e) {
                LOGGER.error("Could not return object listing. Internal server error", (Throwable)e);
                throw new WebApplicationException("Could not return object listing", (Throwable)e);
            }
        };
        return Response.ok((Object)streamingOutput).build();
    }

    @GET
    @Path(value="/objects/{type}/logs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOfferLogs(@HeaderParam(value="X-Tenant-Id") String xTenantId, @PathParam(value="type") DataCategory type, OfferLogRequest offerLogRequest) {
        try {
            if (offerLogRequest == null) {
                LOGGER.error(MISSING_THE_BODY);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            try {
                String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
                List<OfferLog> offerLogs = this.defaultOfferService.getOfferLogs(containerName, offerLogRequest.getOffset(), offerLogRequest.getLimit(), offerLogRequest.getOrder());
                RequestResponseOK responseOK = new RequestResponseOK();
                responseOK.addAllResults(offerLogs).setHttpCode(Response.Status.OK.getStatusCode());
                LOGGER.debug("Result {}", (Object)responseOK);
                return Response.status((Response.Status)Response.Status.OK).entity((Object)JsonHandler.writeAsString((Object)responseOK)).build();
            }
            catch (ContentAddressableStorageException exc) {
                LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), (Throwable)exc);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.STORAGE_GET_OFFER_LOG_ERROR, (String)exc.getMessage()).toResponse();
            }
        }
        catch (Exception e) {
            LOGGER.error("An internal error occurred during offer log listing", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/objects/{type}/{id_object}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream", "application/zip"})
    public Response getObject(@PathParam(value="type") DataCategory type, @NotNull @PathParam(value="id_object") String objectId, @Context HttpHeaders headers) {
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        try {
            SanityChecker.checkParameter((String[])new String[]{objectId});
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
            ObjectContent objectContent = this.defaultOfferService.getObject(containerName, objectId);
            StreamingOutput streamingOutput = output -> {
                TaggedInputStream taggedInputStream = null;
                try {
                    taggedInputStream = new TaggedInputStream((InputStream)new ExactSizeInputStream(objectContent.getInputStream(), objectContent.getSize()));
                    IOUtils.copy((InputStream)taggedInputStream, (OutputStream)output);
                }
                catch (IOException e) {
                    if (taggedInputStream == null || taggedInputStream.isCauseOf((Throwable)e)) {
                        LOGGER.error("Server-side IOException. Could not serve object stream from CAS container", (Throwable)e);
                        throw new WebApplicationException("Server-side IOException. Could not serve object stream from CAS container", (Throwable)e);
                    }
                    throw e;
                }
                finally {
                    objectContent.getInputStream().close();
                }
            };
            return Response.ok((Object)streamingOutput).header("Content-Type", (Object)"application/octet-stream").header(VitamHttpHeader.X_CONTENT_LENGTH.getName(), (Object)String.valueOf(objectContent.getSize())).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_NOT_FOUND, e.getMessage());
        }
        catch (ContentAddressableStorageUnavailableDataFromAsyncOfferException e) {
            LOGGER.warn((Throwable)e);
            return this.buildCustomErrorResponse(CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER, e.getMessage());
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage());
        }
    }

    @POST
    @Path(value="/access-request/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccessRequest(@PathParam(value="type") DataCategory type, List<String> objectNames, @Context HttpHeaders headers) {
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        try {
            if (type == null) {
                LOGGER.error(MISSING_THE_DATA_TYPE_PARAMETER);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            if (objectNames == null || objectNames.isEmpty()) {
                LOGGER.error(MISSING_OBJECTS_IDS_LIST_PARAMETER);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
            String accessRequestId = this.defaultOfferService.createAccessRequest(containerName, objectNames);
            return new RequestResponseOK().addResult((Object)accessRequestId).setHttpCode(Response.Status.CREATED.getStatusCode()).toResponse();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_NOT_FOUND, e.getMessage());
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage());
        }
    }

    @GET
    @Path(value="/access-request/statuses")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkAccessRequestStatuses(List<String> accessRequestIds, @Context HttpHeaders headers) {
        try {
            ParametersChecker.checkParameter((String)"Missing accessRequestId", (Object[])new Object[]{accessRequestIds});
            ParametersChecker.checkParameter((String)"Missing accessRequestId", (String[])((String[])accessRequestIds.toArray(String[]::new)));
            for (String accessRequestId : accessRequestIds) {
                SanityChecker.checkParameter((String[])new String[]{accessRequestId});
            }
            String xTenantId = headers.getHeaderString("X-Tenant-Id");
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            String adminCrossTenantAccessRequestAllowedStr = headers.getHeaderString("X-Admin-Cross-Tenant-Access-Request-Allowed");
            if (Strings.isNullOrEmpty((String)adminCrossTenantAccessRequestAllowedStr)) {
                LOGGER.error("Required X-Admin-Cross-Tenant-Access-Request-Allowed header");
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            boolean adminCrossTenantAccessRequestAllowed = Boolean.parseBoolean(adminCrossTenantAccessRequestAllowedStr);
            Map<String, AccessRequestStatus> accessRequestStatus = this.defaultOfferService.checkAccessRequestStatuses(accessRequestIds, adminCrossTenantAccessRequestAllowed);
            return new RequestResponseOK().addResult(accessRequestStatus).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST, e.getMessage());
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage());
        }
    }

    @DELETE
    @Path(value="/access-request/{accessRequestId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeAccessRequest(@PathParam(value="accessRequestId") String accessRequestId, @Context HttpHeaders headers) {
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        try {
            SanityChecker.checkParameter((String[])new String[]{accessRequestId});
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            String adminCrossTenantAccessRequestAllowedStr = headers.getHeaderString("X-Admin-Cross-Tenant-Access-Request-Allowed");
            if (Strings.isNullOrEmpty((String)adminCrossTenantAccessRequestAllowedStr)) {
                LOGGER.error("Required X-Admin-Cross-Tenant-Access-Request-Allowed header");
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            boolean adminCrossTenantAccessRequestAllowed = Boolean.parseBoolean(adminCrossTenantAccessRequestAllowedStr);
            this.defaultOfferService.removeAccessRequest(accessRequestId, adminCrossTenantAccessRequestAllowed);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_BAD_REQUEST, e.getMessage());
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage());
        }
    }

    @GET
    @Path(value="/object-availability-check/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkObjectAvailability(@PathParam(value="type") DataCategory type, List<String> objectNames, @Context HttpHeaders headers) {
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        try {
            if (Strings.isNullOrEmpty((String)xTenantId)) {
                LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            if (objectNames == null || objectNames.isEmpty()) {
                LOGGER.error(MISSING_OBJECTS_IDS_LIST_PARAMETER);
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
            boolean areObjectsAvailable = this.defaultOfferService.checkObjectAvailability(containerName, objectNames);
            return new RequestResponseOK().addResult((Object)new StorageCheckObjectAvailabilityResult(areObjectsAvailable)).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (ContentAddressableStorageException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/objects/{type}/{objectId:.+}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response putObject(@PathParam(value="objectId") String objectId, @PathParam(value="type") DataCategory type, @Context HttpHeaders headers, InputStream input) {
        long inputStreamSize;
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        String size = headers.getHeaderString("Vitam-Content-Length");
        try {
            inputStreamSize = Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Bad or missing size '" + size + "'");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String xDigestAlgorithm = headers.getHeaderString("X-digest-algorithm");
        if (StringUtils.isEmpty((CharSequence)xDigestAlgorithm)) {
            LOGGER.error("Missing digest");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        DigestType digestType = DigestType.fromValue((String)xDigestAlgorithm);
        try {
            Response response;
            ExactSizeInputStream sis = new ExactSizeInputStream(input, inputStreamSize);
            try {
                LOGGER.info("Writing object '" + objectId + "' of container " + containerName + " (size: " + size + ")");
                SanityChecker.checkParameter((String[])new String[]{objectId});
                String digest = this.defaultOfferService.createObject(containerName, objectId, (InputStream)sis, type, inputStreamSize, digestType);
                response = Response.status((Response.Status)Response.Status.CREATED).entity((Object)("{\"digest\":\"" + digest + "\",\"size\":" + inputStreamSize + "}")).build();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ConnectionException e) {
                    LOGGER.error(RE_AUTHENTICATION_CALL_STREAM_ALREADY_CONSUMED_BUT_NO_FILE_CREATED, (Throwable)e);
                    Response response2 = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)JsonHandler.createObjectNode().put("msg", RE_AUTHENTICATION_CALL_STREAM_ALREADY_CONSUMED_BUT_NO_FILE_CREATED)).build();
                    return response2;
                }
                catch (NonUpdatableContentAddressableStorageException e) {
                    LOGGER.error("Object overriding forbidden", (Throwable)((Object)e));
                    Response response3 = Response.status((Response.Status)Response.Status.CONFLICT).build();
                    return response3;
                }
                catch (Exception exc) {
                    LOGGER.error("Cannot create object", (Throwable)exc);
                    Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                    return response4;
                }
            }
            sis.close();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/bulk/objects/{type}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response bulkPutObjects(@PathParam(value="type") DataCategory type, @Context HttpHeaders headers, InputStream input) {
        Response response;
        Long inputStreamSize;
        String xTenantId = headers.getHeaderString("X-Tenant-Id");
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        String size = headers.getHeaderString("Vitam-Content-Length");
        try {
            inputStreamSize = Long.valueOf(size);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Bad or missing size '" + size + "'");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            MultiplexedStreamReader multiplexedStreamReader = new MultiplexedStreamReader((InputStream)new ExactSizeInputStream(input, inputStreamSize.longValue()));
            Optional headerEntry = multiplexedStreamReader.readNextEntry();
            if (!headerEntry.isPresent()) {
                throw new IllegalStateException("Header entry not found");
            }
            List objectIds = (List)JsonHandler.getFromInputStream((InputStream)((InputStream)headerEntry.get()), List.class);
            String xDigestAlgorithm = headers.getHeaderString("X-digest-algorithm");
            if (StringUtils.isEmpty((CharSequence)xDigestAlgorithm)) {
                LOGGER.error("Missing digest");
                Response response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response2;
            }
            DigestType digestType = DigestType.fromValue((String)xDigestAlgorithm);
            StorageBulkPutResult storageBulkPutResult = this.defaultOfferService.bulkPutObjects(containerName, objectIds, multiplexedStreamReader, type, digestType);
            Response response3 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)storageBulkPutResult).build();
            return response3;
        }
        catch (NonUpdatableContentAddressableStorageException e) {
            LOGGER.error("Object overriding forbidden", (Throwable)((Object)e));
            response = Response.status((Response.Status)Response.Status.CONFLICT).build();
            return response;
        }
        catch (Exception exc) {
            LOGGER.error("Cannot create object", (Throwable)exc);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    @DELETE
    @Path(value="/objects/{type}/{id:.+}")
    @Produces(value={"application/json"})
    public Response deleteObject(@HeaderParam(value="X-Tenant-Id") String xTenantId, @HeaderParam(value="X-digest-algorithm") String xDigestAlgorithm, @PathParam(value="type") DataCategory type, @PathParam(value="id") String idObject) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            SanityChecker.checkParameter((String[])new String[]{idObject});
            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)Integer.parseInt(xTenantId)));
            String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
            this.defaultOfferService.deleteObject(containerName, idObject, type);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"id\":\"" + idObject + "\",\"status\":\"" + String.valueOf(Response.Status.OK) + "\"}")).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.info((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @HEAD
    @Path(value="/objects/{type}/{id:.+}")
    public Response checkObjectExistence(@PathParam(value="type") DataCategory type, @PathParam(value="id") String idObject, @HeaderParam(value="X-Tenant-Id") String xTenantId) {
        if (Strings.isNullOrEmpty((String)xTenantId)) {
            LOGGER.error(MISSING_THE_TENANT_ID_X_TENANT_ID);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        try {
            SanityChecker.checkParameter((String[])new String[]{idObject});
            if (this.defaultOfferService.isObjectExist(containerName, idObject)) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(ErrorMessage.INTERNAL_SERVER_ERROR.getMessage(), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/objects/{type}/{id:.+}/metadatas")
    @Produces(value={"application/json"})
    public Response getObjectMetadata(@PathParam(value="type") DataCategory type, @PathParam(value="id") String idObject, @HeaderParam(value="X-Tenant-Id") String xTenantId, @HeaderParam(value="X-Offer-No-Cache") Boolean noCache) {
        if (Strings.isNullOrEmpty((String)xTenantId) || noCache == null) {
            LOGGER.error("Missing tenant ID (X-Tenant-Id) or noCache");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        try {
            SanityChecker.checkParameter((String[])new String[]{idObject});
            StorageMetadataResult result = this.defaultOfferService.getMetadata(containerName, idObject, noCache);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.warn((Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (InvalidParseOperationException | ContentAddressableStorageException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/bulk/objects/{type}/metadata")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response getBulkObjectMetadata(@PathParam(value="type") DataCategory type, @HeaderParam(value="X-Tenant-Id") String xTenantId, @HeaderParam(value="X-Offer-No-Cache") Boolean noCache, List<String> objectIds) {
        if (Strings.isNullOrEmpty((String)xTenantId) || noCache == null) {
            LOGGER.error("Missing tenant ID (X-Tenant-Id) or noCache");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String containerName = ContainerUtils.buildContainerName((DataCategory)type, (String)xTenantId);
        try {
            ParametersChecker.checkParameter((String)"ObjectIds cannot be null", (Object[])new Object[]{objectIds});
            ParametersChecker.checkParameter((String)"ObjectIds cannot be null", (Object[])objectIds.toArray());
            for (String objectID : objectIds) {
                SanityChecker.checkParameter((String[])new String[]{objectID});
            }
            StorageBulkMetadataResult result = this.defaultOfferService.getBulkMetadata(containerName, objectIds, noCache);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="/compaction")
    @Consumes(value={"application/json"})
    public void launchOfferLogCompaction() throws Exception {
        try {
            LOGGER.info("Starting offer compaction.");
            this.defaultOfferService.compactOfferLogs();
            LOGGER.info("End offer compaction.");
        }
        catch (Exception e) {
            LOGGER.error("An internal error occurred during offer log compaction", (Throwable)e);
        }
    }

    private Response buildErrorResponse(VitamCode vitamCode, String message) {
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setHttpCode(vitamCode.getStatus().getStatusCode()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(Strings.isNullOrEmpty((String)message) ? vitamCode.getMessage() : message)).toString()).build();
    }

    private Response buildCustomErrorResponse(CustomVitamHttpStatusCode customStatusCode, String message) {
        return Response.status((int)customStatusCode.getStatusCode()).entity((Object)new RequestResponseError().setError(new VitamError(customStatusCode.toString()).setContext(ServiceName.STORAGE.getName()).setHttpCode(customStatusCode.getStatusCode()).setState(DomainName.STORAGE.getName()).setMessage(customStatusCode.getMessage()).setDescription(Strings.isNullOrEmpty((String)message) ? customStatusCode.getMessage() : message)).toString()).build();
    }
}

