/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.rest;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.storage.swift.Swift;
import fr.gouv.vitam.storage.offers.migration.SwiftMigrationRequest;
import fr.gouv.vitam.storage.offers.migration.SwiftMigrationService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/offer/v1/swift-migration")
@Tag(name="Admin-Offer")
public class AdminOfferSwiftMigrationResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminOfferSwiftMigrationResource.class);
    private final SwiftMigrationService swiftMigrationService;

    public AdminOfferSwiftMigrationResource(Swift swiftContentAddressableStorage) {
        this.swiftMigrationService = new SwiftMigrationService(swiftContentAddressableStorage.getOsClient());
    }

    @POST
    @Path(value="")
    @Consumes(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response launchSwiftMigration(SwiftMigrationRequest swiftMigrationRequest) {
        ParametersChecker.checkParameter((String)"Request required", (Object[])new Object[]{swiftMigrationRequest});
        ParametersChecker.checkParameter((String)"Swift migration mode required", (Object[])new Object[]{swiftMigrationRequest.getSwiftMigrationMode()});
        LOGGER.info("Starting swift offer migration - " + String.valueOf((Object)swiftMigrationRequest.getSwiftMigrationMode()));
        boolean migrationStarted = this.swiftMigrationService.tryStartMigration(swiftMigrationRequest.getSwiftMigrationMode());
        if (!migrationStarted) {
            LOGGER.info("Swift offer migration is already running.");
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        LOGGER.info("Swift offer migration started successfully.");
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @HEAD
    @Path(value="")
    @Consumes(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response checkSwiftMigrationInProgress() {
        boolean migrationInProgress = this.swiftMigrationService.isMigrationInProgress();
        if (!migrationInProgress) {
            LOGGER.info("Swift migration still in progress");
            return Response.ok().build();
        }
        LOGGER.info("No active swift migration");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="")
    @Consumes(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    public Response getSwiftMigrationResult() {
        boolean hasMigrationSucceeded = this.swiftMigrationService.hasMigrationSucceeded();
        if (hasMigrationSucceeded) {
            LOGGER.info("Swift migration succeeded");
            return Response.ok().build();
        }
        LOGGER.error("Swift migration failed");
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }
}

