/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.migration;

import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.storage.cas.container.api.ObjectContent;
import fr.gouv.vitam.common.storage.swift.VitamSwiftObjectStorageService;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.utils.ContainerUtils;
import fr.gouv.vitam.storage.offers.migration.SwiftMigrationMode;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.storage.object.SwiftObject;
import org.openstack4j.model.storage.object.options.ObjectListOptions;
import org.openstack4j.model.storage.object.options.ObjectPutOptions;

public class SwiftMigrationService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SwiftMigrationService.class);
    private final AtomicBoolean isRunning = new AtomicBoolean();
    private final AtomicBoolean migrationSucceeded = new AtomicBoolean();
    private final Supplier<OSClient> osClient;

    public SwiftMigrationService(Supplier<OSClient> osClient) {
        this.osClient = osClient;
    }

    public boolean tryStartMigration(SwiftMigrationMode swiftMigrationMode) {
        boolean lockAcquired = this.isRunning.compareAndSet(false, true);
        if (!lockAcquired) {
            return false;
        }
        this.migrationSucceeded.set(false);
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                LOGGER.warn("Starting swift offer migration : " + swiftMigrationMode.toString());
                this.migrateOffer(swiftMigrationMode);
            }
            catch (Exception e) {
                LOGGER.error("A fatal error occurred during swift offer migration", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
                LOGGER.info("Swift offer migration finished");
            }
        });
        return true;
    }

    public boolean isMigrationInProgress() {
        return this.isRunning.get();
    }

    public boolean hasMigrationSucceeded() {
        return this.migrationSucceeded.get();
    }

    private void migrateOffer(SwiftMigrationMode swiftMigrationMode) throws ContentAddressableStorageException, IOException {
        VitamSwiftObjectStorageService vitamSwiftObjectStorageService = new VitamSwiftObjectStorageService(this.osClient);
        for (Integer tenant : VitamConfiguration.getTenants()) {
            for (DataCategory dataCategory : DataCategory.values()) {
                String containerName = ContainerUtils.buildContainerName((DataCategory)dataCategory, (String)tenant.toString());
                this.migrateContainer(swiftMigrationMode, vitamSwiftObjectStorageService, containerName);
            }
        }
        this.migrationSucceeded.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateContainer(SwiftMigrationMode swiftMigrationMode, VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName) throws ContentAddressableStorageException, IOException {
        LOGGER.warn("Processing swift migration for container " + containerName + ": (" + String.valueOf((Object)swiftMigrationMode) + ")");
        Stopwatch timer = Stopwatch.createStarted();
        try {
            if (!this.isExistingContainer(containerName)) {
                LOGGER.info("Container " + containerName + " not exists.");
                return;
            }
            MultiValuedMap<String, String> largeObjectChunksByObjectName = this.listLargeObjects(vitamSwiftObjectStorageService, containerName);
            for (String objectName : largeObjectChunksByObjectName.keySet()) {
                this.processLargeObjet(swiftMigrationMode, vitamSwiftObjectStorageService, containerName, objectName, largeObjectChunksByObjectName.get((Object)objectName));
            }
        }
        finally {
            LOGGER.warn("Done migrating swift container " + containerName + " in " + timer.elapsed(TimeUnit.SECONDS) + " seconds.");
        }
    }

    private boolean isExistingContainer(String containerName) {
        Map metadata = this.osClient.get().objectStorage().containers().getMetadata(containerName);
        return metadata.size() > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiValuedMap<String, String> listLargeObjects(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName) throws ContentAddressableStorageException {
        LOGGER.warn("Listing objects for container " + containerName + "...");
        Stopwatch timer = Stopwatch.createStarted();
        int listedObjects = 0;
        try {
            List swiftObjects;
            ArrayListValuedHashMap largeObjectChunksByObjectName = new ArrayListValuedHashMap();
            String nextMarker = null;
            do {
                ObjectListOptions objectListOptions = ObjectListOptions.create().limit(100);
                if (nextMarker != null) {
                    objectListOptions.marker(nextMarker);
                }
                if ((swiftObjects = vitamSwiftObjectStorageService.list(containerName, objectListOptions, Collections.emptyMap())).isEmpty()) break;
                LOGGER.info("Found objets & object segments: " + (listedObjects += swiftObjects.size()));
                for (SwiftObject swiftObject : swiftObjects) {
                    if (!swiftObject.getName().matches("^.*/\\d+$")) continue;
                    String objectName = StringUtils.substringBeforeLast((String)swiftObject.getName(), (String)"/");
                    largeObjectChunksByObjectName.put((Object)objectName, (Object)swiftObject.getName());
                    LOGGER.info("Segment to process " + containerName + "/" + swiftObject.getName());
                }
            } while ((nextMarker = ((SwiftObject)swiftObjects.get(swiftObjects.size() - 1)).getName()) != null);
            ArrayListValuedHashMap arrayListValuedHashMap = largeObjectChunksByObjectName;
            return arrayListValuedHashMap;
        }
        finally {
            LOGGER.warn("Listing objects took " + timer.elapsed(TimeUnit.SECONDS) + " seconds. Total objects found in container " + containerName + ": " + listedObjects);
        }
    }

    private void processLargeObjet(SwiftMigrationMode swiftMigrationMode, VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, Collection<String> segments) throws ContentAddressableStorageException, IOException {
        LOGGER.info("Processing large object " + containerName + "/" + objectName);
        Optional manifestObject = vitamSwiftObjectStorageService.getObjectInformation(containerName, objectName, Collections.emptyMap());
        if (manifestObject.isEmpty()) {
            this.deleteOrphanObjectSegments(swiftMigrationMode, vitamSwiftObjectStorageService, containerName, objectName, segments);
            return;
        }
        SortedSet<String> newSegmentNames = this.migrateObjectSegmentNames(swiftMigrationMode, vitamSwiftObjectStorageService, containerName, objectName, segments);
        TreeMap<String, String> objectMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        objectMetadata.putAll(((SwiftObject)manifestObject.get()).getMetadata());
        this.migrateLargeObjectManifest(swiftMigrationMode, vitamSwiftObjectStorageService, containerName, objectName, newSegmentNames, objectMetadata);
    }

    private void deleteOrphanObjectSegments(SwiftMigrationMode swiftMigrationMode, VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, Collection<String> segments) throws ContentAddressableStorageException {
        if (!swiftMigrationMode.isDeleteOrphanSegments()) {
            LOGGER.warn("INCONSISTENCY FOUND : Orphan large object segments " + String.valueOf(segments) + " without parent object manifest: " + containerName + "/" + objectName + ". Eliminated object? Incomplete write? Run migration script with delete mode to prune container.");
            return;
        }
        LOGGER.warn("DELETING orphan large object segments (elimination? incomplete write?): " + containerName + "/" + objectName + ". Cleaning up its segments " + String.valueOf(segments));
        for (String segmentName : segments) {
            vitamSwiftObjectStorageService.deleteFullObject(containerName, segmentName, null, Collections.emptyMap());
        }
    }

    private SortedSet<String> migrateObjectSegmentNames(SwiftMigrationMode swiftMigrationMode, VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, Collection<String> segments) throws IOException, ContentAddressableStorageException {
        HashMap<String, String> oldSegmentNamesToMigrate = new HashMap<String, String>();
        TreeSet<String> targetSegmentNames = new TreeSet<String>();
        for (String segmentName : segments) {
            if (this.isOldSegmentNameFormat(segmentName)) {
                String targetSegmentName = this.oldSegmentNameToNewSegmentName(segmentName);
                oldSegmentNamesToMigrate.put(segmentName, targetSegmentName);
                targetSegmentNames.add(targetSegmentName);
                continue;
            }
            targetSegmentNames.add(segmentName);
        }
        if (oldSegmentNamesToMigrate.isEmpty()) {
            LOGGER.info("All segment names already migrated for object " + containerName + "/" + objectName);
            return targetSegmentNames;
        }
        if (!swiftMigrationMode.isFixInconsistencies()) {
            LOGGER.warn("INCONSISTENCY FOUND : Object " + containerName + "/" + objectName + " has old segment names " + String.valueOf(oldSegmentNamesToMigrate.keySet()) + ". Run migration script with fix inconsistencies mode to prune container.");
            return targetSegmentNames;
        }
        for (String oldSegmentName : oldSegmentNamesToMigrate.keySet()) {
            String newSegmentName = (String)oldSegmentNamesToMigrate.get(oldSegmentName);
            this.renameSegment(vitamSwiftObjectStorageService, containerName, oldSegmentName, newSegmentName);
        }
        return targetSegmentNames;
    }

    private boolean isOldSegmentNameFormat(String segmentName) {
        String segmentId = StringUtils.substringAfterLast((String)segmentName, (String)"/");
        return segmentId.length() < 8;
    }

    private String oldSegmentNameToNewSegmentName(String segmentName) {
        String segmentPrefix = StringUtils.substringBeforeLast((String)segmentName, (String)"/");
        String segmentId = StringUtils.substringAfterLast((String)segmentName, (String)"/");
        return segmentPrefix + "/" + StringUtils.leftPad((String)segmentId, (int)8, (char)'0');
    }

    private void renameSegment(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String oldSegmentName, String newSegmentName) throws ContentAddressableStorageException, IOException {
        LOGGER.warn("Renaming segment " + containerName + "/" + oldSegmentName + " to " + containerName + "/" + newSegmentName);
        ObjectPutOptions objectPutOptions = ObjectPutOptions.create();
        objectPutOptions.getOptions().put("X-Copy-From", containerName + "/" + oldSegmentName);
        vitamSwiftObjectStorageService.put(containerName, newSegmentName, Payloads.create((InputStream)new NullInputStream(0L)), objectPutOptions);
        String oldSegmentDigest = this.computeDigest(vitamSwiftObjectStorageService, containerName, oldSegmentName);
        String newSegmentDigest = this.computeDigest(vitamSwiftObjectStorageService, containerName, newSegmentName);
        if (!oldSegmentDigest.equals(newSegmentDigest)) {
            throw new IllegalStateException(String.format("Copied segment %s/%s digest (%s) does not match old segment %s/%s digest (%s)", containerName, newSegmentName, newSegmentDigest, containerName, oldSegmentName, oldSegmentDigest));
        }
        vitamSwiftObjectStorageService.deleteFullObject(containerName, oldSegmentName, null, Collections.emptyMap());
    }

    private String computeDigest(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String segmentName) throws ContentAddressableStorageException, IOException {
        ObjectContent segmentContent = vitamSwiftObjectStorageService.download(containerName, segmentName, Collections.emptyMap());
        try (InputStream inputStream = segmentContent.getInputStream();){
            String string;
            try (ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream(inputStream, segmentContent.getSize());){
                Digest segmentDigest = new Digest(VitamConfiguration.getDefaultDigestType());
                segmentDigest.update((InputStream)exactSizeInputStream);
                string = segmentDigest.digestHex();
            }
            return string;
        }
    }

    private void migrateLargeObjectManifest(SwiftMigrationMode swiftMigrationMode, VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, SortedSet<String> sortedSegmentNames, Map<String, String> objectMetadata) throws ContentAddressableStorageException, IOException {
        if (objectMetadata.containsKey("X-Object-Manifest") && objectMetadata.containsKey("X-Object-Meta-Digest") && objectMetadata.containsKey("X-Object-Meta-Digest-Type")) {
            LOGGER.info("No migration needed for object manifest " + containerName + "/" + objectName);
            return;
        }
        if (!swiftMigrationMode.isFixInconsistencies()) {
            LOGGER.warn("INCONSISTENCY FOUND : Object " + containerName + "/" + objectName + " has missing metadata. Run migration script with fix inconsistencies mode enabled to set object metadata.");
            return;
        }
        String globalDigest = this.computeGlobalDigestFromSegments(vitamSwiftObjectStorageService, containerName, sortedSegmentNames);
        this.checkInitialObjectDigestMetadata(containerName, objectName, objectMetadata, globalDigest);
        this.updateLargeObjectManifest(vitamSwiftObjectStorageService, containerName, objectName, globalDigest);
        this.doubleCheckObjectManifest(vitamSwiftObjectStorageService, containerName, objectName, globalDigest);
        LOGGER.warn("Object " + containerName + "/" + objectName + " migrated successfully. Digest: " + globalDigest);
    }

    private String computeGlobalDigestFromSegments(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, SortedSet<String> sortedSegmentNames) throws ContentAddressableStorageException, IOException {
        Digest globalDigest = new Digest(VitamConfiguration.getDefaultDigestType());
        for (String segmentName : sortedSegmentNames) {
            ObjectContent segmentContent = vitamSwiftObjectStorageService.download(containerName, segmentName, Collections.emptyMap());
            InputStream inputStream = segmentContent.getInputStream();
            try (ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream(inputStream, segmentContent.getSize());){
                globalDigest.update((InputStream)exactSizeInputStream);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return globalDigest.digestHex();
    }

    private void checkInitialObjectDigestMetadata(String containerName, String objectName, Map<String, String> objectMetadata, String globalDigest) {
        String declaredDigestType = objectMetadata.get("X-Object-Meta-Digest-Type");
        if (declaredDigestType != null && !declaredDigestType.equals(VitamConfiguration.getDefaultDigestType().getName())) {
            throw new IllegalStateException("Illegal object " + containerName + "/" + objectName + " digest type. Expected: " + VitamConfiguration.getDefaultDigestType().getName() + ", actual: " + declaredDigestType);
        }
        String declaredObjectDigest = objectMetadata.get("X-Object-Meta-Digest");
        if (declaredObjectDigest != null && !declaredObjectDigest.equals(globalDigest)) {
            throw new IllegalStateException("Illegal object " + containerName + "/" + objectName + " digest. Expected=" + globalDigest + ", actual= " + declaredObjectDigest);
        }
    }

    private void updateLargeObjectManifest(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, String digest) throws ContentAddressableStorageException {
        String largeObjectPrefix = containerName + "/" + objectName + "/";
        ObjectPutOptions options = ObjectPutOptions.create();
        options.getOptions().put("X-Object-Manifest", largeObjectPrefix);
        options.getOptions().put("X-Object-Meta-Digest", digest);
        options.getOptions().put("X-Object-Meta-Digest-Type", VitamConfiguration.getDefaultDigestType().getName());
        vitamSwiftObjectStorageService.put(containerName, objectName, Payloads.create((InputStream)new NullInputStream(0L)), options);
    }

    private void doubleCheckObjectManifest(VitamSwiftObjectStorageService vitamSwiftObjectStorageService, String containerName, String objectName, String expectedDigest) throws ContentAddressableStorageException, IOException {
        String actualGlobalDigest = this.computeDigest(vitamSwiftObjectStorageService, containerName, objectName);
        if (!actualGlobalDigest.equals(expectedDigest)) {
            throw new IllegalStateException("Invalid digest value for object " + containerName + "/" + objectName + ". Expected: " + expectedDigest + ", actual: " + actualGlobalDigest);
        }
        Optional updatedManifestObject = vitamSwiftObjectStorageService.getObjectInformation(containerName, objectName, Collections.emptyMap());
        if (updatedManifestObject.isEmpty()) {
            throw new IllegalStateException("Could not read manifest " + containerName + "/" + objectName);
        }
        TreeMap updatedObjectMetadata = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        updatedObjectMetadata.putAll(((SwiftObject)updatedManifestObject.get()).getMetadata());
        String expectedObjectPrefix = containerName + "/" + objectName + "/";
        String actualObjectPrefix = (String)updatedObjectMetadata.get("X-Object-Manifest");
        if (!expectedObjectPrefix.equals(actualObjectPrefix)) {
            throw new IllegalStateException("Manifest header not found for updated manifest " + containerName + "/" + objectName + ". Expected: " + expectedObjectPrefix + ", actual: " + actualObjectPrefix);
        }
        String updatedDigestType = (String)updatedObjectMetadata.get("X-Object-Meta-Digest-Type");
        if (!VitamConfiguration.getDefaultDigestType().getName().equals(updatedDigestType)) {
            throw new IllegalStateException("Invalid updated digest type. Expected: " + VitamConfiguration.getDefaultDigestType().getName() + ", actual: " + updatedDigestType);
        }
        String updatedManifestDigestValue = (String)updatedObjectMetadata.get("X-Object-Meta-Digest");
        if (!expectedDigest.equals(updatedManifestDigestValue)) {
            throw new IllegalStateException("Invalid digest value for updated manifest object " + containerName + "/" + objectName + ". Expected: " + expectedDigest + ", actual: " + updatedManifestDigestValue);
        }
    }
}

