/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.database;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDatabaseException;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OfferSequenceDatabaseService {
    public static final String BACKUP_LOG_SEQUENCE_ID = "Backup_Log_Sequence";
    private MongoCollection<Document> mongoCollection;

    public OfferSequenceDatabaseService(MongoCollection<Document> mongoCollection) {
        this.mongoCollection = mongoCollection;
    }

    public long getNextSequence(String sequenceId) throws ContentAddressableStorageDatabaseException {
        return this.getNextSequence(sequenceId, 1L);
    }

    public long getNextSequence(String sequenceId, long inc) throws ContentAddressableStorageDatabaseException {
        try {
            BasicDBObject incQuery = new BasicDBObject();
            incQuery.append("$inc", (Object)new BasicDBObject("Counter", (Object)inc));
            Bson query = Filters.eq((String)"_id", (Object)sequenceId);
            FindOneAndUpdateOptions findOneAndUpdateOptions = new FindOneAndUpdateOptions();
            findOneAndUpdateOptions.returnDocument(ReturnDocument.AFTER);
            findOneAndUpdateOptions.upsert(true);
            Document sequence = (Document)this.mongoCollection.findOneAndUpdate(query, (Bson)incQuery, findOneAndUpdateOptions);
            if (sequence != null) {
                return sequence.getLong((Object)"Counter") + 1L - inc;
            }
            throw new ContentAddressableStorageDatabaseException(String.format("Database Error sequence %s not found", sequenceId));
        }
        catch (MongoException e) {
            throw new ContentAddressableStorageDatabaseException(String.format("Database Error while getting next sequence value for %s", sequenceId), (Throwable)e);
        }
    }
}

