/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.database;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.Sorts;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.collection.CloseableIterable;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.OfferLogAction;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageDatabaseException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.commons.collections4.IteratorUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OfferLogDatabaseService {
    private final MongoCollection<Document> mongoCollection;

    public OfferLogDatabaseService(MongoCollection<Document> mongoCollection) {
        this.mongoCollection = mongoCollection;
    }

    public void save(String containerName, String fileName, OfferLogAction action, long sequence) throws ContentAddressableStorageServerException, ContentAddressableStorageDatabaseException {
        try {
            OfferLog offerLog = new OfferLog(sequence, LocalDateUtil.now(), containerName, fileName, action);
            this.mongoCollection.insertOne((Object)Document.parse((String)JsonHandler.writeAsString((Object)offerLog)));
        }
        catch (MongoException e) {
            throw new ContentAddressableStorageDatabaseException(String.format("Database Error while saving %s in OfferLog collection", fileName), (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            throw new ContentAddressableStorageServerException("Cannot parse storage log", (Throwable)e);
        }
    }

    public void bulkSave(String containerName, List<String> fileNames, OfferLogAction action, long sequence) throws ContentAddressableStorageServerException, ContentAddressableStorageDatabaseException {
        try {
            ArrayList<Document> documents = new ArrayList<Document>();
            for (String fileName : fileNames) {
                OfferLog offerLog = new OfferLog(sequence, LocalDateUtil.now(), containerName, fileName, action);
                documents.add(Document.parse((String)JsonHandler.writeAsString((Object)offerLog)));
                ++sequence;
            }
            this.mongoCollection.insertMany(documents, new InsertManyOptions().ordered(false));
        }
        catch (MongoException e) {
            throw new ContentAddressableStorageDatabaseException(String.format("Database Error while saving %s in OfferLog collection", fileNames), (Throwable)e);
        }
        catch (InvalidParseOperationException exc) {
            throw new ContentAddressableStorageServerException("Cannot parse storage log", (Throwable)exc);
        }
    }

    public List<OfferLog> getDescendingOfferLogsBy(String containerName, Long offset, int limit) {
        Bson searchFilter = offset != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Container", (Object)containerName), Filters.lte((String)"Sequence", (Object)offset)}) : Filters.eq((String)"Container", (Object)containerName);
        try (MongoCursor cursor = this.mongoCollection.find(searchFilter).sort(Sorts.orderBy((Bson[])new Bson[]{Sorts.descending((String[])new String[]{"Sequence"})})).limit(limit).map(this::transformDocumentToOfferLog).cursor();){
            List list = IteratorUtils.toList((Iterator)cursor);
            return list;
        }
    }

    public List<OfferLog> getAscendingOfferLogsBy(String containerName, Long offset, int limit) {
        Bson searchFilter = offset != null ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"Container", (Object)containerName), Filters.gte((String)"Sequence", (Object)offset)}) : Filters.eq((String)"Container", (Object)containerName);
        try (MongoCursor cursor = this.mongoCollection.find(searchFilter).sort(Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"Sequence"})})).limit(limit).map(this::transformDocumentToOfferLog).cursor();){
            List list = IteratorUtils.toList((Iterator)cursor);
            return list;
        }
    }

    public CloseableIterable<OfferLog> getExpiredOfferLogByContainer(long expirationValue, ChronoUnit expirationUnit) {
        LocalDateTime expirationDate = LocalDateUtil.now().minus(expirationValue, expirationUnit);
        return this.toCloseableIterable((MongoIterable<OfferLog>)this.mongoCollection.find(Filters.lte((String)"Time", (Object)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)expirationDate))).sort(Sorts.ascending((String[])new String[]{"Container", "Sequence"})).map(d -> new OfferLog(((Number)d.get((Object)"Sequence")).longValue(), LocalDateUtil.parseMongoFormattedDate((String)LocalDateUtil.getFormattedDateTimeForMongo((String)d.getString((Object)"Time"))), d.getString((Object)"Container"), d.getString((Object)"FileName"), OfferLogAction.valueOf((String)d.getString((Object)"Action").toUpperCase()))));
    }

    private OfferLog transformDocumentToOfferLog(Document document) {
        try {
            return (OfferLog)BsonHelper.fromDocumentToObject((Document)document, OfferLog.class);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private CloseableIterable<OfferLog> toCloseableIterable(final MongoIterable<OfferLog> mongoIterable) {
        return new CloseableIterable<OfferLog>(){

            public Iterator<OfferLog> iterator() {
                return mongoIterable.iterator();
            }

            public void forEach(Consumer<? super OfferLog> action) {
                mongoIterable.forEach(action);
            }

            public Spliterator<OfferLog> spliterator() {
                return mongoIterable.spliterator();
            }

            public void close() {
                mongoIterable.cursor().close();
            }
        };
    }
}

