/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.database;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.CompactedOfferLog;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OfferLogAndCompactedOfferLogService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OfferLogAndCompactedOfferLogService.class);
    private static final AlertService alertService = new AlertServiceImpl();
    private final MongoCollection<Document> offerLogCollection;
    private final MongoCollection<Document> compactedOfferLogCollection;

    public OfferLogAndCompactedOfferLogService(MongoCollection<Document> offerLogCollection, MongoCollection<Document> compactedOfferLogCollection) {
        this.offerLogCollection = offerLogCollection;
        this.compactedOfferLogCollection = compactedOfferLogCollection;
    }

    public void almostTransactionalSaveAndDelete(CompactedOfferLog toSave, List<OfferLog> toDelete) {
        try {
            this.save(toSave);
            this.delete(toDelete);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during offer log compaction. Possible CompactedOfferLog corruption", (Throwable)e);
            alertService.createAlert("An error occurred during offer log compaction. Possible CompactedOfferLog corruption");
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private void save(CompactedOfferLog compactedOfferLog) {
        Bson filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"SequenceStart", (Object)compactedOfferLog.getSequenceStart()), Filters.eq((String)"SequenceEnd", (Object)compactedOfferLog.getSequenceEnd()), Filters.eq((String)"Container", (Object)compactedOfferLog.getContainer())});
        CompactedOfferLog alreadySavedOfferLogCompacted = (CompactedOfferLog)this.compactedOfferLogCollection.find(filters).map(this::transformDocumentToOfferLogCompaction).first();
        if (alreadySavedOfferLogCompacted != null) {
            throw new VitamRuntimeException(String.format("Incoherent data between CompactedOfferLog and OfferLog collection, compaction offer logs '%s' already inserted.", alreadySavedOfferLogCompacted));
        }
        try {
            this.compactedOfferLogCollection.insertOne((Object)Document.parse((String)JsonHandler.writeAsString((Object)compactedOfferLog)));
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private void delete(List<OfferLog> offerLogs) {
        OfferLog first = offerLogs.get(0);
        OfferLog end = offerLogs.get(offerLogs.size() - 1);
        this.offerLogCollection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"Container", (Object)first.getContainer()), Filters.lte((String)"Sequence", (Object)end.getSequence()), Filters.gte((String)"Sequence", (Object)first.getSequence())}));
    }

    private CompactedOfferLog transformDocumentToOfferLogCompaction(Document document) {
        try {
            return (CompactedOfferLog)BsonHelper.fromDocumentToObject((Document)document, CompactedOfferLog.class);
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

