/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import fr.gouv.vitam.common.PropertiesUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.Logger;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ConfigurationException;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.StringValidationRule;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class HTMLValidationRule
extends StringValidationRule {
    private static Policy antiSamyPolicy = null;
    private static final Logger LOGGER = ESAPI.getLogger((String)"HTMLValidationRule");
    private static final String ANTISAMYPOLICY_FILENAME = "antisamy-esapi.xml";

    public HTMLValidationRule(String typeName) {
        super(typeName);
    }

    public HTMLValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
    }

    public HTMLValidationRule(String typeName, Encoder encoder, String whitelistPattern) {
        super(typeName, encoder, whitelistPattern);
    }

    public String getValid(String context, String input) throws ValidationException {
        return this.invokeAntiSamy(context, input);
    }

    public String sanitize(String context, String input) {
        String safe = "";
        try {
            safe = this.invokeAntiSamy(context, input);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return safe;
    }

    private String invokeAntiSamy(String context, String input) throws ValidationException {
        if (StringUtilities.isEmpty((String)input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + " is required", "AntiSamy validation error: context=" + context + ", input=" + input, context);
        }
        String canonical = super.getValid(context, input);
        try {
            AntiSamy as = new AntiSamy();
            CleanResults test = as.scan(canonical, antiSamyPolicy);
            List errors = test.getErrorMessages();
            if (!errors.isEmpty()) {
                LOGGER.info(Logger.SECURITY_FAILURE, "Cleaned up invalid HTML input: " + String.valueOf(errors));
            }
            return test.getCleanHTML().trim();
        }
        catch (ScanException e) {
            throw new ValidationException(context + ": Invalid HTML input", "Invalid HTML input: context=" + context + " error=" + e.getMessage(), (Throwable)e, context);
        }
        catch (PolicyException e) {
            throw new ValidationException(context + ": Invalid HTML input", "Invalid HTML input does not follow rules in antisamy-esapi.xml: context=" + context + " error=" + e.getMessage(), (Throwable)e, context);
        }
    }

    static {
        InputStream resourceStream = null;
        try {
            resourceStream = ESAPI.securityConfiguration().getResourceStream(ANTISAMYPOLICY_FILENAME);
        }
        catch (IOException e) {
            ClassLoader[] loaders;
            LOGGER.info(null, "Loading antisamy-esapi.xml from classpaths", (Throwable)e);
            for (ClassLoader loader : loaders = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), HTMLValidationRule.class.getClassLoader()}) {
                resourceStream = loader.getResourceAsStream(ANTISAMYPOLICY_FILENAME);
                if (resourceStream == null) continue;
                LOGGER.info(null, "Successfully loaded antisamy policy from classpath");
                break;
            }
            try {
                resourceStream = PropertiesUtils.getResourceAsStream((String)"esapi/antisamy-esapi.xml");
                if (resourceStream != null) {
                    LOGGER.info(null, "Successfully loaded antisamy policy from Vitam classpath");
                }
            }
            catch (FileNotFoundException e1) {
                LOGGER.info(null, "Cannot loaded antisamy policy from Vitam classpath", (Throwable)e1);
            }
        }
        if (resourceStream != null) {
            try {
                antiSamyPolicy = Policy.getInstance((InputStream)resourceStream);
            }
            catch (PolicyException e) {
                throw new ConfigurationException("Couldn't parse antisamy policy", (Throwable)e);
            }
        } else {
            throw new ConfigurationException("Couldn't find antisamy-esapi.xml");
        }
    }
}

