/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.tenant.filter;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class TenantFilter
implements Filter {
    private String tenantsAsString;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TenantFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            this.tenantsAsString = filterConfig.getServletContext().getInitParameter("tenantList");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Response.Status status = this.checkTenantHeaders((HttpServletRequest)request);
        if (Response.Status.PRECONDITION_FAILED.getStatusCode() == status.getStatusCode() || Response.Status.UNAUTHORIZED.getStatusCode() == status.getStatusCode()) {
            LOGGER.error("X-Tenant-Id check failed!");
            HttpServletResponse newResponse = (HttpServletResponse)response;
            newResponse.sendError(status.getStatusCode(), JsonHandler.unprettyPrint((Object)JsonHandler.createObjectNode().put("Error", "X-Tenant-Id check failed!")));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private Response.Status checkTenantHeaders(HttpServletRequest request) {
        if (request.getRequestURI().startsWith("/admin/v1") || request.getRequestURI().endsWith("/status")) {
            return Response.Status.OK;
        }
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            try {
                int idTenant = Integer.parseInt(request.getHeader("X-Tenant-Id"));
                try {
                    JsonNode tenants = JsonHandler.getFromString((String)this.tenantsAsString);
                    for (JsonNode tenant : tenants) {
                        if (idTenant != tenant.asInt()) continue;
                        return Response.Status.OK;
                    }
                    return Response.Status.UNAUTHORIZED;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("TenantId check failed - tenants list incorrect");
                    return Response.Status.PRECONDITION_FAILED;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Tenant not Integer", (Throwable)e);
            }
        }
        return Response.Status.PRECONDITION_FAILED;
    }
}

