/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.stream;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ProducerConsumerLock
implements AutoCloseable {
    private final Lock lock = new ReentrantLock();
    private final Condition canWrite = this.lock.newCondition();
    private final Condition canRead = this.lock.newCondition();
    private int writeCapacity;
    private int readCapacity;
    private volatile boolean closed = false;

    public ProducerConsumerLock(int bufferCapacity) {
        this.writeCapacity = bufferCapacity;
        this.readCapacity = 0;
    }

    public boolean tryBeginProduce(int units) throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.closed && this.writeCapacity < units) {
                this.canWrite.await();
            }
            this.writeCapacity -= units;
            boolean bl = !this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endProduce(int units) {
        this.lock.lock();
        try {
            this.readCapacity += units;
            this.canRead.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryBeginConsume(int units) throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.closed && this.readCapacity == 0) {
                this.canRead.await();
            }
            int immediatelyAvailable = Math.min(units, this.readCapacity);
            this.readCapacity -= immediatelyAvailable;
            int n = immediatelyAvailable;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endConsume(int units) {
        this.lock.lock();
        try {
            this.writeCapacity += units;
            this.canWrite.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            this.canRead.signal();
            this.canWrite.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

