/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.server.application.resources;

import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.client.MockOrRestClient;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.configuration.DatabaseConnection;
import fr.gouv.vitam.common.server.application.resources.BasicVitamStatusServiceImpl;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class VitamServiceRegistry {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamServiceRegistry.class);
    private static final String SERVICE_IS_UNAVAILABLE = " service is unavailable";
    private static final String SERVICE_IS_AVAILABLE = " service is available";
    private final List<VitamClientFactoryInterface<?>> clientFactories = new ArrayList();
    private final List<VitamClientFactoryInterface<?>> clientOptionalFactories = new ArrayList();
    private final List<DatabaseConnection> databaseFactories = new ArrayList<DatabaseConnection>();
    private VitamStatusService applicationStatus = new BasicVitamStatusServiceImpl();

    public VitamServiceRegistry register(VitamClientFactoryInterface<?> factory) {
        if (factory != null) {
            this.clientFactories.add(factory);
        }
        return this;
    }

    public VitamServiceRegistry registerOptional(VitamClientFactoryInterface<?> factory) {
        if (factory != null) {
            this.clientOptionalFactories.add(factory);
        }
        return this;
    }

    public VitamServiceRegistry register(DatabaseConnection database) {
        if (database != null) {
            this.databaseFactories.add(database);
        }
        return this;
    }

    public VitamServiceRegistry register(VitamStatusService service) {
        if (service != null) {
            this.applicationStatus = service;
        }
        return this;
    }

    public int getRegisteredServices() {
        return this.databaseFactories.size() + this.clientFactories.size() + this.clientOptionalFactories.size() + 1;
    }

    public boolean getResourcesStatus() {
        for (VitamClientFactoryInterface<?> factory : this.clientFactories) {
            try {
                MockOrRestClient client = factory.getClient();
                try {
                    client.checkStatus();
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (VitamApplicationServerException e) {
                LOGGER.info("Can't connect to factory: " + factory.toString(), (Throwable)e);
                return false;
            }
        }
        for (DatabaseConnection database : this.databaseFactories) {
            if (database.checkConnection()) continue;
            LOGGER.info("Can't connect to database: " + database.toString());
            return false;
        }
        return this.applicationStatus.getResourcesStatus();
    }

    public void checkDependencies(int retry, long retryDelay) throws VitamApplicationServerException, InterruptedException {
        for (int i = 0; i < retry; ++i) {
            if (this.getResourcesStatus()) {
                return;
            }
            Thread.sleep(retryDelay);
        }
        String status = "Dependencies in error after " + retry + " checks : " + JsonHandler.prettyPrint((Object)this.getAutotestStatus());
        LOGGER.error(status);
        throw new VitamApplicationServerException(status);
    }

    public ObjectNode getAutotestStatus() {
        MockOrRestClient client;
        VitamError sub;
        String name;
        VitamError status = new VitamError("000000").setDescription(ServerIdentity.getInstance().getName()).setContext(ServerIdentity.getInstance().getRole());
        int test = 0;
        boolean globalStatus = true;
        ArrayList<VitamError> list = new ArrayList<VitamError>();
        for (VitamClientFactoryInterface<?> factory : this.clientFactories) {
            name = StringUtils.getClassName(factory);
            sub = new VitamError(Integer.toString(++test)).setContext(name);
            try {
                client = factory.getClient();
                try {
                    client.checkStatus();
                    sub.setDescription(name + SERVICE_IS_AVAILABLE).setHttpCode(Response.Status.OK.getStatusCode()).setMessage("Sub service is available").setState(Response.Status.OK.getReasonPhrase());
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            catch (VitamApplicationServerException e) {
                LOGGER.warn("Can't connect to factory: [" + name + "] " + factory.getServiceUrl() + "\n\t" + e.getMessage(), (Throwable)e);
                sub.setDescription(name + SERVICE_IS_UNAVAILABLE).setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage("Sub service is unavailable").setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
                globalStatus = false;
            }
            list.add(sub);
        }
        for (VitamClientFactoryInterface<?> factory : this.clientOptionalFactories) {
            name = StringUtils.getClassName(factory);
            sub = new VitamError(Integer.toString(++test)).setContext(name);
            try {
                client = factory.getClient();
                try {
                    client.checkStatus();
                    sub.setDescription(name + SERVICE_IS_AVAILABLE).setHttpCode(Response.Status.OK.getStatusCode()).setMessage("Optional Sub service is available").setState(Response.Status.OK.getReasonPhrase());
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            catch (VitamApplicationServerException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                LOGGER.warn("Can't connect to Optional factory: [" + name + "] " + factory.getServiceUrl() + "\n\t" + e.getMessage());
                sub.setDescription(name + SERVICE_IS_UNAVAILABLE).setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage("Optional Sub service is unavailable").setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
            }
            list.add(sub);
        }
        for (DatabaseConnection database : this.databaseFactories) {
            name = StringUtils.getClassName((Object)database);
            sub = new VitamError(Integer.toString(++test)).setContext(name);
            if (database.checkConnection()) {
                sub.setDescription(name + SERVICE_IS_AVAILABLE).setHttpCode(Response.Status.OK.getStatusCode()).setMessage("Sub service is available").setState(Response.Status.OK.getReasonPhrase());
            } else {
                LOGGER.warn("Can't connect to database: [" + name + "] " + database.toString());
                sub.setDescription(name + SERVICE_IS_UNAVAILABLE).setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage("Sub service is unavailable").setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
                globalStatus = false;
            }
            list.add(sub);
        }
        VitamError sub2 = new VitamError(Integer.toString(++test)).setContext(status.getContext());
        if (this.applicationStatus.getResourcesStatus()) {
            sub2.setHttpCode(Response.Status.OK.getStatusCode()).setMessage("Internal service is available").setDescription(status.getDescription() + SERVICE_IS_AVAILABLE).setState(Response.Status.OK.getReasonPhrase());
        } else {
            LOGGER.warn(sub2.getContext() + SERVICE_IS_UNAVAILABLE);
            sub2.setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage("Internal service is unavailable").setDescription(status.getDescription() + SERVICE_IS_UNAVAILABLE).setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
        }
        list.add(sub2);
        status.addAllErrors(list);
        if (globalStatus) {
            status.setDescription("All services are available").setHttpCode(Response.Status.OK.getStatusCode()).setMessage("All services are available").setState(Response.Status.OK.getReasonPhrase());
        } else {
            status.setDescription("Some services are unavailable").setHttpCode(Response.Status.SERVICE_UNAVAILABLE.getStatusCode()).setMessage("Some services are unavailable").setState(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase());
        }
        return (ObjectNode)status.toJsonNode();
    }
}

