/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.security.filter;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.security.codec.URLCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationFilterHelper {
    private static final String ARGUMENT_MUST_NOT_BE_NULL = "Argument must not be null";

    private AuthorizationFilterHelper() {
    }

    public static Map<String, String> getAuthorizationHeaders(String httpMethod, String url) {
        ParametersChecker.checkParameter((String)ARGUMENT_MUST_NOT_BE_NULL, (String[])new String[]{httpMethod, url});
        if (!Strings.isNullOrEmpty((String)VitamConfiguration.getSecret())) {
            long currentTime = LocalDateUtil.currentTimeMillis() / 1000L;
            return AuthorizationFilterHelper.getAuthorizationHeaders(httpMethod, url, Long.toString(currentTime), VitamConfiguration.getSecret(), VitamConfiguration.getSecurityDigestType());
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getAuthorizationHeaders(String httpMethod, String url, String timestamp, String secret, DigestType digestType) {
        ParametersChecker.checkParameter((String)ARGUMENT_MUST_NOT_BE_NULL, (Object[])new Object[]{httpMethod, url, timestamp, secret, digestType});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Timestamp", timestamp);
        headers.put("X-Platform-Id", URLCodec.encodeURL(httpMethod, url, timestamp, secret, digestType));
        return headers;
    }
}

