/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.ExportRequestParameters;
import fr.gouv.vitam.common.model.export.ExportType;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;

public class ExportRequest {
    public static final String EXPORT_QUERY_FILE_NAME = "export_query.json";
    @JsonProperty(value="dataObjectVersionToExport")
    private DataObjectVersions dataObjectVersionToExport;
    @JsonProperty(value="exportType")
    private ExportType exportType = ExportType.MinimalArchiveDeliveryRequestReply;
    @JsonProperty(value="exportRequestParameters")
    private ExportRequestParameters exportRequestParameters;
    @JsonProperty(value="exportWithLogBookLFC")
    private boolean exportWithLogBookLFC;
    @JsonProperty(value="exportWithoutObjects")
    private boolean exportWithoutObjects;
    @JsonProperty(value="maxSizeThreshold")
    private Long maxSizeThreshold;
    @JsonProperty(value="dslRequest")
    private JsonNode dslRequest;
    @JsonProperty(value="sedaVersion")
    private String sedaVersion = SupportedSedaVersions.SEDA_2_2.getVersion();
    @JsonProperty(value="useOriginalFilenames")
    private boolean useOriginalFilenames;
    @JsonProperty(value="exportWithTree")
    private boolean exportWithTree;

    public ExportRequest() {
    }

    private ExportRequest(DataObjectVersions dataObjectVersionToExport, JsonNode dslRequest, boolean withLogBookLFC, boolean withoutObjects, Long maxSizeThreshold, String sedaVersion, boolean useOriginalFilenames, boolean exportWithTree, ExportType exportType, ExportRequestParameters exportRequestParameters) {
        this.dataObjectVersionToExport = dataObjectVersionToExport;
        this.dslRequest = dslRequest;
        this.exportWithLogBookLFC = withLogBookLFC;
        this.exportWithoutObjects = withoutObjects;
        this.maxSizeThreshold = maxSizeThreshold;
        this.sedaVersion = sedaVersion;
        this.useOriginalFilenames = useOriginalFilenames;
        this.exportWithTree = exportWithTree;
        this.exportType = exportType;
        this.exportRequestParameters = exportRequestParameters;
    }

    public static ExportRequest from(DipRequest dipRequest) {
        return new ExportRequest(dipRequest.getDataObjectVersionToExport(), dipRequest.getDslRequest(), dipRequest.isExportWithLogBookLFC(), dipRequest.isExportWithoutObjects(), dipRequest.getMaxSizeThreshold(), dipRequest.getSedaVersion() != null ? dipRequest.getSedaVersion() : SupportedSedaVersions.SEDA_2_2.getVersion(), dipRequest.isUseOriginalFilenames(), dipRequest.isExportWithTree(), ExportType.get(dipRequest.getDipExportType()), ExportRequestParameters.from(dipRequest.getDipRequestParameters()));
    }

    public static ExportRequest from(TransferRequest transferRequest) {
        return new ExportRequest(transferRequest.getDataObjectVersionToExport(), transferRequest.getDslRequest(), transferRequest.isTransferWithLogBookLFC(), transferRequest.isTransferWithoutObjects(), transferRequest.getMaxSizeThreshold(), transferRequest.getSedaVersion() != null ? transferRequest.getSedaVersion() : SupportedSedaVersions.SEDA_2_2.getVersion(), false, false, ExportType.ArchiveTransfer, ExportRequestParameters.from(transferRequest.getTransferRequestParameters()));
    }

    public DataObjectVersions getDataObjectVersionToExport() {
        return this.dataObjectVersionToExport;
    }

    public void setDataObjectVersionToExport(DataObjectVersions dataObjectVersionToExport) {
        this.dataObjectVersionToExport = dataObjectVersionToExport;
    }

    public JsonNode getDslRequest() {
        return this.dslRequest;
    }

    public void setDslRequest(JsonNode dslRequest) {
        this.dslRequest = dslRequest;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public void setExportType(ExportType exportType) {
        this.exportType = exportType;
    }

    public ExportRequestParameters getExportRequestParameters() {
        return this.exportRequestParameters;
    }

    public void setExportRequestParameters(ExportRequestParameters exportRequestParameters) {
        this.exportRequestParameters = exportRequestParameters;
    }

    public boolean isExportWithLogBookLFC() {
        return this.exportWithLogBookLFC;
    }

    public void setExportWithLogBookLFC(boolean exportWithLogBookLFC) {
        this.exportWithLogBookLFC = exportWithLogBookLFC;
    }

    public boolean isExportWithoutObjects() {
        return this.exportWithoutObjects;
    }

    public void setExportWithoutObjects(boolean exportWithoutObjects) {
        this.exportWithoutObjects = exportWithoutObjects;
    }

    public Long getMaxSizeThreshold() {
        return this.maxSizeThreshold;
    }

    public void setMaxSizeThreshold(Long maxSizeThreshold) {
        this.maxSizeThreshold = maxSizeThreshold;
    }

    public String getSedaVersion() {
        return this.sedaVersion;
    }

    public void setSedaVersion(String sedaVersion) {
        this.sedaVersion = sedaVersion;
    }

    public boolean isUseOriginalFilenames() {
        return this.useOriginalFilenames;
    }

    public void setUseOriginalFilenames(boolean useOriginalFilenames) {
        this.useOriginalFilenames = useOriginalFilenames;
    }

    public boolean isExportWithTree() {
        return this.exportWithTree;
    }

    public void setExportWithTree(boolean exportWithTree) {
        this.exportWithTree = exportWithTree;
    }
}

