/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import javax.validation.constraints.NotNull;
import org.slf4j.MDC;

public class VitamSession {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VitamSession.class);
    private final VitamThreadFactory.VitamThread owningThread;
    private String requestId = null;
    private String internalRequestId = null;
    private Integer tenantId = null;
    private String contractId = null;
    private String contextId = null;
    private String applicationSessionId = null;
    private String securityProfileIdentifier = null;
    private AccessContractModel contract = null;
    private Object other = null;
    private String personalCertificate = null;

    public VitamSession(VitamThreadFactory.VitamThread owningThread) {
        this.owningThread = owningThread;
    }

    public static VitamSession from(VitamSession origin) {
        VitamSession newSession = new VitamSession(origin.owningThread);
        newSession.requestId = origin.getRequestId();
        newSession.internalRequestId = origin.getInternalRequestId();
        newSession.tenantId = origin.getTenantId();
        newSession.contractId = origin.getContractId();
        newSession.contract = origin.getContract();
        newSession.other = origin.getOther();
        newSession.contextId = origin.getContextId();
        newSession.applicationSessionId = origin.getApplicationSessionId();
        newSession.securityProfileIdentifier = origin.getSecurityProfileIdentifier();
        newSession.personalCertificate = origin.getPersonalCertificate();
        return newSession;
    }

    public Object getOther() {
        return this.other;
    }

    public VitamSession setOther(Object other) {
        this.other = other;
        return this;
    }

    private void checkCallingThread() {
        if (Thread.currentThread() != this.owningThread) {
            throw new IllegalStateException("VitamSession should only be called by the thread that owns it ; here, caller was " + String.valueOf(Thread.currentThread()) + ", and owner was ");
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String newRequestId) {
        this.checkCallingThread();
        String oldRequestId = MDC.get((String)"X-Request-Id");
        if (oldRequestId != this.requestId) {
            LOGGER.warn("Caution : inconsistency detected between content of the VitamSession (requestId:{}) and the Logging MDC (requestId:{})", (Object)oldRequestId, (Object)this.requestId);
        }
        this.requestId = newRequestId;
        MDC.put((String)"X-Request-Id", (String)newRequestId);
    }

    public void setInternalRequestId(String newRequestId) {
        this.internalRequestId = newRequestId;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public Integer getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Integer newTenantId) {
        this.checkCallingThread();
        this.tenantId = newTenantId;
        if (newTenantId != null) {
            MDC.put((String)"X-Tenant-Id", (String)String.valueOf(newTenantId));
        }
    }

    public void setRequestId(GUID guid) {
        this.setRequestId(guid.getId());
    }

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public AccessContractModel getContract() {
        return this.contract;
    }

    public void setContract(AccessContractModel contract) {
        this.contract = contract;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.checkCallingThread();
        this.contextId = contextId;
    }

    public String getSecurityProfileIdentifier() {
        return this.securityProfileIdentifier;
    }

    public void setSecurityProfileIdentifier(String securityProfileIdentifier) {
        this.securityProfileIdentifier = securityProfileIdentifier;
    }

    public String getApplicationSessionId() {
        return this.applicationSessionId;
    }

    public void setApplicationSessionId(String applicationSessionId) {
        this.checkCallingThread();
        this.applicationSessionId = applicationSessionId;
    }

    public String getPersonalCertificate() {
        return this.personalCertificate;
    }

    public void setPersonalCertificate(String personalCertificate) {
        this.personalCertificate = personalCertificate;
    }

    public void mutateFrom(@NotNull VitamSession newSession) {
        if (newSession == null) {
            throw new IllegalArgumentException("VitamSession should not be null");
        }
        this.setRequestId(newSession.getRequestId());
        this.setInternalRequestId(newSession.getInternalRequestId());
        this.setTenantId(newSession.getTenantId());
        this.setContractId(newSession.getContractId());
        this.setContract(newSession.getContract());
        this.setOther(newSession.getOther());
        this.setContextId(newSession.getContextId());
        this.setApplicationSessionId(newSession.getApplicationSessionId());
        this.setSecurityProfileIdentifier(newSession.getSecurityProfileIdentifier());
        this.setPersonalCertificate(newSession.getPersonalCertificate());
    }

    public void erase() {
        this.mutateFrom(new VitamSession(this.owningThread));
    }

    public void checkValidRequestId() {
        ParametersChecker.checkParameter((String)"Request-Id should be defined !", (String[])new String[]{this.requestId});
    }

    public void initIfAbsent(Integer tenantId) {
        if (null == VitamThreadUtils.getVitamSession().getTenantId()) {
            VitamThreadUtils.getVitamSession().setTenantId(tenantId);
        }
        if (Strings.isNullOrEmpty((String)VitamThreadUtils.getVitamSession().getRequestId())) {
            VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamThreadUtils.getVitamSession().getTenantId()).getId());
        }
    }

    public String toString() {
        return Integer.toHexString(this.hashCode()) + "{requestId='" + this.requestId + "', tenantId:'" + this.tenantId + "', contractId:'" + this.contractId + "', contextId:'" + this.contextId + "', applicationSessionId:'" + this.applicationSessionId + "', personalCertificate:'" + this.personalCertificate + "'}";
    }
}

