/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.iterables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;

public class SpliteratorIterator<T>
implements Iterator<T> {
    private final Spliterator<T> spliterator;
    private T nextEntry;

    public SpliteratorIterator(Spliterator<T> spliterator) {
        this.spliterator = spliterator;
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry != null) {
            return true;
        }
        return this.spliterator.tryAdvance(t -> {
            this.nextEntry = t;
        });
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextEntry;
        this.nextEntry = null;
        return result;
    }
}

