/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.graph;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class Graph {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(Graph.class);
    private final Vertex[] vertices;
    private int size;
    private final int maxSize;
    private final Deque<Vertex> stack;
    private int count = 0;
    private final BidiMap<Integer, String> indexMapping;
    private final Set<String> roots = new HashSet<String>();
    private Map<Integer, Set<String>> longestsPath;

    public Graph(JsonNode jsonGraph) {
        this.indexMapping = new DualHashBidiMap();
        this.maxSize = jsonGraph.size();
        LOGGER.debug("maxSize:" + this.maxSize);
        this.vertices = new Vertex[this.maxSize];
        this.stack = new ArrayDeque<Vertex>(this.maxSize);
        for (int i = 0; i < this.maxSize; ++i) {
            this.addVertex(i + 1);
        }
        Iterator levelIterator = jsonGraph.fields();
        while (levelIterator.hasNext()) {
            Map.Entry cycle = (Map.Entry)levelIterator.next();
            String idChild = (String)cycle.getKey();
            JsonNode up = (JsonNode)cycle.getValue();
            this.addMapIdToIndex(idChild);
            if (up != null && up.size() > 0) {
                JsonNode arrNode = up.get("_up");
                for (JsonNode idParent : arrNode) {
                    this.addEdge(this.getIndex(idParent.textValue()), this.getIndex(idChild));
                    LOGGER.debug("source:" + String.valueOf(idParent));
                    LOGGER.debug("destin:" + idChild);
                }
                continue;
            }
            this.roots.add(idChild);
        }
    }

    private int addMapIdToIndex(String idXml) {
        BidiMap xmlIdToIndex;
        if (this.indexMapping != null && (xmlIdToIndex = this.indexMapping.inverseBidiMap()).get((Object)idXml) == null) {
            ++this.count;
            this.indexMapping.put((Object)this.count, (Object)idXml);
        }
        return this.count;
    }

    private void addVertex(int data) {
        this.vertices[this.size++] = new Vertex(data);
    }

    private void addEdge(int source, int destination) {
        this.vertices[source - 1].adj = new Neighbour(destination - 1, this.vertices[source - 1].adj);
    }

    private Map<Integer, Integer> findLongestsPath(int source) {
        this.applyTopologicalSort();
        HashMap<Integer, Integer> longestsPathMap = new HashMap<Integer, Integer>();
        this.vertices[source - 1].cost = 0;
        while (!this.stack.isEmpty()) {
            Vertex u = this.stack.pop();
            if (u.cost == Integer.MIN_VALUE) continue;
            Neighbour temp = u.adj;
            while (temp != null) {
                Vertex v = this.vertices[temp.index];
                if (v.cost < temp.weight + u.cost) {
                    v.cost = temp.weight + u.cost;
                }
                temp = temp.next;
            }
        }
        for (int i = 0; i < this.maxSize; ++i) {
            longestsPathMap.put(i + 1, this.vertices[i].cost);
        }
        LOGGER.debug("Longest path from " + String.valueOf(this.longestsPath));
        return longestsPathMap;
    }

    private Map<Integer, Integer> findAllLongestsPath(Set<String> roots) {
        HashMap<Integer, Integer> allLongestsPath = new HashMap<Integer, Integer>();
        for (String rootXmlId : roots) {
            Map<Integer, Integer> longestsPathMap = this.findLongestsPath(this.getIndex(rootXmlId));
            if (allLongestsPath.isEmpty()) {
                allLongestsPath.putAll(longestsPathMap);
                continue;
            }
            for (Map.Entry<Integer, Integer> e : longestsPathMap.entrySet()) {
                Integer key = e.getKey();
                Integer value = e.getValue();
                LOGGER.debug("key" + key + "------------ value:" + (String)this.indexMapping.get((Object)key));
                if (!allLongestsPath.containsKey(key) || (Integer)allLongestsPath.get(key) >= value) continue;
                allLongestsPath.put(key, value);
            }
        }
        return allLongestsPath;
    }

    public Map<Integer, Set<String>> getGraphWithLongestPaths() {
        this.longestsPath = new HashMap<Integer, Set<String>>();
        Map<Integer, Integer> paths = this.findAllLongestsPath(this.roots);
        if (paths != null) {
            for (Map.Entry<Integer, Integer> e : paths.entrySet()) {
                Integer unitId = e.getKey();
                Integer level = e.getValue();
                if (this.longestsPath.containsKey(level) && this.longestsPath.get(level) != null) {
                    this.longestsPath.get(level).add((String)this.indexMapping.get((Object)unitId));
                    continue;
                }
                HashSet<String> units = new HashSet<String>();
                units.add((String)this.indexMapping.get((Object)unitId));
                this.longestsPath.put(level, units);
            }
        }
        paths = null;
        return this.longestsPath;
    }

    private void applyTopologicalSort() {
        for (int i = 0; i < this.maxSize; ++i) {
            if (this.vertices[i].state == State.VISITED) continue;
            this.depthFirstSearch(this.vertices[i]);
        }
    }

    private void depthFirstSearch(Vertex u) {
        Neighbour temp = u.adj;
        u.state = State.VISITED;
        while (temp != null) {
            Vertex v = this.vertices[temp.index];
            if (v.state == State.NEW) {
                this.depthFirstSearch(v);
            }
            temp = temp.next;
        }
        this.stack.push(u);
    }

    private int getIndex(String id) {
        int key = 0;
        if (this.indexMapping != null) {
            if (this.indexMapping.containsValue((Object)id)) {
                BidiMap xmlIdToIndex = this.indexMapping.inverseBidiMap();
                key = (Integer)xmlIdToIndex.get((Object)id);
            } else {
                key = this.addMapIdToIndex(id);
            }
            return key;
        }
        return key;
    }

    public class Vertex {
        int data;
        Neighbour adj;
        int cost = 0;
        State state = State.NEW;

        public Vertex(int data) {
            this.data = data;
        }
    }

    public class Neighbour {
        int index;
        Neighbour next;
        int weight = 1;

        Neighbour(int index, Neighbour next) {
            this.index = index;
            this.next = next;
        }
    }

    public static enum State {
        NEW,
        VISITED;

    }
}

