/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.cache.VitamCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class AbstractVitamCache<T, V>
implements VitamCache<T, V> {
    LoadingCache<T, V> cache;

    public AbstractVitamCache() {
        this(true, Math.max(Runtime.getRuntime().availableProcessors(), 32));
    }

    public AbstractVitamCache(boolean enableStats, int concurrencyLevel) {
        if (concurrencyLevel <= 0) {
            concurrencyLevel = Math.max(Runtime.getRuntime().availableProcessors(), 32);
        }
        this.buildCache(enableStats, concurrencyLevel);
    }

    private void buildCache(boolean enableStats, int concurrencyLevel) {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)VitamConfiguration.getMaxCacheEntries());
        if (enableStats) {
            builder.recordStats();
        }
        this.cache = builder.softValues().concurrencyLevel(concurrencyLevel).expireAfterAccess((long)VitamConfiguration.getExpireCacheEntriesDelay(), TimeUnit.SECONDS).build(new CacheLoader<T, V>(){

            public V load(T key) {
                return AbstractVitamCache.this.loadByKey(key);
            }

            public Map<T, V> loadAll(Iterable<? extends T> keys) {
                return AbstractVitamCache.this.loadByKeys(keys);
            }
        });
    }

    protected abstract Map<T, V> loadByKeys(Iterable<? extends T> var1);

    protected abstract V loadByKey(T var1);

    @Override
    public LoadingCache<T, V> getCache() {
        return this.cache;
    }
}

