/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server.elasticsearch;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import fr.gouv.vitam.common.model.FacetBucket;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.common.model.SingleValueFacet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ElasticsearchFacetResultHelper {
    public static FacetResult transformFromEsAggregation(String name, Aggregate aggregation) {
        Aggregate.Kind aggType = aggregation._kind();
        return switch (aggType) {
            case Aggregate.Kind.DateRange -> FacetResult.createBucketFacetResult((String)name, ElasticsearchFacetResultHelper.extractBucketDateRangeAggregation(aggregation));
            case Aggregate.Kind.Sterms -> FacetResult.createBucketFacetResult((String)name, ElasticsearchFacetResultHelper.extractBucketStringTermsAggregation(aggregation));
            case Aggregate.Kind.Sum -> FacetResult.createSingleValueFacetResult((String)name, (SingleValueFacet)ElasticsearchFacetResultHelper.extractSumAggregation(aggregation));
            case Aggregate.Kind.Cardinality -> FacetResult.createSingleValueFacetResult((String)name, (SingleValueFacet)ElasticsearchFacetResultHelper.extractCardinalityAggregation(aggregation));
            case Aggregate.Kind.ValueCount -> FacetResult.createSingleValueFacetResult((String)name, (SingleValueFacet)ElasticsearchFacetResultHelper.extractValueCountAggregation(aggregation));
            case Aggregate.Kind.Lterms -> FacetResult.createBucketFacetResult((String)name, ElasticsearchFacetResultHelper.extractBucketLongTermsAggregation(aggregation));
            case Aggregate.Kind.Filters -> FacetResult.createBucketFacetResult((String)name, ElasticsearchFacetResultHelper.extractBucketFiltersAggregation(aggregation));
            case Aggregate.Kind.Nested -> ElasticsearchFacetResultHelper.extractFacetResultNestedAggregation(aggregation);
            default -> throw new IllegalStateException("Unexpected aggregate type " + String.valueOf(aggType));
        };
    }

    private static List<FacetBucket> extractBucketFiltersAggregation(Aggregate aggregation) {
        Map buckets = aggregation.filters().buckets().keyed();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach((key, bucket) -> facetBuckets.add(new FacetBucket(key, bucket.docCount())));
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketStringTermsAggregation(Aggregate aggregation) {
        List buckets = aggregation.sterms().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.key().stringValue(), bucket.docCount())));
        return facetBuckets;
    }

    private static SingleValueFacet extractSumAggregation(Aggregate aggregation) {
        double sumValue = aggregation.sum().value();
        return new SingleValueFacet(Double.valueOf(sumValue));
    }

    private static SingleValueFacet extractValueCountAggregation(Aggregate aggregation) {
        double countValue = aggregation.valueCount().value();
        return new SingleValueFacet(Double.valueOf(countValue));
    }

    private static SingleValueFacet extractCardinalityAggregation(Aggregate aggregation) {
        double value = aggregation.cardinality().value();
        return new SingleValueFacet(Double.valueOf(value));
    }

    private static List<FacetBucket> extractBucketLongTermsAggregation(Aggregate aggregation) {
        List buckets = aggregation.lterms().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> {
            String value = bucket.keyAsString() != null ? bucket.keyAsString() : Long.toString(bucket.key());
            facetBuckets.add(new FacetBucket(value, bucket.docCount()));
        });
        return facetBuckets;
    }

    private static List<FacetBucket> extractBucketNestedAggregation(Aggregate aggregation) {
        Map aggregations = aggregation.nested().aggregations();
        if (aggregations.isEmpty()) {
            return Collections.emptyList();
        }
        String key = (String)aggregations.keySet().iterator().next();
        return ElasticsearchFacetResultHelper.transformFromEsAggregation(key, (Aggregate)aggregations.get(key)).getBuckets();
    }

    private static FacetResult extractFacetResultNestedAggregation(Aggregate aggregation) {
        Map aggregations = aggregation.nested().aggregations();
        if (aggregations.isEmpty()) {
            return null;
        }
        String key = (String)aggregations.keySet().iterator().next();
        return ElasticsearchFacetResultHelper.transformFromEsAggregation(key, (Aggregate)aggregations.get(key));
    }

    private static List<FacetBucket> extractBucketDateRangeAggregation(Aggregate aggregation) {
        List buckets = aggregation.dateRange().buckets().array();
        ArrayList<FacetBucket> facetBuckets = new ArrayList<FacetBucket>();
        buckets.forEach(bucket -> facetBuckets.add(new FacetBucket(bucket.key(), bucket.docCount())));
        return facetBuckets;
    }
}

