/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.DatabaseCursor;
import fr.gouv.vitam.common.model.FacetResult;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class DbRequestResult
implements VitamAutoCloseable {
    private long offset;
    private long limit;
    private long count = 0L;
    private long total = 0L;
    private final Map<String, List<String>> diffs = new HashMap<String, List<String>>();
    private MongoCursor<VitamDocument<?>> cursor;
    private List<VitamDocument<?>> documents;
    protected List<FacetResult> facetResult;

    public long getCount() {
        return this.count;
    }

    public DbRequestResult setCount(long count) {
        this.count = count;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public DbRequestResult setTotal(long total) {
        this.total = total;
        return this;
    }

    public Map<String, List<String>> getDiffs() {
        return new HashMap<String, List<String>>(this.diffs);
    }

    public long getOffset() {
        return this.offset;
    }

    public DbRequestResult setOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public DbRequestResult setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public DbRequestResult setDiffs(Map<String, List<String>> diffs) {
        this.diffs.putAll(diffs);
        return this;
    }

    public boolean hasResult() {
        if (this.cursor != null) {
            return this.cursor.hasNext();
        }
        return this.count > 0L;
    }

    public DbRequestResult setCursor(MongoCursor<VitamDocument<?>> cursor) {
        this.cursor = cursor;
        return this;
    }

    public <T extends VitamDocument<?>> List<T> getDocuments(Class<T> cls) {
        if (this.documents == null) {
            this.documents = new ArrayList();
            if (this.cursor != null) {
                while (this.cursor.hasNext()) {
                    VitamDocument document = (VitamDocument)((Object)this.cursor.next());
                    this.filterFinalResponse(document);
                    this.documents.add(document);
                }
                this.cursor.close();
                this.cursor = null;
            }
        }
        this.count = this.documents.size();
        return new ArrayList(this.documents);
    }

    public <T extends VitamDocument<T>, V> List<V> getDocuments(Class<T> cls, Class<V> clsFromJson) throws InvalidParseOperationException {
        if (this.documents == null) {
            this.documents = new ArrayList();
            ArrayList<V> newList = new ArrayList<V>();
            if (this.cursor != null) {
                while (this.cursor.hasNext()) {
                    VitamDocument doc = (VitamDocument)((Object)this.cursor.next());
                    this.documents.add(doc);
                    this.filterFinalResponse(doc);
                    newList.add(BsonHelper.fromDocumentToObject((Document)doc, clsFromJson));
                }
                this.cursor.close();
                this.cursor = null;
            }
            this.count = this.documents.size();
            return newList;
        }
        ArrayList<V> newList = new ArrayList<V>();
        for (VitamDocument<?> doc : this.documents) {
            newList.add(BsonHelper.fromDocumentToObject(doc, clsFromJson));
        }
        return newList;
    }

    public <T extends VitamDocument<T>> RequestResponseOK<T> getRequestResponseOK(JsonNode query, Class<T> cls) {
        RequestResponseOK response = new RequestResponseOK(query);
        DatabaseCursor currentCursor = this.getDatabaseCursor();
        response.addAllResults(this.getDocuments(cls)).setHits(currentCursor);
        response.addAllFacetResults(this.getFacet());
        this.close();
        return response;
    }

    public final void filterFinalResponse(VitamDocument<?> document) {
        block7: for (ParserTokens.PROJECTIONARGS projection : ParserTokens.PROJECTIONARGS.values()) {
            switch (projection) {
                case ID: {
                    this.replace(document, "_id", VitamFieldsHelper.id());
                    continue block7;
                }
                case TENANT: {
                    this.replace(document, "_tenant", VitamFieldsHelper.tenant());
                    continue block7;
                }
                case VERSION: {
                    this.replace(document, "_v", VitamFieldsHelper.version());
                    continue block7;
                }
                case SEDAVERSION: {
                    this.replace(document, "_sedaVersion", VitamFieldsHelper.sedaVersion());
                    continue block7;
                }
                case IMPLEMENTATIONVERSION: {
                    this.replace(document, "_implementationVersion", VitamFieldsHelper.implementationVersion());
                    continue block7;
                }
            }
        }
    }

    private final void replace(VitamDocument<?> document, String originalFieldName, String targetFieldName) {
        Object value = document.remove(originalFieldName);
        if (value != null) {
            document.append(targetFieldName, value);
        }
    }

    public <T extends VitamDocument<T>, V> RequestResponseOK<V> getRequestResponseOK(JsonNode query, Class<T> cls, Class<V> clsFromJson) throws InvalidParseOperationException {
        RequestResponseOK response = new RequestResponseOK(query);
        DatabaseCursor currentCursor = this.getDatabaseCursor();
        response.addAllResults(this.getDocuments(cls, clsFromJson)).setHits(currentCursor);
        response.addAllFacetResults(this.getFacet());
        this.close();
        return response;
    }

    public DatabaseCursor getDatabaseCursor() {
        return new DatabaseCursor(this.total, this.offset, this.limit, this.count);
    }

    public List<FacetResult> getFacet() {
        if (this.facetResult == null) {
            this.facetResult = new ArrayList<FacetResult>();
        }
        return this.facetResult;
    }

    public void addFacetResult(FacetResult facetResult) {
        this.getFacet().add(facetResult);
    }

    public MongoCursor<VitamDocument<?>> getCursor() {
        return this.cursor;
    }

    public void close() {
        this.diffs.clear();
        if (this.documents != null) {
            this.documents.clear();
            this.documents = null;
        }
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }
}

