/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.server;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoWriteException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.NopQuery;
import fr.gouv.vitam.common.database.builder.request.single.RequestSingle;
import fr.gouv.vitam.common.database.collections.VitamCollection;
import fr.gouv.vitam.common.database.parser.request.single.RequestParserSingle;
import fr.gouv.vitam.common.database.server.FakeVitamDocument;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.database.translators.mongodb.SelectToMongodb;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bson.conversions.Bson;

public class DbRequestHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DbRequestHelper.class);
    public static final String CONSISTENCY_ERROR_THE_DOCUMENT_GUID_S_IN_ES_IS_NOT_IN_MONGO_DB_ANYMORE_TENANT_S_REQUEST_ID_S = "[Consistency Error] : The document guid=%s in ES is not in MongoDB anymore, tenant : %s, requestId : %s";

    private DbRequestHelper() {
    }

    public static boolean isDuplicateKeyError(Exception e) {
        if (e instanceof MongoBulkWriteException || e instanceof MongoWriteException) {
            return DbRequestHelper.isDuplicateKeyException(e);
        }
        if (e instanceof DatabaseException && (e.getCause() instanceof MongoBulkWriteException || e.getCause() instanceof MongoWriteException)) {
            return DbRequestHelper.isDuplicateKeyException(e.getCause());
        }
        Throwable d = e.getCause();
        if (d instanceof DatabaseException && (d.getCause() instanceof MongoBulkWriteException || d.getCause() instanceof MongoWriteException)) {
            return DbRequestHelper.isDuplicateKeyException(e.getCause());
        }
        return false;
    }

    private static boolean isDuplicateKeyException(Throwable exception) {
        if (exception instanceof MongoWriteException) {
            MongoWriteException mongoException = (MongoWriteException)exception;
            ErrorCategory category = mongoException.getError().getCategory();
            return ErrorCategory.DUPLICATE_KEY.equals((Object)category);
        }
        if (exception instanceof MongoBulkWriteException) {
            MongoBulkWriteException mongoException = (MongoBulkWriteException)exception;
            return mongoException.getWriteErrors().stream().allMatch(o -> ErrorCategory.DUPLICATE_KEY.equals((Object)o.getCategory()));
        }
        return false;
    }

    public static <T extends VitamDocument<?>> MongoCursor<T> selectMongoDbExecuteThroughFakeMongoCursor(VitamCollection<T> collection, RequestParserSingle parser, List<String> list, List<Double> scores) throws InvalidParseOperationException, VitamDBException {
        ServerAddress serverAddress;
        SelectToMongodb selectToMongoDb = new SelectToMongodb(parser);
        Bson projection = selectToMongoDb.getFinalProjection();
        boolean isIdIncluded = selectToMongoDb.idWasInProjection();
        Bson initialCondition = Filters.in((String)"_id", list);
        if (!(((RequestSingle)parser.getRequest()).getQuery() instanceof NopQuery)) {
            try {
                initialCondition = Filters.and((Bson[])new Bson[]{initialCondition, selectToMongoDb.getNthQueries(0)});
            }
            catch (IllegalAccessError | IllegalAccessException e2) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e2);
            }
        }
        FindIterable find = collection.getCollection().find(initialCondition);
        if (projection != null) {
            find = find.projection(projection);
        }
        int nb = list.size();
        List firstList = IntStream.range(0, nb).mapToObj(e -> new FakeVitamDocument()).collect(Collectors.toList());
        int nbFinal = 0;
        try (MongoCursor cursor = find.iterator();){
            serverAddress = cursor.getServerAddress();
            while (cursor.hasNext()) {
                VitamDocument item = (VitamDocument)((Object)cursor.next());
                int rank = list.indexOf(item.getString("_id"));
                if (!isIdIncluded) {
                    item.remove("_id");
                }
                firstList.set(rank, item);
                ++nbFinal;
            }
        }
        ArrayList<VitamDocument<Object>> finalList = new ArrayList<VitamDocument<Object>>(nbFinal);
        if (VitamConfiguration.isExportScore() && scores != null && collection.isUseScore() && selectToMongoDb.isScoreIncluded()) {
            for (int i = 0; i < nb; ++i) {
                VitamDocument vitamDocument = (VitamDocument)((Object)firstList.get(i));
                if (vitamDocument instanceof FakeVitamDocument) continue;
                Double score = 1.0;
                try {
                    score = scores.get(i);
                    if (score.isNaN()) {
                        score = 1.0;
                    }
                }
                catch (IndexOutOfBoundsException e3) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e3);
                }
                vitamDocument.append("_score", score);
                finalList.add(vitamDocument);
            }
        } else {
            finalList.addAll(firstList);
        }
        final ArrayList<VitamDocument> finalListWithoutFakeDocs = new ArrayList<VitamDocument>(nbFinal);
        ArrayList<String> listDesynchronizedResults = new ArrayList<String>();
        for (int i = 0; i < finalList.size(); ++i) {
            if (!((VitamDocument)((Object)finalList.get(i))).isEmpty()) {
                finalListWithoutFakeDocs.add((VitamDocument)((Object)finalList.get(i)));
                continue;
            }
            listDesynchronizedResults.add(list.get(i));
        }
        listDesynchronizedResults.forEach(x -> {
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
            LOGGER.error(String.format(CONSISTENCY_ERROR_THE_DOCUMENT_GUID_S_IN_ES_IS_NOT_IN_MONGO_DB_ANYMORE_TENANT_S_REQUEST_ID_S, x, ParameterHelper.getTenantParameter(), VitamThreadUtils.getVitamSession().getRequestId()));
        });
        if (!listDesynchronizedResults.isEmpty()) {
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "DbRequest"})).inc();
            throw new VitamDBException("[Consistency ERROR] : An internal data consistency error has been detected !");
        }
        firstList.clear();
        return new MongoCursor<T>(){
            int rank = 0;
            final int max = finalListWithoutFakeDocs.size();
            final ServerAddress finalServerAddress = serverAddress;
            final List<T> list = finalListWithoutFakeDocs;

            public void close() {
            }

            public boolean hasNext() {
                return this.rank < this.max;
            }

            public T next() {
                if (this.rank >= this.max) {
                    throw new NoSuchElementException();
                }
                VitamDocument doc = (VitamDocument)((Object)this.list.get(this.rank));
                ++this.rank;
                return (Object)doc;
            }

            public int available() {
                return 0;
            }

            public T tryNext() {
                if (this.rank >= this.max) {
                    return null;
                }
                VitamDocument doc = (VitamDocument)((Object)this.list.get(this.rank));
                ++this.rank;
                return (Object)doc;
            }

            public ServerCursor getServerCursor() {
                return null;
            }

            public ServerAddress getServerAddress() {
                return this.finalServerAddress;
            }
        };
    }
}

