/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.database.parser.request.multiple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.configuration.GlobalDatas;
import fr.gouv.vitam.common.database.builder.request.multiple.InsertMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameAdapter;
import fr.gouv.vitam.common.database.parser.request.adapter.VarNameInsertAdapter;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;

public class InsertParserMultiple
extends RequestParserMultiple {
    VarNameInsertAdapter insertAdapter;

    public InsertParserMultiple() {
        this.insertAdapter = new VarNameInsertAdapter(this.adapter);
    }

    public InsertParserMultiple(VarNameAdapter adapter) {
        super(adapter);
        this.insertAdapter = new VarNameInsertAdapter(adapter);
    }

    @Override
    protected RequestMultiple getNewRequest() {
        return new InsertMultiQuery();
    }

    @Override
    public void parse(JsonNode request) throws InvalidParseOperationException {
        this.parseJson(request);
        this.internalParseInsert();
    }

    private void internalParseInsert() throws InvalidParseOperationException {
        this.dataParse(this.rootNode.get(BuilderToken.GLOBAL.DATA.exactToken()));
        ObjectNode node = this.getRequest().getData();
        int nodeDepth = GlobalDatasParser.getJsonNodedepth((JsonNode)node);
        if (nodeDepth >= 100) {
            throw new InvalidParseOperationException("Node depth exception, value: " + nodeDepth);
        }
    }

    protected void dataParse(JsonNode rootNode) throws InvalidParseOperationException {
        if (rootNode == null) {
            throw new InvalidParseOperationException("Parse in error for Insert: empty data");
        }
        GlobalDatas.sanityValueCheck((String)rootNode.toString());
        JsonNode newRootNode = this.insertAdapter.getFixedVarNameJsonNode(rootNode);
        try {
            ((InsertMultiQuery)this.request).setData(newRootNode);
        }
        catch (Exception e) {
            throw new InvalidParseOperationException("Parse in error for Insert: " + String.valueOf(rootNode), (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return ((RequestMultiple)this.request).toString() + "\n\tLastLevel: " + this.lastDepth;
    }

    @Override
    public InsertMultiQuery getRequest() {
        return (InsertMultiQuery)this.request;
    }
}

