/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.Dsl;
import fr.gouv.vitam.common.dsl.schema.DslScannerFilter;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Parameter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class DslDynamicFeature
implements DynamicFeature {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DslDynamicFeature.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Class<?>[] parametersClass = resourceInfo.getResourceMethod().getParameterTypes();
        for (int i = 0; i < parametersClass.length; ++i) {
            Parameter[] parameters;
            Parameter parameter;
            Class<JsonNode> parameterClass = parametersClass[i];
            if (!parameterClass.isAssignableFrom(JsonNode.class) || (parameter = (parameters = resourceInfo.getResourceMethod().getParameters())[i]) == null) continue;
            Dsl dslAnnotation = parameter.getAnnotation(Dsl.class);
            try {
                if (dslAnnotation == null) continue;
                context.register((Object)new DslScannerFilter(dslAnnotation.value()));
                continue;
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                throw new IllegalStateException("Can not initialize DslScannerFilter");
            }
        }
    }
}

