/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.collect.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.collect.common.dto.BulkAtomicUpdateResult;
import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.collect.external.client.CollectExternalClient;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalClientException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalClientInvalidRequestException;
import fr.gouv.vitam.collect.external.external.exception.CollectExternalClientNotFoundException;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.client.VitamRequestBuilder;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.external.client.DefaultClient;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.elimination.DeletionRequestBody;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class CollectExternalClientRest
extends DefaultClient
implements CollectExternalClient {
    private static final String TRANSACTION_PATH = "/transactions";
    private static final String PROJECT_PATH = "/projects";
    private static final String UNITS_PATH = "/units";
    private static final String UNITS_METADATA_CSV_PATH = "/units/metadata/csv";
    private static final String UNITS_METADATA_JSONL_PATH = "/units/metadata/jsonl";
    private static final String OBJECTS_PATH = "/objects";
    private static final String BINARY_PATH = "/binary";
    private static final String UNITS_WITH_INHERITED_RULES = "/unitsWithInheritedRules";
    private static final String BLANK_DSL = "select DSL is blank";
    public static final String UNITS_BULK = "/units/bulk";
    private static final String MISSING_REQUEST = "Missing request";

    public CollectExternalClientRest(VitamClientFactoryInterface<?> factory) {
        super(factory);
    }

    @Override
    public RequestResponse<JsonNode> initProject(VitamContext vitamContext, ProjectDto projectDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath(PROJECT_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withBody((Object)projectDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> updateProject(VitamContext vitamContext, ProjectDto projectDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(PROJECT_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withBody((Object)projectDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getProjectById(VitamContext vitamContext, String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/projects/" + projectId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getTransactionById(VitamContext vitamContext, String transactionId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getTransactionByProjectId(VitamContext vitamContext, String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/projects/" + projectId + TRANSACTION_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> deleteProjectById(VitamContext vitamContext, String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/projects/" + projectId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> deleteTransactionById(VitamContext vitamContext, String transactionId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.delete().withPath("/transactions/" + transactionId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getProjects(VitamContext vitamContext) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath(PROJECT_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getUnitById(VitamContext vitamContext, String unitId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/" + unitId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getUnitsByTransaction(VitamContext vitamContext, String transactionId, JsonNode query) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId + UNITS_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJson().withBody((Object)query);
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> getObjectById(VitamContext vitamContext, String gotId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/objects/" + gotId).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> initTransaction(VitamContext vitamContext, TransactionDto transactionDto, String projectId) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/projects/" + projectId + TRANSACTION_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withBody((Object)transactionDto).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> uploadArchiveUnit(VitamContext vitamContext, JsonNode unitJsonNode, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + UNITS_PATH).withHeaders(vitamContext.getHeaders()).withBody((Object)unitJsonNode).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> addObjectGroup(VitamContext vitamContext, String unitId, Integer version, JsonNode objectJsonNode, String usage) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/units/" + unitId + "/objects/" + usage + "/" + version).withHeaders(vitamContext.getHeaders()).withBody((Object)objectJsonNode).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public Response addBinary(VitamContext vitamContext, String unitId, Integer version, InputStream inputStreamUploaded, String usage) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/units/" + unitId + "/objects/" + usage + "/" + version + BINARY_PATH).withHeaders(vitamContext.getHeaders()).withBody((Object)inputStreamUploaded).withOctetContentType());){
            this.check(response);
            Response response2 = response;
            return response2;
        }
    }

    public RequestResponse<JsonNode> closeTransaction(VitamContext vitamContext, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/close").withHeaders(vitamContext.getHeaders()).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> ingest(VitamContext vitamContext, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/send").withHeaders(vitamContext.getHeaders()).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> abortTransaction(VitamContext vitamContext, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/abort").withHeaders(vitamContext.getHeaders()).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    public RequestResponse<JsonNode> reopenTransaction(VitamContext vitamContext, String transactionId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + "/reopen").withHeaders(vitamContext.getHeaders()).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> uploadZipToTransaction(VitamContext vitamContext, String transactionId, InputStream inputStreamUploaded, @Nullable String encoding, @Nullable String attachementId) throws VitamClientException {
        return this.callUploadZipToTransaction(vitamContext, transactionId, inputStreamUploaded, encoding, attachementId);
    }

    private RequestResponse<JsonNode> callUploadZipToTransaction(VitamContext vitamContext, String transactionId, InputStream inputStreamUploaded, @Nullable String encoding, @Nullable String attachementId) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/upload").withHeaders(vitamContext.getHeaders()).withOptionalHeader("X-Encoding", (Object)encoding).withOptionalHeader("X-Attachement-Id", (Object)attachementId).withBody((Object)inputStreamUploaded).withContentType(CommonMediaType.ZIP_TYPE).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<String> uploadZipToProject(VitamContext vitamContext, String projectId, InputStream inputStreamUploaded) throws VitamClientException {
        return this.uploadZipToProject(vitamContext, projectId, inputStreamUploaded, null);
    }

    @Override
    public RequestResponse<String> uploadZipToProject(VitamContext vitamContext, String projectId, InputStream inputStreamUploaded, @Nullable String encoding) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.post().withPath("/projects/" + projectId + "/upload").withHeaders(vitamContext.getHeaders()).withOptionalHeader("X-Encoding", (Object)encoding).withBody((Object)inputStreamUploaded).withContentType(CommonMediaType.ZIP_TYPE).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, String.class);
            return requestResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getObjectStreamByUnitId(VitamContext vitamContext, String unitId, String usage, int version) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/units/" + unitId + "/objects/" + usage + "/" + version + BINARY_PATH).withHeaders(vitamContext.getHeaders()).withJsonContentType().withOctetAccept();
        Response response = null;
        try {
            response = this.make(request);
            this.check(response);
            Response response2 = response;
            return response2;
        }
        finally {
            if (response != null && Response.Status.Family.SUCCESSFUL != response.getStatusInfo().getFamily()) {
                response.close();
            }
        }
    }

    public RequestResponse<JsonNode> searchProject(VitamContext vitamContext, CriteriaProjectDto criteria) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.get().withPath(PROJECT_PATH).withHeaders(vitamContext.getHeaders()).withBody((Object)criteria).withJson());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> updateUnitsWithCsvMetadata(VitamContext vitamContext, String transactionId, InputStream metadataCsvInputStream) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + UNITS_METADATA_CSV_PATH).withHeaders(vitamContext.getHeaders()).withBody((Object)metadataCsvInputStream).withContentType(CommonMediaType.TEXT_CSV_MEDIATYPE).withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> updateUnitsWithJsonlMetadata(VitamContext vitamContext, String transactionId, InputStream metadataJsonlInputStream) throws VitamClientException {
        try (Response response = this.make(VitamRequestBuilder.put().withPath("/transactions/" + transactionId + UNITS_METADATA_JSONL_PATH).withHeaders(vitamContext.getHeaders()).withBody((Object)metadataJsonlInputStream).withOctetContentType().withJsonAccept());){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    private void check(Response response) throws VitamClientException {
        if (Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().toEnum().getFamily())) {
            return;
        }
        String template = "Error with the response, get status: '%d' and reason '%s'.";
        String defaultReasonPhrase = Response.Status.fromStatusCode((int)response.getStatus()).getReasonPhrase();
        Response.ResponseBuilder responseBuilder = this.responseBuilderFrom(response);
        String message = String.format("Error with the response, get status: '%d' and reason '%s'.", response.getStatus(), defaultReasonPhrase);
        try (Response clonedResponse = responseBuilder.build();){
            if (clonedResponse.hasEntity()) {
                message = (String)clonedResponse.readEntity(String.class);
            }
        }
        try {
            clonedResponse = responseBuilder.build();
            try {
                VitamError vitamError = RequestResponse.parseVitamError((Response)clonedResponse);
                if (StringUtils.isNotBlank((CharSequence)vitamError.getDescription())) {
                    message = vitamError.getDescription();
                } else if (StringUtils.isNotBlank((CharSequence)vitamError.getMessage())) {
                    message = vitamError.getMessage();
                }
                if (response.getStatusInfo().getStatusCode() == Response.Status.BAD_REQUEST.getStatusCode()) {
                    throw new CollectExternalClientInvalidRequestException(message);
                }
                if (response.getStatusInfo().getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                    throw new CollectExternalClientNotFoundException(message);
                }
                throw new CollectExternalClientException(message);
            }
            catch (Throwable throwable) {
                if (clonedResponse != null) {
                    try {
                        clonedResponse.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (InvalidParseOperationException e) {
            throw new VitamClientException(message);
        }
    }

    private Response.ResponseBuilder responseBuilderFrom(Response response) {
        Response.ResponseBuilder responseBuilder = Response.status((int)response.getStatus());
        for (String headerName : response.getHeaders().keySet()) {
            responseBuilder.header(headerName, (Object)response.getHeaderString(headerName));
        }
        for (NewCookie cookie : response.getCookies().values()) {
            responseBuilder.cookie(new NewCookie[]{cookie});
        }
        if (response.hasEntity()) {
            responseBuilder.entity(response.readEntity(String.class));
        }
        return responseBuilder;
    }

    @Override
    public RequestResponse<JsonNode> updateTransaction(VitamContext vitamContext, TransactionDto transactionDto) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.put().withPath(TRANSACTION_PATH).withHeaders(vitamContext.getHeaders()).withHeader("Expect", (Object)"100-continue").withBody((Object)transactionDto).withJsonContentType().withJsonAccept();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> selectUnitsWithInheritedRules(VitamContext vitamContext, String transactionId, JsonNode selectQuery) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.get().withPath("/transactions/" + transactionId + UNITS_WITH_INHERITED_RULES).withBody((Object)selectQuery, BLANK_DSL).withHeaders(vitamContext.getHeaders()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponseOK<BulkAtomicUpdateResult> bulkAtomicUpdateUnits(VitamContext vitamContext, String transactionId, JsonNode updateQueriesJson) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + UNITS_BULK).withBody((Object)updateQueriesJson).withHeaders(vitamContext.getHeaders()).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponseOK requestResponseOK = (RequestResponseOK)RequestResponse.parseFromResponse((Response)response, BulkAtomicUpdateResult.class);
            return requestResponseOK;
        }
    }

    @Override
    public RequestResponse<JsonNode> performDeletionActionOnTransaction(VitamContext vitamContext, String transactionId, DeletionRequestBody deletionRequestBody) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/deletion/action").withHeaders(vitamContext.getHeaders()).withBody((Object)deletionRequestBody, MISSING_REQUEST).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }

    @Override
    public RequestResponse<JsonNode> performReclassificationOnTransaction(VitamContext vitamContext, String transactionId, JsonNode reclassificationRequest) throws VitamClientException {
        VitamRequestBuilder request = VitamRequestBuilder.post().withPath("/transactions/" + transactionId + "/reclassification").withHeaders(vitamContext.getHeaders()).withBody((Object)reclassificationRequest, MISSING_REQUEST).withJson();
        try (Response response = this.make(request);){
            this.check(response);
            RequestResponse requestResponse = RequestResponse.parseFromResponse((Response)response, JsonNode.class);
            return requestResponse;
        }
    }
}

