/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.security.internal.client;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.VitamClientFactoryInterface;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.SecureClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.processing.WorkFlowExecutionContext;
import fr.gouv.vitam.security.internal.client.InternalSecurityClient;
import fr.gouv.vitam.security.internal.client.InternalSecurityClientMock;
import fr.gouv.vitam.security.internal.client.InternalSecurityClientRest;
import java.io.File;
import java.io.IOException;

public class InternalSecurityClientFactory
extends VitamClientFactory<InternalSecurityClient> {
    private static final String CONFIGURATION_FILENAME = "internal-security-client.conf";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(InternalSecurityClientFactory.class);
    private static final InternalSecurityClientFactory ACCESS_CLIENT_FACTORY = new InternalSecurityClientFactory();
    private static final String RESOURCE_PATH = "/v1/api";

    private InternalSecurityClientFactory() {
        super(InternalSecurityClientFactory.changeConfigurationFile(), RESOURCE_PATH);
    }

    public static final InternalSecurityClientFactory getInstance() {
        return InternalSecurityClientFactory.getInstance(WorkFlowExecutionContext.VITAM);
    }

    public static InternalSecurityClientFactory getInstance(WorkFlowExecutionContext executionContext) {
        switch (executionContext) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VITAM: 
            case COLLECT: 
        }
        return ACCESS_CLIENT_FACTORY;
    }

    public InternalSecurityClient getClient() {
        return switch (this.getVitamClientType()) {
            default -> throw new IncompatibleClassChangeError();
            case VitamClientFactoryInterface.VitamClientType.MOCK -> new InternalSecurityClientMock();
            case VitamClientFactoryInterface.VitamClientType.PRODUCTION -> new InternalSecurityClientRest((VitamClientFactoryInterface<?>)this);
        };
    }

    private static ClientConfiguration changeConfigurationFile() {
        ClientConfiguration configuration = null;
        try {
            configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)CONFIGURATION_FILENAME), SecureClientConfigurationImpl.class);
        }
        catch (IOException fnf) {
            LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    public static void changeMode(ClientConfiguration configuration) {
        InternalSecurityClientFactory.getInstance().initialisation(configuration, InternalSecurityClientFactory.getInstance().getResourcePath());
    }
}

