/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.core.identifier.query;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import javax.annotation.Nullable;

public class PersistentIdentifierMultiQueryFactory {
    public static SelectMultiQuery createSelectMultiQuery(PurgedCollectionType purgedCollectionType, String persistentIdentifier, @Nullable JsonNode selectQuery) {
        if (purgedCollectionType == PurgedCollectionType.UNIT) {
            return PersistentIdentifierMultiQueryFactory.createUnitSelectMultiQuery(persistentIdentifier, selectQuery);
        }
        if (purgedCollectionType == PurgedCollectionType.OBJECT) {
            return PersistentIdentifierMultiQueryFactory.createObjectSelectMultiQuery(persistentIdentifier, selectQuery);
        }
        throw new IllegalStateException("Purged collection type not supported");
    }

    public static SelectMultiQuery createSelectMultiQuery(PurgedCollectionType purgedCollectionType, String persistentIdentifier) {
        return PersistentIdentifierMultiQueryFactory.createSelectMultiQuery(purgedCollectionType, persistentIdentifier, null);
    }

    private static SelectMultiQuery jsonNodeToSelectMultiQuery(JsonNode jsonNode) throws InvalidParseOperationException {
        SelectParserMultiple selectParserMultiple = new SelectParserMultiple();
        selectParserMultiple.parse(jsonNode);
        return selectParserMultiple.getRequest();
    }

    private static SelectMultiQuery createUnitSelectMultiQuery(String persistentIdentifier, @Nullable JsonNode selectQuery) {
        try {
            SelectParserMultiple query = new SelectParserMultiple();
            if (selectQuery != null) {
                query.parse(selectQuery);
            }
            SelectMultiQuery multiQuery = (SelectMultiQuery)query.getRequest().addQueries(new Query[]{QueryHelper.eq((String)"PersistentIdentifier.PersistentIdentifierContent", (String)persistentIdentifier)});
            JsonNode finalMultiQueryWithRestrictions = AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)multiQuery.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract());
            return PersistentIdentifierMultiQueryFactory.jsonNodeToSelectMultiQuery(finalMultiQueryWithRestrictions);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new VitamRuntimeException(e);
        }
    }

    private static SelectMultiQuery createObjectSelectMultiQuery(String persistentIdentifier, @Nullable JsonNode selectQuery) {
        try {
            SelectParserMultiple query = new SelectParserMultiple();
            if (selectQuery != null) {
                query.parse(selectQuery);
            }
            SelectMultiQuery multiQuery = (SelectMultiQuery)query.getRequest().addQueries(new Query[]{QueryHelper.nestedSearch((String)"#qualifiers.versions", (JsonNode)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"#qualifiers.versions.PersistentIdentifier.PersistentIdentifierContent", (String)persistentIdentifier)}).getCurrentQuery())});
            JsonNode finalMultiQueryWithRestrictions = AccessContractRestrictionHelper.applyAccessContractRestrictionForObjectGroupForSelect((JsonNode)multiQuery.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract());
            return PersistentIdentifierMultiQueryFactory.jsonNodeToSelectMultiQuery(finalMultiQueryWithRestrictions);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new VitamRuntimeException(e);
        }
    }
}

