/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.appserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.external.client.AccessExternalClient;
import fr.gouv.vitam.access.external.client.AccessExternalClientFactory;
import fr.gouv.vitam.access.external.client.AdminExternalClient;
import fr.gouv.vitam.access.external.client.AdminExternalClientFactory;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.ihmdemo.core.DslQueryHelper;
import fr.gouv.vitam.ihmdemo.core.UserInterfaceTransactionManager;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;

@Path(value="/v1/api")
@ApplicationPath(value="webresources")
public class WebPreservationResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WebPreservationResource.class);
    private final AdminExternalClientFactory adminExternalClientFactory;
    private final AccessExternalClientFactory accessExternalClientFactory;
    private final UserInterfaceTransactionManager userInterfaceTransactionManager;
    private final DslQueryHelper dslQueryHelper;

    @VisibleForTesting
    WebPreservationResource(AdminExternalClientFactory adminExternalClientFactory, AccessExternalClientFactory accessExternalClientFactory, UserInterfaceTransactionManager userInterfaceTransactionManager, DslQueryHelper dslQueryHelper) {
        this.adminExternalClientFactory = adminExternalClientFactory;
        this.accessExternalClientFactory = accessExternalClientFactory;
        this.userInterfaceTransactionManager = userInterfaceTransactionManager;
        this.dslQueryHelper = dslQueryHelper;
    }

    WebPreservationResource() {
        this(AdminExternalClientFactory.getInstance(), AccessExternalClientFactory.getInstance(), UserInterfaceTransactionManager.getInstance(), DslQueryHelper.getInstance());
    }

    @POST
    @Path(value="/preservation")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"preservation:update"})
    public Response launchPreservation(@Context HttpServletRequest request, String preservationString) {
        Response response;
        block8: {
            AccessExternalClient client = this.accessExternalClientFactory.getClient();
            try {
                PreservationRequest preservationRequest = (PreservationRequest)JsonHandler.getFromString((String)preservationString, PreservationRequest.class);
                VitamContext vitamContext = this.userInterfaceTransactionManager.getVitamContext(request);
                RequestResponse response2 = client.launchPreservation(vitamContext, preservationRequest);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/preservationScenarios")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"preservationScenarios:read"})
    public Response getPreservationScenarios(@Context HttpServletRequest request, String select) {
        VitamContext vitamContext = this.userInterfaceTransactionManager.getVitamContext(request);
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse response2 = client.findPreservationScenario(vitamContext, query);
            if (response2 instanceof RequestResponseOK) {
                Response response3 = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                return response3;
            }
            Response response = Response.status((int)response2.getHttpCode()).entity((Object)response2).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/griffins")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"griffins:read"})
    public Response getPreservationGriffins(@Context HttpServletRequest request, String select) {
        VitamContext vitamContext = this.userInterfaceTransactionManager.getVitamContext(request);
        try (AdminExternalClient client = this.adminExternalClientFactory.getClient();){
            Map optionsMap = JsonHandler.getMapFromString((String)select);
            JsonNode query = this.dslQueryHelper.createSingleQueryDSL(optionsMap);
            RequestResponse response2 = client.findGriffin(vitamContext, query);
            if (response2 instanceof RequestResponseOK) {
                Response response3 = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
                return response3;
            }
            Response response = Response.status((int)response2.getHttpCode()).entity((Object)response2).build();
            return response;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/griffins")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"griffins:create"})
    public Response uploadGriffins(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
            RequestResponse response = adminClient.importGriffin(this.userInterfaceTransactionManager.getVitamContext(request), input, request.getHeader("X-Filename"));
            if (response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/scenarios")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"preservationScenarios:create"})
    public Response uploadPreservationScenario(@Context HttpServletRequest request, InputStream input) {
        try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
            RequestResponse response = adminClient.importPreservationScenario(this.userInterfaceTransactionManager.getVitamContext(request), input, request.getHeader("X-Filename"));
            if (response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).build();
                return response2;
            }
            if (response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getStatus()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="griffin/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"griffin:read"})
    public Response getGriffinById(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
            RequestResponse response = adminClient.findGriffinById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error("INTERNAL SERVER ERROR", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="scenario/{id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"preservationScenario:read"})
    public Response getPreservationScenarioById(@Context HttpServletRequest request, @PathParam(value="id") String id) {
        try (AdminExternalClient adminClient = AdminExternalClientFactory.getInstance().getClient();){
            RequestResponse response = adminClient.findPreservationScenarioById(this.userInterfaceTransactionManager.getVitamContext(request), id);
            if (response instanceof RequestResponseOK) {
                Response response2 = Response.status((Response.Status)Response.Status.OK).entity((Object)response).build();
                return response2;
            }
            if (response instanceof VitamError) {
                LOGGER.error(response.toString());
                Response response3 = Response.status((int)response.getHttpCode()).entity((Object)response).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
            return response4;
        }
        catch (Exception e) {
            LOGGER.error("INTERNAL SERVER ERROR", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

