/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.appserver;

import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.exception.VitamApplicationServerException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.serverv2.VitamStarter;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.ihmdemo.appserver.BusinessApplication;
import fr.gouv.vitam.ihmdemo.appserver.WebApplicationConfig;
import java.util.List;
import javax.ws.rs.core.Application;

public class IhmDemoMain {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IhmDemoMain.class);
    private static final String CONF_FILE_NAME = "ihm-demo.conf";
    private static final String MODULE_NAME = ServerIdentity.getInstance().getRole();
    private final VitamStarter vitamStarter;

    public IhmDemoMain(String configurationFile) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        this.vitamStarter = new VitamStarter(WebApplicationConfig.class, configurationFile, BusinessApplication.class, AdminApplication.class, (List)Lists.newArrayList(), true);
    }

    public IhmDemoMain(String configurationFile, Class<? extends Application> testBusinessApplication, Class<? extends Application> testAdminApplication) {
        ParametersChecker.checkParameter((String)String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME), (String[])new String[]{configurationFile});
        if (null == testBusinessApplication) {
            testBusinessApplication = BusinessApplication.class;
        }
        if (null == testAdminApplication) {
            testAdminApplication = AdminApplication.class;
        }
        this.vitamStarter = new VitamStarter(WebApplicationConfig.class, configurationFile, testBusinessApplication, testAdminApplication, (List)Lists.newArrayList(), true);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length == 0) {
                LOGGER.error(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
                throw new IllegalArgumentException(String.format("Config file %s is a mandatory argument. ", CONF_FILE_NAME));
            }
            IhmDemoMain main = new IhmDemoMain(args[0]);
            main.startAndJoin();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s application server can not start. ", MODULE_NAME) + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public void start() throws VitamApplicationServerException {
        this.vitamStarter.start();
    }

    public void startAndJoin() throws VitamApplicationServerException {
        this.vitamStarter.run();
    }

    public void stop() throws VitamApplicationServerException {
        this.vitamStarter.stop();
    }
}

