/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.ihmdemo.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.facet.CardinalityFacet;
import fr.gouv.vitam.common.database.builder.facet.CountFacet;
import fr.gouv.vitam.common.database.builder.facet.DateRangeFacet;
import fr.gouv.vitam.common.database.builder.facet.Facet;
import fr.gouv.vitam.common.database.builder.facet.FiltersFacet;
import fr.gouv.vitam.common.database.builder.facet.RangeFacetValue;
import fr.gouv.vitam.common.database.builder.facet.SumFacet;
import fr.gouv.vitam.common.database.builder.facet.TermsFacet;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.RangeQuery;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.SetregexAction;
import fr.gouv.vitam.common.database.builder.query.action.UnsetAction;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.FacetDateRangeItem;
import fr.gouv.vitam.common.model.FacetFiltersItem;
import fr.gouv.vitam.common.model.RequestFacetItem;
import fr.gouv.vitam.ihmdemo.core.FacetItem;
import fr.gouv.vitam.ihmdemo.core.UiConstants;
import java.lang.invoke.LambdaMetafactory;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DslQueryHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DslQueryHelper.class);
    public static final String PROJECTION_DSL = "projection_";
    private static final String EVENT_TYPE_PROCESS = "evTypeProc";
    private static final String ALL = "All";
    private static final String EVENT_ID_PROCESS = "evIdProc";
    private static final String CONTEXT_ID = "ContextID";
    private static final String CONTEXT_NAME = "ContextName";
    private static final String CONTRACT_ID = "ContractID";
    private static final String CONTRACT_NAME = "ContractName";
    private static final String AGENCY_ID = "AgencyID";
    private static final String AGENCY_NAME = "AgencyName";
    private static final String PROFILE_ID = "ProfileID";
    private static final String PROFILE_IDENTIFIER = "ProfileIdentifier";
    private static final String PROFILE_NAME = "ProfileName";
    private static final String ARCHIVE_UNIT_PROFILE_ID = "ArchiveUnitProfileID";
    private static final String ARCHIVE_UNIT_PROFILE_IDENTIFIER = "ArchiveUnitProfileIdentifier";
    private static final String ARCHIVE_UNIT_PROFILE_NAME = "ArchiveUnitProfileName";
    private static final String RULE_CATEGORY = "RuleCategory";
    private static final String RULE_DATE_SUP = "RuleDateSup";
    private static final String RULE_FINAL_ACTION = "RuleFinalAction";
    private static final String ONTOLOGY_TYPE = "OntologyType";
    private static final String ONTOLOGY_NAME = "OntologyName";
    private static final String ONTOLOGY_ID = "OntologyID";
    private static final String ORIGINATING_AGENCY_TAG = "#originating_agency";
    private static final String ELIMINATION_DESTROYABLE_ORIGINATING_AGENCY_TAG = "#elimination.DestroyableOriginatingAgencies";
    private static final String ELIMINATION_NON_DESTROYABLE_ORIGINATING_AGENCY_TAG = "#elimination.NonDestroyableOriginatingAgencies";
    private static final String ELIMINATION_GLOBAL_STATUS_TAG = "#elimination.GlobalStatus";
    private static final String ELIMINATION_EXTENDED_INFO_TYPE_TAG = "#elimination.ExtendedInfo.ExtendedInfoType";
    private static final String DESCRIPTION_LEVEL_TAG = "DescriptionLevel";
    private static final String DESCRIPTION = "Description";
    private static final String ELIMINATION_OPERATION_ID = "EliminationOperationId";
    private static final String TITLE = "Title";
    private static final String TITLE_FR = "Title_.fr";
    private static final String EVENT_DATE_TIME = "evDateTime";
    private static final String DEFAULT_EVENT_TYPE_PROCESS = "INGEST";
    private static final String EVENT_OUT_DETAIL = "events.outDetail";
    private static final String DEFAULT_EVENT_TYPE_PROCESS_TEST = "INGEST_TEST";
    private static final String PUID = "PUID";
    private static final String RULEVALUE = "RuleValue";
    private static final String OBJECT_IDENTIFIER_INCOME = "obIdIn";
    private static final String FORMAT = "FORMAT";
    private static final String FORMAT_NAME = "FormatName";
    private static final String RULE_VALUE = "RuleValue";
    private static final String EVENTID = "EventID";
    private static final String EVENTTYPE = "EventType";
    private static final String RULES = "RULES";
    private static final String ACCESSION_REGISTER = "ACCESSIONREGISTER";
    private static final String UNITUPS = "UNITUPS";
    private static final String ROOTS = "ROOTS";
    private static final String RULETYPE = "RuleType";
    private static final String ORDER_BY = "orderby";
    private static final String TITLE_AND_DESCRIPTION = "titleAndDescription";
    private static final String PROJECTION_PREFIX = "projection_";
    private static final int DEPTH_LIMIT = 20;
    private static final String START_PREFIX = "Start";
    private static final String END_PREFIX = "End";
    private static final String START_DATE = "StartDate";
    private static final String END_DATE = "EndDate";
    private static final String TRANSACTED_DATE = "TransactedDate";
    private static final String ADVANCED_SEARCH_FLAG = "isAdvancedSearchFlag";
    private static final String YES = "yes";
    private static final String ORIGINATING_AGENCY = "OriginatingAgency";
    private static final String ORIGINATING_AGENCIES = "OriginatingAgencies";
    private static final String DATEOPERATION = "EvDateTime";
    private static final String TRACEABILITY_OK = "TraceabilityOk";
    private static final String TRACEABILITY_ID = "TraceabilityId";
    private static final String TRACEABILITY_LOG_TYPE = "TraceabilityLogType";
    private static final String TRACEABILITY_START_DATE = "TraceabilityStartDate";
    private static final String TRACEABILITY_END_DATE = "TraceabilityEndDate";
    private static final String TRACEABILITY_EV_DET_DATA = "events.evDetData";
    private static final String TRACEABILITY_FIELD_ID = "evId";
    private static final String TRACEABILITY_FIELD_LOG_TYPE = "LogType";
    private static final String MANAGEMENT_KEY = "#management";
    private static final String INGEST_START_DATE = "IngestStartDate";
    private static final String INGEST_END_DATE = "IngestEndDate";
    private static final String FACETS_PREFIX = "facets";
    private static final String ASC_SORT_TYPE = "ASC";
    private static final String SORT_TYPE_ENTRY = "sortType";
    private static final String SORT_FIELD_ENTRY = "field";
    private static final String REQUEST_FACET_PREFIX = "requestFacet";
    private static final String EXISTS = "$exists";
    private static final String MISSING = "$missing";
    private static final String LANGUAGE = "Language";
    private static final String FACET_WITH_OBJECT = "FacetWithObject";
    private static final String FACET_WITHOUT_OBJECT = "FacetWithoutObject";
    private static final String GOT_FILE_FORMAT_ID = "fileFormatId";
    private static final String GOT_FILE_USAGE = "fileUsage";
    private static final String GOT_FILE_SIZE = "fileSize";
    private static final String GOT_FILE_SIZE_OPERATOR = "fileSizeOperator";
    private static final String GOT_FILE_SIZE_OPERATOR_LOWER = "<";
    private static final String GOT_FILE_SIZE_OPERATOR_GREATER_OR_EQUAL = ">=";
    private static final String FILE_FORMAT_ID_GOT_FIELD = "#qualifiers.versions.FormatIdentification.FormatId";
    private static final String FILE_USAGE_GOT_FIELD = "#qualifiers.versions.DataObjectVersion";
    private static final String FILE_SIZE_GOT_FIELD = "#qualifiers.versions.Size";
    private static final String SCENARIO_NAME = "ScenarioName";
    private static final String GRIFFIN_NAME = "GriffinName";
    private static final String SCENARIO_ID = "ScenarioID";
    private static final String GRIFFIN_ID = "GriffinID";
    private static final DslQueryHelper instance = new DslQueryHelper();

    public static DslQueryHelper getInstance() {
        return instance;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public JsonNode createSingleQueryDSL(Map<String, Object> searchCriteriaMap) throws InvalidParseOperationException, InvalidCreateOperationException {
        select = new Select();
        query = QueryHelper.and();
        queryOr = null;
        block87: for (Map.Entry<String, Object> entry : searchCriteriaMap.entrySet()) {
            searchKeys = entry.getKey();
            if ("orderby".equalsIgnoreCase(searchKeys)) {
                sortSetting = (Map)entry.getValue();
                sortField = (String)sortSetting.get("field");
                sortType = (String)sortSetting.get("sortType");
                realSortField = sortField;
                var12_14 = sortField;
                var13_15 = -1;
                switch (var12_14.hashCode()) {
                    case 347102288: {
                        if (!var12_14.equals("AgencyName")) break;
                        var13_15 = 0;
                        break;
                    }
                    case -1238205731: {
                        if (!var12_14.equals("ContractName")) break;
                        var13_15 = 1;
                        break;
                    }
                    case 1845371828: {
                        if (!var12_14.equals("ProfileName")) break;
                        var13_15 = 2;
                        break;
                    }
                    case 1391433390: {
                        if (!var12_14.equals("ArchiveUnitProfileName")) break;
                        var13_15 = 3;
                        break;
                    }
                    case -831648614: {
                        if (!var12_14.equals("OntologyName")) break;
                        var13_15 = 4;
                        break;
                    }
                    case -2083515630: {
                        if (!var12_14.equals("ProfileIdentifier")) break;
                        var13_15 = 5;
                        break;
                    }
                    case 1597629068: {
                        if (!var12_14.equals("ArchiveUnitProfileIdentifier")) break;
                        var13_15 = 6;
                    }
                }
                switch (var13_15) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        realSortField = "ApiField";
                        break;
                    }
                    case 5: 
                    case 6: {
                        realSortField = "Identifier";
                        break;
                    }
                }
                if ("ASC".equalsIgnoreCase(sortType)) {
                    select.addOrderByAscFilter(new String[]{realSortField});
                    continue;
                }
                select.addOrderByDescFilter(new String[]{realSortField});
                continue;
            }
            if (searchKeys.startsWith("facets")) {
                facetSettings = (List)entry.getValue();
                block88: for (i = 0; i < facetSettings.size(); ++i) {
                    facetItem = (FacetItem)JsonHandler.getFromString((String)JsonHandler.writeAsString(facetSettings.get(i)), FacetItem.class);
                    if (facetItem.getFacetType() == null) continue;
                    switch (1.$SwitchMap$fr$gouv$vitam$common$model$FacetType[facetItem.getFacetType().ordinal()]) {
                        case 1: {
                            select.addFacets(new Facet[]{new TermsFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject(), facetItem.getSize(), facetItem.getOrder())});
                            continue block88;
                        }
                        case 2: {
                            select.addFacets(new Facet[]{new SumFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject())});
                            continue block88;
                        }
                        case 3: {
                            select.addFacets(new Facet[]{new CountFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject())});
                            continue block88;
                        }
                        case 4: {
                            select.addFacets(new Facet[]{new CardinalityFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject())});
                            continue block88;
                        }
                        case 5: {
                            ranges = facetItem.getRanges().stream().map((Function<FacetDateRangeItem, RangeFacetValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$createSingleQueryDSL$0(fr.gouv.vitam.common.model.FacetDateRangeItem ), (Lfr/gouv/vitam/common/model/FacetDateRangeItem;)Lfr/gouv/vitam/common/database/builder/facet/RangeFacetValue;)()).collect(Collectors.toList());
                            select.addFacets(new Facet[]{new DateRangeFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject(), facetItem.getFormat(), ranges)});
                            continue block88;
                        }
                        case 6: {
                            filters /* !! */  = new HashMap<K, V>();
                            facetItem.getFilters().forEach((Consumer<FacetFiltersItem>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$createSingleQueryDSL$1(java.util.Map fr.gouv.vitam.common.model.FacetFiltersItem ), (Lfr/gouv/vitam/common/model/FacetFiltersItem;)V)((Map)filters /* !! */ ));
                            select.addFacets(new Facet[]{new FiltersFacet(facetItem.getName(), (Map)filters /* !! */ )});
                            continue block88;
                        }
                    }
                }
                continue;
            }
            searchValue = (String)entry.getValue();
            var9_9 = searchKeys;
            var10_12 = -1;
            switch (var9_9.hashCode()) {
                case -2130820508: {
                    if (!var9_9.equals("INGEST")) break;
                    var10_12 = 0;
                    break;
                }
                case -1024353261: {
                    if (!var9_9.equals("obIdIn")) break;
                    var10_12 = 1;
                    break;
                }
                case 2079517687: {
                    if (!var9_9.equals("FORMAT")) break;
                    var10_12 = 2;
                    break;
                }
                case -1977880766: {
                    if (!var9_9.equals("FormatName")) break;
                    var10_12 = 3;
                    break;
                }
                case -96917579: {
                    if (!var9_9.equals("RuleValue")) break;
                    var10_12 = 4;
                    break;
                }
                case -959241561: {
                    if (!var9_9.equals("ACCESSIONREGISTER")) break;
                    var10_12 = 5;
                    break;
                }
                case -2133366610: {
                    if (!var9_9.equals("OriginatingAgency")) break;
                    var10_12 = 6;
                    break;
                }
                case 78336215: {
                    if (!var9_9.equals("RULES")) break;
                    var10_12 = 7;
                    break;
                }
                case 828121206: {
                    if (!var9_9.equals("RuleType")) break;
                    var10_12 = 8;
                    break;
                }
                case 288150805: {
                    if (!var9_9.equals("EventID")) break;
                    var10_12 = 9;
                    break;
                }
                case 2035398868: {
                    if (!var9_9.equals("EventType")) break;
                    var10_12 = 10;
                    break;
                }
                case -1643365492: {
                    if (!var9_9.equals("EvDateTime")) break;
                    var10_12 = 11;
                    break;
                }
                case -1783458527: {
                    if (!var9_9.equals("TraceabilityOk")) break;
                    var10_12 = 12;
                    break;
                }
                case -1783458720: {
                    if (!var9_9.equals("TraceabilityId")) break;
                    var10_12 = 13;
                    break;
                }
                case 300327033: {
                    if (!var9_9.equals("TraceabilityLogType")) break;
                    var10_12 = 14;
                    break;
                }
                case 1031198795: {
                    if (!var9_9.equals("TraceabilityStartDate")) break;
                    var10_12 = 15;
                    break;
                }
                case -1649130748: {
                    if (!var9_9.equals("TraceabilityEndDate")) break;
                    var10_12 = 16;
                    break;
                }
                case 959422732: {
                    if (!var9_9.equals("IngestStartDate")) break;
                    var10_12 = 17;
                    break;
                }
                case 1255819269: {
                    if (!var9_9.equals("IngestEndDate")) break;
                    var10_12 = 18;
                    break;
                }
                case -831446711: {
                    if (!var9_9.equals("OntologyType")) break;
                    var10_12 = 19;
                    break;
                }
                case 347102288: {
                    if (!var9_9.equals("AgencyName")) break;
                    var10_12 = 20;
                    break;
                }
                case 1564826810: {
                    if (!var9_9.equals("ContextName")) break;
                    var10_12 = 21;
                    break;
                }
                case -1238205731: {
                    if (!var9_9.equals("ContractName")) break;
                    var10_12 = 22;
                    break;
                }
                case 1845371828: {
                    if (!var9_9.equals("ProfileName")) break;
                    var10_12 = 23;
                    break;
                }
                case -844009893: {
                    if (!var9_9.equals("ScenarioName")) break;
                    var10_12 = 24;
                    break;
                }
                case 352770254: {
                    if (!var9_9.equals("GriffinName")) break;
                    var10_12 = 25;
                    break;
                }
                case 1391433390: {
                    if (!var9_9.equals("ArchiveUnitProfileName")) break;
                    var10_12 = 26;
                    break;
                }
                case -831648614: {
                    if (!var9_9.equals("OntologyName")) break;
                    var10_12 = 27;
                    break;
                }
                case 1533320192: {
                    if (!var9_9.equals("AgencyID")) break;
                    var10_12 = 28;
                    break;
                }
                case -1677264435: {
                    if (!var9_9.equals("ContractID")) break;
                    var10_12 = 29;
                    break;
                }
                case 1597157098: {
                    if (!var9_9.equals("ContextID")) break;
                    var10_12 = 30;
                    break;
                }
                case 998567012: {
                    if (!var9_9.equals("ProfileID")) break;
                    var10_12 = 31;
                    break;
                }
                case -318196533: {
                    if (!var9_9.equals("ScenarioID")) break;
                    var10_12 = 32;
                    break;
                }
                case -947118082: {
                    if (!var9_9.equals("GriffinID")) break;
                    var10_12 = 33;
                    break;
                }
                case -1169500706: {
                    if (!var9_9.equals("ArchiveUnitProfileID")) break;
                    var10_12 = 34;
                    break;
                }
                case -662317366: {
                    if (!var9_9.equals("OntologyID")) break;
                    var10_12 = 35;
                    break;
                }
                case -2083515630: {
                    if (!var9_9.equals("ProfileIdentifier")) break;
                    var10_12 = 36;
                    break;
                }
                case 1597629068: {
                    if (!var9_9.equals("ArchiveUnitProfileIdentifier")) break;
                    var10_12 = 37;
                }
            }
            switch (var10_12) {
                case 0: {
                    query.add(new Query[]{QueryHelper.or().add(new Query[]{QueryHelper.eq((String)"evTypeProc", (String)"INGEST"), QueryHelper.eq((String)"evTypeProc", (String)"INGEST_TEST")})});
                    break;
                }
                case 1: {
                    query.add(new Query[]{QueryHelper.eq((String)"events.obIdIn", (String)searchValue)});
                    break;
                }
                case 2: {
                    query.add(new Query[]{QueryHelper.exists((String)"PUID")});
                    break;
                }
                case 3: {
                    if (searchValue.trim().isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.match((String)"Name", (String)searchValue)});
                    break;
                }
                case 4: {
                    if (searchValue.trim().isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.match((String)"RuleValue", (String)searchValue)});
                    break;
                }
                case 5: {
                    query.add(new Query[]{QueryHelper.exists((String)"OriginatingAgency")});
                    break;
                }
                case 6: {
                    query.add(new Query[]{QueryHelper.eq((String)"OriginatingAgency", (String)searchValue)});
                    break;
                }
                case 7: {
                    query.add(new Query[]{QueryHelper.exists((String)"RuleValue")});
                    break;
                }
                case 8: {
                    if (searchValue.contains("All")) break;
                    if (searchValue.contains(",")) {
                        queryOr = QueryHelper.or();
                        for (String s : ruleTypeArray = searchValue.split(",")) {
                            queryOr.add(new Query[]{QueryHelper.eq((String)"RuleType", (String)s)});
                        }
                        continue block87;
                    }
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.eq((String)"RuleType", (String)searchValue)});
                    break;
                }
                case 9: {
                    if ("all".equals(searchValue)) {
                        query.add(new Query[]{QueryHelper.exists((String)"evIdProc")});
                        break;
                    }
                    query.add(new Query[]{QueryHelper.eq((String)"evIdProc", (String)searchValue)});
                    break;
                }
                case 10: {
                    if (searchValue.isEmpty()) continue block87;
                    if ("all".equals(searchValue)) {
                        query.add(new Query[]{QueryHelper.exists((String)"evTypeProc")});
                        break;
                    }
                    query.add(new Query[]{QueryHelper.eq((String)"evTypeProc", (String)searchValue.toUpperCase())});
                    break;
                }
                case 11: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.gte((String)"evDateTime", (String)searchValue)});
                    break;
                }
                case 12: {
                    if (!"true".equals(searchValue)) continue block87;
                    checkStatus = QueryHelper.in((String)"events.outDetail", (String[])new String[]{"STP_OP_SECURISATION.OK", "STP_STORAGE_SECURISATION.OK", "STP_STORAGE_SECURISATION.WARNING", "LOGBOOK_UNIT_LFC_TRACEABILITY.OK", "LOGBOOK_UNIT_LFC_TRACEABILITY.WARNING", "LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY.OK", "LOGBOOK_OBJECTGROUP_LFC_TRACEABILITY.WARNING"});
                    hasFilename = QueryHelper.exists((String)"events.evDetData.FileName");
                    query.add(new Query[]{checkStatus}).add(new Query[]{hasFilename});
                    break;
                }
                case 13: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.eq((String)"evId", (String)searchValue)});
                    break;
                }
                case 14: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.eq((String)"events.evDetData.LogType", (String)searchValue)});
                    break;
                }
                case 15: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.gte((String)"events.evDetData.StartDate", (String)searchValue)});
                    break;
                }
                case 16: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.lte((String)"events.evDetData.EndDate", (String)searchValue)});
                    break;
                }
                case 17: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.gte((String)"evDateTime", (String)searchValue)});
                    break;
                }
                case 18: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.lte((String)"evDateTime", (String)searchValue)});
                    break;
                }
                case 19: {
                    if (!"all".equals(searchValue)) ** GOTO lbl357
                    query.add(new Query[]{QueryHelper.exists((String)"Type")});
                    ** GOTO lbl360
lbl357:
                    // 1 sources

                    if (!searchValue.isEmpty()) {
                        query.add(new Query[]{QueryHelper.match((String)"Type", (String)searchValue)});
                    }
                }
lbl360:
                // 5 sources

                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    if ("all".equals(searchValue)) {
                        query.add(new Query[]{QueryHelper.exists((String)"Name")});
                        break;
                    }
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.match((String)"Name", (String)searchValue)});
                    break;
                }
                case 27: {
                    if ("all".equals(searchValue)) {
                        query.add(new Query[]{QueryHelper.or().add(new Query[]{QueryHelper.exists((String)"ApiField")}).add(new Query[]{QueryHelper.exists((String)"SedaField")})});
                        break;
                    }
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.or().add(new Query[]{QueryHelper.eq((String)"ApiField", (String)searchValue)}).add(new Query[]{QueryHelper.eq((String)"SedaField", (String)searchValue)})});
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    if ("all".equals(searchValue)) continue block87;
                    query.add(new Query[]{QueryHelper.eq((String)"Identifier", (String)searchValue)});
                    break;
                }
                case 36: 
                case 37: {
                    if ("all".equals(searchValue)) {
                        query.add(new Query[]{QueryHelper.exists((String)"Identifier")});
                        break;
                    }
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.match((String)"Identifier", (String)searchValue)});
                    break;
                }
                default: {
                    if (searchValue.isEmpty()) continue block87;
                    query.add(new Query[]{QueryHelper.eq((String)searchKeys, (String)searchValue)});
                }
            }
        }
        if (queryOr != null) {
            query.add(new Query[]{queryOr});
        }
        select.setQuery((Query)query);
        DslQueryHelper.LOGGER.debug("{}", (Object)select.getFinalSelect());
        return select.getFinalSelect();
    }

    public JsonNode createSelectDSLQuery(Map<String, String> searchCriteriaMap) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectMultiQuery select = new SelectMultiQuery();
        BooleanQuery booleanQueries = QueryHelper.and();
        for (Map.Entry<String, String> entry : searchCriteriaMap.entrySet()) {
            String searchKeys = entry.getKey();
            String searchValue = entry.getValue();
            if (searchKeys.isEmpty() || searchValue.isEmpty()) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            if (searchKeys.startsWith("projection_")) {
                select.addUsedProjection(new String[]{searchValue});
                continue;
            }
            if (searchKeys.equals(ORDER_BY)) {
                select.addOrderByAscFilter(new String[]{searchValue});
                continue;
            }
            if (searchKeys.equals(UiConstants.SELECT_BY_ID.toString())) {
                select.addRoots(new String[]{searchValue});
                continue;
            }
            booleanQueries.add(new Query[]{QueryHelper.eq((String)searchKeys, (String)searchValue)});
        }
        if (booleanQueries.isReady()) {
            boolean noRoots;
            boolean bl = noRoots = select.getRoots() == null || select.getRoots().isEmpty();
            if (!noRoots || select.getNbQueries() != 0) {
                booleanQueries.setDepthLimit(20);
            }
            select.addQueries(new Query[]{booleanQueries});
        }
        return select.getFinalSelect();
    }

    public JsonNode createGetByIdDSLSelectMultipleQuery(Map<String, String> projectionCriteriaMap) throws InvalidParseOperationException, InvalidCreateOperationException {
        SelectMultiQuery select = new SelectMultiQuery();
        for (Map.Entry<String, String> entry : projectionCriteriaMap.entrySet()) {
            String searchKeys = entry.getKey();
            String searchValue = entry.getValue();
            if (searchKeys.isEmpty() || searchValue.isEmpty()) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            if (!searchKeys.startsWith("projection_")) continue;
            select.addUsedProjection(new String[]{searchValue});
        }
        ObjectNode finalSelect = select.getFinalSelectById();
        return finalSelect;
    }

    public JsonNode createSelectElasticsearchDSLQuery(Map<String, Object> searchCriteriaMap) throws InvalidParseOperationException, InvalidCreateOperationException {
        boolean noRoots;
        SelectMultiQuery select = new SelectMultiQuery();
        BooleanQuery andQuery = QueryHelper.and();
        BooleanQuery nestedSubQuery = null;
        BooleanQuery booleanQueries = QueryHelper.or();
        boolean advancedFacetQuery = false;
        String startDate = null;
        String endDate = null;
        String advancedSearchFlag = "";
        String ruleCategory = null;
        String ruleFinalAction = null;
        String ruleEndDate = null;
        String fileSize = null;
        String fileSizeOperator = null;
        block20: for (Map.Entry<String, Object> entry : searchCriteriaMap.entrySet()) {
            RequestFacetItem requestFacetItem;
            String searchKeys = entry.getKey();
            Object searchValue = entry.getValue();
            if (searchKeys.isEmpty() || searchValue == null) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            if (searchKeys.startsWith("projection_")) {
                select.addUsedProjection(new String[]{(String)searchValue});
                continue;
            }
            if (searchKeys.startsWith(FACETS_PREFIX)) {
                List facetSettings = (List)searchValue;
                block21: for (int i = 0; i < facetSettings.size(); ++i) {
                    FacetItem facetItem = (FacetItem)JsonHandler.getFromString((String)JsonHandler.writeAsString(facetSettings.get(i)), FacetItem.class);
                    if (facetItem.getFacetType() == null) continue;
                    switch (facetItem.getFacetType()) {
                        case TERMS: {
                            select.addFacets(new Facet[]{new TermsFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject(), facetItem.getSize(), facetItem.getOrder())});
                            continue block21;
                        }
                        case SUM: {
                            select.addFacets(new Facet[]{new SumFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject())});
                            continue block21;
                        }
                        case DATE_RANGE: {
                            List ranges = facetItem.getRanges().stream().map(range -> new RangeFacetValue(range.getDateMin(), range.getDateMax())).collect(Collectors.toList());
                            select.addFacets(new Facet[]{new DateRangeFacet(facetItem.getName(), facetItem.getField(), facetItem.getSubobject(), facetItem.getFormat(), ranges)});
                            continue block21;
                        }
                        case FILTERS: {
                            HashMap filters = new HashMap();
                            facetItem.getFilters().forEach(filter -> {
                                if (filter.getQuery().get(EXISTS) != null) {
                                    try {
                                        filters.put(filter.getName(), QueryHelper.exists((String)filter.getQuery().get(EXISTS).asText()));
                                    }
                                    catch (InvalidCreateOperationException e) {
                                        LOGGER.error((Throwable)e);
                                    }
                                } else if (filter.getQuery().get(MISSING) != null) {
                                    try {
                                        filters.put(filter.getName(), QueryHelper.missing((String)filter.getQuery().get(MISSING).asText()));
                                    }
                                    catch (InvalidCreateOperationException e) {
                                        LOGGER.error((Throwable)e);
                                    }
                                }
                            });
                            select.addFacets(new Facet[]{new FiltersFacet(facetItem.getName(), filters)});
                            continue block21;
                        }
                    }
                }
                continue;
            }
            if (searchKeys.equals(ORDER_BY)) {
                Map sortSetting = (Map)searchValue;
                String sortField = (String)sortSetting.get(SORT_FIELD_ENTRY);
                String sortType = (String)sortSetting.get(SORT_TYPE_ENTRY);
                if (ASC_SORT_TYPE.equalsIgnoreCase(sortType)) {
                    select.addOrderByAscFilter(new String[]{sortField});
                    continue;
                }
                select.addOrderByDescFilter(new String[]{sortField});
                continue;
            }
            if (searchKeys.equals(UiConstants.SELECT_BY_ID.toString())) {
                select.addRoots(new String[]{(String)searchValue});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(UNITUPS)) {
                andQuery.add(new Query[]{QueryHelper.in((String)UiConstants.UNITUPS.getResultCriteria(), (String[])new String[]{(String)searchValue})});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(ROOTS)) {
                List list = (List)searchValue;
                String[] roots = list.toArray(new String[list.size()]);
                select.addRoots(roots);
                continue;
            }
            if (searchKeys.equals(TITLE_AND_DESCRIPTION)) {
                booleanQueries.add(new Query[]{QueryHelper.match((String)TITLE, (String)((String)searchValue))});
                booleanQueries.add(new Query[]{QueryHelper.match((String)TITLE_FR, (String)((String)searchValue))});
                booleanQueries.add(new Query[]{QueryHelper.match((String)DESCRIPTION, (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(UiConstants.ID.getReceivedCriteria())) {
                BooleanQuery idQuery = QueryHelper.or().add(new Query[]{QueryHelper.eq((String)UiConstants.ID.getResultCriteria(), (String)((String)searchValue))});
                idQuery.add(new Query[]{QueryHelper.eq((String)"FilePlanPosition", (String)((String)searchValue))});
                idQuery.add(new Query[]{QueryHelper.eq((String)"OriginatingSystemId", (String)((String)searchValue))});
                idQuery.add(new Query[]{QueryHelper.eq((String)"OriginatingAgencySystemId", (String)((String)searchValue))});
                idQuery.add(new Query[]{QueryHelper.eq((String)"TransferringAgencySystemId", (String)((String)searchValue))});
                idQuery.add(new Query[]{QueryHelper.eq((String)"ArchivalAgencySystemId", (String)((String)searchValue))});
                andQuery.add(new Query[]{idQuery});
                continue;
            }
            if (searchKeys.equals(ELIMINATION_OPERATION_ID)) {
                andQuery.add(new Query[]{QueryHelper.eq((String)(VitamFieldsHelper.elimination() + ".OperationId"), (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(TITLE)) {
                andQuery.add(new Query[]{QueryHelper.or().add(new Query[]{QueryHelper.match((String)TITLE, (String)((String)searchValue))}).add(new Query[]{QueryHelper.match((String)TITLE_FR, (String)((String)searchValue))})});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(DESCRIPTION)) {
                andQuery.add(new Query[]{QueryHelper.match((String)DESCRIPTION, (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(ORIGINATING_AGENCY)) {
                andQuery.add(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.originatingAgency(), (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(ORIGINATING_AGENCIES)) {
                andQuery.add(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.originatingAgencies(), (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(GOT_FILE_FORMAT_ID)) {
                if (nestedSubQuery == null) {
                    nestedSubQuery = QueryHelper.and();
                }
                nestedSubQuery.add(new Query[]{QueryHelper.eq((String)FILE_FORMAT_ID_GOT_FIELD, (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(GOT_FILE_USAGE)) {
                if (nestedSubQuery == null) {
                    nestedSubQuery = QueryHelper.and();
                }
                nestedSubQuery.add(new Query[]{QueryHelper.eq((String)FILE_USAGE_GOT_FIELD, (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(GOT_FILE_SIZE)) {
                fileSize = (String)searchValue;
                if (fileSizeOperator == null) continue;
                if (fileSizeOperator.equals(GOT_FILE_SIZE_OPERATOR_LOWER)) {
                    if (nestedSubQuery == null) {
                        nestedSubQuery = QueryHelper.and();
                    }
                    nestedSubQuery.add(new Query[]{QueryHelper.lt((String)FILE_SIZE_GOT_FIELD, (String)((String)searchValue))});
                    continue;
                }
                if (!fileSizeOperator.equals(GOT_FILE_SIZE_OPERATOR_GREATER_OR_EQUAL)) continue;
                if (nestedSubQuery == null) {
                    nestedSubQuery = QueryHelper.and();
                }
                nestedSubQuery.add(new Query[]{QueryHelper.gte((String)FILE_SIZE_GOT_FIELD, (String)((String)searchValue))});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(GOT_FILE_SIZE_OPERATOR)) {
                fileSizeOperator = (String)searchValue;
                if (fileSize == null) continue;
                if (fileSizeOperator.equals(GOT_FILE_SIZE_OPERATOR_LOWER)) {
                    if (nestedSubQuery == null) {
                        nestedSubQuery = QueryHelper.and();
                    }
                    nestedSubQuery.add(new Query[]{QueryHelper.lt((String)FILE_SIZE_GOT_FIELD, (String)fileSize)});
                    continue;
                }
                if (!fileSizeOperator.equals(GOT_FILE_SIZE_OPERATOR_GREATER_OR_EQUAL)) continue;
                if (nestedSubQuery == null) {
                    nestedSubQuery = QueryHelper.and();
                }
                nestedSubQuery.add(new Query[]{QueryHelper.gte((String)FILE_SIZE_GOT_FIELD, (String)fileSize)});
                continue;
            }
            if (searchKeys.equalsIgnoreCase(RULE_CATEGORY)) {
                ruleCategory = (String)searchValue;
            }
            if (searchKeys.equalsIgnoreCase(RULE_DATE_SUP)) {
                ruleEndDate = (String)searchValue;
            }
            if (searchKeys.equalsIgnoreCase(RULE_FINAL_ACTION)) {
                ruleFinalAction = (String)searchValue;
            }
            if (searchKeys.startsWith(START_PREFIX)) {
                startDate = (String)searchValue;
                continue;
            }
            if (searchKeys.startsWith(END_PREFIX)) {
                endDate = (String)searchValue;
                continue;
            }
            if (searchKeys.equalsIgnoreCase(ADVANCED_SEARCH_FLAG)) {
                advancedSearchFlag = (String)searchValue;
                continue;
            }
            if (searchKeys.equalsIgnoreCase(REQUEST_FACET_PREFIX) && (requestFacetItem = (RequestFacetItem)JsonHandler.getFromString((String)JsonHandler.writeAsString((Object)searchValue), RequestFacetItem.class)) != null && requestFacetItem.getField() != null && requestFacetItem.getValue() != null) {
                switch (requestFacetItem.getField()) {
                    case "#elimination.DestroyableOriginatingAgencies": 
                    case "#elimination.NonDestroyableOriginatingAgencies": 
                    case "#elimination.GlobalStatus": 
                    case "#elimination.ExtendedInfo.ExtendedInfoType": 
                    case "#originating_agency": 
                    case "DescriptionLevel": {
                        advancedFacetQuery = true;
                        andQuery.add(new Query[]{QueryHelper.eq((String)requestFacetItem.getField(), (String)requestFacetItem.getValue())});
                        continue block20;
                    }
                    case "StartDate": 
                    case "EndDate": {
                        String[] values = requestFacetItem.getValue().split("-");
                        if (values.length != 2) continue block20;
                        advancedFacetQuery = true;
                        andQuery.add(new Query[]{QueryHelper.gte((String)requestFacetItem.getField(), (String)values[0]), QueryHelper.lte((String)requestFacetItem.getField(), (String)values[1])});
                        continue block20;
                    }
                }
                if (requestFacetItem.getField().startsWith(TITLE) || requestFacetItem.getField().startsWith(DESCRIPTION)) {
                    andQuery.add(new Query[]{QueryHelper.exists((String)requestFacetItem.getField())});
                }
                if (requestFacetItem.getField().startsWith(LANGUAGE)) {
                    andQuery.add(new Query[]{QueryHelper.eq((String)requestFacetItem.getField(), (String)requestFacetItem.getValue())});
                }
                if (requestFacetItem.getValue().equalsIgnoreCase(FACET_WITH_OBJECT)) {
                    andQuery.add(new Query[]{QueryHelper.exists((String)requestFacetItem.getField())});
                } else if (requestFacetItem.getValue().equalsIgnoreCase(FACET_WITHOUT_OBJECT)) {
                    andQuery.add(new Query[]{QueryHelper.missing((String)requestFacetItem.getField())});
                }
                advancedFacetQuery = true;
                continue;
            }
            if (searchKeys.equalsIgnoreCase("fieldArchiveUnit") || searchKeys.equalsIgnoreCase("valueArchiveUnit")) continue;
            booleanQueries.add(new Query[]{QueryHelper.match((String)searchKeys, (String)((String)searchValue))});
        }
        if (searchCriteriaMap.get("fieldArchiveUnit") != null) {
            andQuery.add(new Query[]{QueryHelper.eq((String)((String)searchCriteriaMap.get("fieldArchiveUnit")), (String)((String)searchCriteriaMap.get("valueArchiveUnit")))});
        }
        if (!Strings.isNullOrEmpty(endDate) && !Strings.isNullOrEmpty(startDate)) {
            andQuery.add(new Query[]{this.createSearchUntisQueryByDate(startDate, endDate)});
        }
        if (!Strings.isNullOrEmpty(ruleCategory)) {
            String managmentRuleCategory = VitamFieldsHelper.management() + "." + ruleCategory;
            if (!Strings.isNullOrEmpty(ruleFinalAction)) {
                andQuery.add(new Query[]{QueryHelper.eq((String)(managmentRuleCategory + ".FinalAction"), ruleFinalAction)});
            }
            if (!Strings.isNullOrEmpty(ruleEndDate)) {
                andQuery.add(new Query[]{QueryHelper.lte((String)(managmentRuleCategory + ".Rules.EndDate"), ruleEndDate)});
            }
        }
        if (nestedSubQuery != null) {
            andQuery.add(new Query[]{QueryHelper.nestedSearch((String)"#qualifiers.versions", (JsonNode)nestedSubQuery.getCurrentQuery())});
        }
        boolean bl = noRoots = select.getRoots() == null || select.getRoots().isEmpty();
        if (advancedFacetQuery) {
            if (booleanQueries.isReady()) {
                if (!noRoots || select.getNbQueries() != 0) {
                    booleanQueries.setDepthLimit(20);
                }
                andQuery.add(new Query[]{booleanQueries});
            }
            if (andQuery.isReady()) {
                if (!noRoots || select.getNbQueries() != 0) {
                    andQuery.setDepthLimit(20);
                }
                select.addQueries(new Query[]{andQuery});
            }
        } else if (advancedSearchFlag.equalsIgnoreCase(YES)) {
            if (andQuery.isReady()) {
                if (!noRoots || select.getNbQueries() != 0) {
                    andQuery.setDepthLimit(20);
                }
                select.addQueries(new Query[]{andQuery});
            }
        } else if (booleanQueries.isReady()) {
            if (!noRoots || select.getNbQueries() != 0) {
                booleanQueries.setDepthLimit(20);
            }
            select.addQueries(new Query[]{booleanQueries});
        }
        return select.getFinalSelect();
    }

    public JsonNode createUpdateByIdDSLQuery(Map<String, JsonNode> searchCriteriaMap, Map<String, JsonNode> updateRules) throws InvalidParseOperationException, InvalidCreateOperationException {
        HashMap<Object, JsonNode> action;
        UpdateMultiQuery update = new UpdateMultiQuery();
        for (Map.Entry<String, JsonNode> entry : searchCriteriaMap.entrySet()) {
            String searchKeys = entry.getKey();
            JsonNode searchValue = entry.getValue();
            if (searchKeys.isEmpty()) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            action = new HashMap<Object, JsonNode>();
            action.put(searchKeys, searchValue);
            update.addActions(new Action[]{new SetAction(action)});
        }
        for (Map.Entry<String, JsonNode> categoryRule : updateRules.entrySet()) {
            String categoryKey = categoryRule.getKey();
            JsonNode categoryRules = categoryRule.getValue();
            if (categoryRules.isEmpty((SerializerProvider)new DefaultSerializerProvider.Impl())) {
                update.addActions(new Action[]{new UnsetAction(new String[]{"#management." + categoryKey})});
                continue;
            }
            action = new HashMap();
            action.put("#management." + categoryKey, categoryRules);
            update.addActions(new Action[]{new SetAction(action)});
        }
        return update.getFinalUpdateById();
    }

    public ObjectNode createMassiveUpdateDSLBaseQuery(JsonNode modifiedFields) {
        JsonNode query = modifiedFields.get("query");
        JsonNode threshold = modifiedFields.get("threshold");
        ObjectNode fullQuery = JsonHandler.createObjectNode();
        fullQuery.set(BuilderToken.GLOBAL.ROOTS.exactToken(), (JsonNode)JsonHandler.createArrayNode());
        fullQuery.set(BuilderToken.GLOBAL.QUERY.exactToken(), query.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        if (threshold != null && threshold.longValue() != 0L) {
            fullQuery.set(BuilderToken.GLOBAL.THRESOLD.exactToken(), threshold);
        }
        return fullQuery;
    }

    public UpdateMultiQuery getFullMetadataActionQuery(JsonNode metadataModifications) throws InvalidParseOperationException, InvalidCreateOperationException {
        HashMap<String, Object> action;
        UpdateMultiQuery update = new UpdateMultiQuery();
        if (metadataModifications == null) {
            return null;
        }
        JsonNode metadataPatterns = metadataModifications.get("patterns");
        for (Object modifiedField : metadataPatterns) {
            String fieldName = modifiedField.get("FieldName").textValue();
            String patternControll = modifiedField.get("FieldValue").textValue();
            String patternUpdate = modifiedField.get("FieldPattern").textValue();
            if (fieldName == null || patternControll == null || patternUpdate == null) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            ObjectNode actionNode = JsonHandler.createObjectNode();
            actionNode.set("$target", modifiedField.get("FieldName"));
            actionNode.set("$controlPattern", modifiedField.get("FieldPattern"));
            actionNode.set("$updatePattern", modifiedField.get("FieldValue"));
            update.addActions(new Action[]{new SetregexAction(actionNode)});
        }
        JsonNode metadataUpdates = metadataModifications.get("updates");
        for (JsonNode modifiedField : metadataUpdates) {
            String fieldName = modifiedField.get("FieldName").textValue();
            JsonNode fieldValue = modifiedField.get("FieldValue");
            if (fieldName == null) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            action = new HashMap<String, Object>();
            action.put(fieldName, fieldValue);
            update.addActions(new Action[]{new SetAction(action)});
        }
        JsonNode metadataDeletions = metadataModifications.get("deletions");
        for (JsonNode deletedField : metadataDeletions) {
            String fieldName = deletedField.get("FieldName").textValue();
            if (fieldName == null) {
                throw new InvalidParseOperationException("Parameters should not be empty or null");
            }
            action = new HashMap();
            action.put(fieldName, new TextNode(""));
            update.addActions(new Action[]{new SetAction(action)});
        }
        return update;
    }

    private BooleanQuery createSearchUntisQueryByDate(String startDate, String endDate) throws InvalidCreateOperationException {
        LOGGER.debug("in createSearchUntisQueryByDate / beginDate:" + startDate + "/ endDate:" + endDate);
        BooleanQuery query = QueryHelper.or();
        if (!Strings.isNullOrEmpty((String)endDate) && !Strings.isNullOrEmpty((String)startDate)) {
            BooleanQuery transactedDateBetween = QueryHelper.and();
            transactedDateBetween.add(new Query[]{QueryHelper.gte((String)TRANSACTED_DATE, (String)startDate)});
            transactedDateBetween.add(new Query[]{QueryHelper.lte((String)TRANSACTED_DATE, (String)endDate)});
            BooleanQuery queryAroundDate = QueryHelper.and();
            queryAroundDate.add(new Query[]{QueryHelper.gte((String)END_DATE, (String)startDate)});
            queryAroundDate.add(new Query[]{QueryHelper.lte((String)START_DATE, (String)endDate)});
            query.add(new Query[]{transactedDateBetween, queryAroundDate});
        }
        LOGGER.debug("in createSearchUntisQueryByDate / query:" + query.toString());
        return query;
    }

    public JsonNode createSearchQueryAccessionRegister(Map<String, Object> options) throws InvalidCreateOperationException {
        String startDate = (String)options.get("startDate");
        String endDate = (String)options.get("endDate");
        String originatingAgency = (String)options.get(ORIGINATING_AGENCY);
        Date from = Date.from(LocalDateUtil.parse((String)startDate, (DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant(ZoneOffset.UTC));
        Date to = Date.from(LocalDateUtil.parse((String)endDate, (DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant(ZoneOffset.UTC));
        RangeQuery range = QueryHelper.range((String)"CreationDate", (Date)from, (boolean)true, (Date)to, (boolean)true);
        CompareQuery eqOriginatingAgency = QueryHelper.eq((String)ORIGINATING_AGENCY, (String)originatingAgency);
        Select select = new Select();
        select.setQuery((Query)QueryHelper.and().add(new Query[]{eqOriginatingAgency, range}));
        return select.getFinalSelect();
    }

    public JsonNode createSelectAndUpdateDSLQuery(Map<String, Object> optionsMap) {
        String actionType;
        ArrayNode queryArray = JsonHandler.createArrayNode();
        ObjectNode query = JsonHandler.createObjectNode();
        ObjectNode eqQuery = JsonHandler.createObjectNode();
        eqQuery.set("#id", (JsonNode)new TextNode((String)optionsMap.get("childId")));
        query.set("$eq", (JsonNode)eqQuery);
        queryArray.add((JsonNode)query);
        ArrayNode actions = JsonHandler.createArrayNode();
        ObjectNode action = JsonHandler.createObjectNode();
        ObjectNode actionDetails = JsonHandler.createObjectNode();
        ArrayNode actionIds = JsonHandler.createArrayNode();
        switch ((String)optionsMap.get("action")) {
            case "ADD": {
                actionType = "$add";
                break;
            }
            case "DELETE": {
                actionType = "$pull";
                break;
            }
            default: {
                return null;
            }
        }
        actionIds.add((String)optionsMap.get("parentId"));
        actionDetails.set("#unitups", (JsonNode)actionIds);
        action.set(actionType, (JsonNode)actionDetails);
        actions.add((JsonNode)action);
        ArrayNode queries = JsonHandler.createArrayNode();
        ObjectNode finalQuery = JsonHandler.createObjectNode();
        finalQuery.set("$roots", (JsonNode)JsonHandler.createArrayNode());
        finalQuery.set("$query", (JsonNode)queryArray);
        finalQuery.set("$action", (JsonNode)actions);
        queries.add((JsonNode)finalQuery);
        return queries;
    }

    private static /* synthetic */ void lambda$createSingleQueryDSL$1(Map filters, FacetFiltersItem filter) {
        if (filter.getQuery().get(EXISTS) != null) {
            try {
                filters.put(filter.getName(), QueryHelper.exists((String)filter.getQuery().get(EXISTS).asText()));
            }
            catch (InvalidCreateOperationException e) {
                LOGGER.error((Throwable)e);
            }
        } else if (filter.getQuery().get(MISSING) != null) {
            try {
                filters.put(filter.getName(), QueryHelper.missing((String)filter.getQuery().get(MISSING).asText()));
            }
            catch (InvalidCreateOperationException e) {
                LOGGER.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ RangeFacetValue lambda$createSingleQueryDSL$0(FacetDateRangeItem range) {
        return new RangeFacetValue(range.getDateMin(), range.getDateMax());
    }
}

