/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.administration.RuleMeasurementEnum;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class ArchiveUnitUpdateUtils {
    public static final String UNLIMITED_RULE_DURATION = "unlimited";
    private static final String _DIFF = "$diff";
    private static final String DIFF = "#diff";
    private static final String FINAL_DIFF = "diff";

    public static boolean updateCategoryRules(JsonNode rulesForCategory, List<JsonNode> listRulesByType, UpdateMultiQuery query, String key) throws InvalidCreateOperationException {
        ArrayNode updatedRulesFinalForCategory = JsonHandler.createArrayNode();
        boolean updateNeeded = false;
        for (JsonNode ruleToUpdate : rulesForCategory) {
            String updateRuleName = ruleToUpdate.get("Rule").asText();
            boolean findIt = false;
            for (JsonNode rule : listRulesByType) {
                if (rule.get("RuleId").asText() == null || !rule.get("RuleId").asText().equals(updateRuleName) || ruleToUpdate.get("StartDate") == null) continue;
                updateNeeded = true;
                findIt = true;
                JsonNode updatedRule = ArchiveUnitUpdateUtils.computeEndDate((ObjectNode)ruleToUpdate, rule);
                updatedRulesFinalForCategory.add(updatedRule);
            }
            if (findIt) continue;
            updatedRulesFinalForCategory.add(ruleToUpdate);
        }
        HashMap<CallSite, ArrayNode> action = new HashMap<CallSite, ArrayNode>();
        action.put((CallSite)((Object)(VitamFieldsHelper.management() + "." + key + ".Rules")), updatedRulesFinalForCategory);
        query.addActions(new Action[]{new SetAction(action)});
        return updateNeeded;
    }

    @Nonnull
    public static JsonNode computeEndDate(@Nonnull ObjectNode updatingRule, JsonNode ruleModel) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (!updatingRule.has("StartDate")) {
            return updatingRule;
        }
        String startDateString = updatingRule.get("StartDate").asText();
        String ruleId = updatingRule.get("Rule").asText();
        if (ParametersChecker.isNotEmpty((String[])new String[]{startDateString, ruleId})) {
            LocalDate startDate = LocalDate.parse(startDateString, timeFormatter);
            if (startDate.getYear() >= 9000) {
                throw new IllegalStateException("Wrong Start Date");
            }
            if (ruleModel.has("RuleDuration")) {
                String duration = ruleModel.get("RuleDuration").asText();
                String measurement = ruleModel.get("RuleMeasurement").asText();
                if (!UNLIMITED_RULE_DURATION.equalsIgnoreCase(duration)) {
                    RuleMeasurementEnum ruleMeasurement = RuleMeasurementEnum.getEnumFromType((String)measurement);
                    updatingRule.put("EndDate", startDate.plus(Integer.parseInt(duration), ruleMeasurement.getTemporalUnit()).format(timeFormatter));
                } else {
                    updatingRule.remove("EndDate");
                }
            }
        }
        return updatingRule;
    }

    public static String getDiffMessageFor(JsonNode diff, String unitId) throws InvalidParseOperationException {
        if (diff != null) {
            JsonNode arrayNode;
            JsonNode jsonNode = arrayNode = diff.has(_DIFF) ? diff.get(_DIFF) : diff.get("$results");
            if (arrayNode != null) {
                for (JsonNode diffNode : arrayNode) {
                    if (diffNode.get(VitamFieldsHelper.id()) == null || !unitId.equals(diffNode.get(VitamFieldsHelper.id()).textValue())) continue;
                    ObjectNode diffObject = JsonHandler.createObjectNode();
                    diffObject.set(FINAL_DIFF, diffNode.get(DIFF));
                    return JsonHandler.writeAsString((Object)diffObject);
                }
            }
        }
        return "";
    }
}

