/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.common.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchNode;
import fr.gouv.vitam.common.server.application.configuration.DbConfigurationImpl;
import fr.gouv.vitam.common.server.application.configuration.MongoDbNode;
import fr.gouv.vitam.functional.administration.common.config.CustomSearchOnFieldsConfiguration;
import fr.gouv.vitam.functional.administration.common.config.FunctionalAdminIndexationConfiguration;
import java.util.List;
import java.util.Map;

public class AdminManagementConfiguration
extends DbConfigurationImpl {
    private String workspaceUrl;
    private String processingUrl;
    private String clusterName;
    private List<ElasticsearchNode> elasticsearchNodes;
    @JsonProperty(value="elasticsearchTenantIndexation")
    private FunctionalAdminIndexationConfiguration indexationConfiguration;
    @JsonProperty(value="accessionRegisterSymbolicThreadPoolSize")
    private Integer accessionRegisterSymbolicThreadPoolSize;
    @JsonProperty(value="ruleAuditThreadPoolSize")
    private Integer ruleAuditThreadPoolSize;
    @JsonProperty(value="customSearchOnFields")
    private CustomSearchOnFieldsConfiguration customSearchOnFieldsConfiguration;
    private int reconstructionMetricsCacheDurationInMinutes = 15;
    @JsonProperty(value="elasticsearchConfigurationFile")
    private String elasticsearchConfigurationFile;
    private Map<Integer, List<String>> listEnableExternalIdentifiers;
    private Map<Integer, Map<String, String>> listMinimumRuleDuration;

    AdminManagementConfiguration() {
    }

    public AdminManagementConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, String clusterName, List<ElasticsearchNode> elasticsearchNodes) {
        super(mongoDbNodes, dbName);
        this.clusterName = clusterName;
        this.elasticsearchNodes = elasticsearchNodes;
    }

    @VisibleForTesting
    public AdminManagementConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, boolean dbAuthentication, String dbUserName, String dbPassword, FunctionalAdminIndexationConfiguration indexationConfiguration) {
        super(mongoDbNodes, dbName, dbAuthentication, dbUserName, dbPassword);
        this.indexationConfiguration = indexationConfiguration;
    }

    @VisibleForTesting
    public AdminManagementConfiguration(List<MongoDbNode> mongoDbNodes, String dbName, FunctionalAdminIndexationConfiguration indexationConfiguration) {
        super(mongoDbNodes, dbName);
        this.indexationConfiguration = indexationConfiguration;
    }

    public String getWorkspaceUrl() {
        return this.workspaceUrl;
    }

    public void setWorkspaceUrl(String workspaceUrl) {
        this.workspaceUrl = workspaceUrl;
    }

    public String getProcessingUrl() {
        return this.processingUrl;
    }

    public void setProcessingUrl(String processingUrl) {
        this.processingUrl = processingUrl;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public AdminManagementConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public List<ElasticsearchNode> getElasticsearchNodes() {
        return this.elasticsearchNodes;
    }

    public AdminManagementConfiguration setElasticsearchNodes(List<ElasticsearchNode> elasticsearchNodes) {
        this.elasticsearchNodes = elasticsearchNodes;
        return this;
    }

    public Map<Integer, List<String>> getListEnableExternalIdentifiers() {
        return this.listEnableExternalIdentifiers;
    }

    public void setListEnableExternalIdentifiers(Map<Integer, List<String>> listEnableExternalIdentifiers) {
        this.listEnableExternalIdentifiers = listEnableExternalIdentifiers;
    }

    public Map<Integer, Map<String, String>> getListMinimumRuleDuration() {
        return this.listMinimumRuleDuration;
    }

    public AdminManagementConfiguration setListMinimumRuleDuration(Map<Integer, Map<String, String>> listMinimumRuleDuration) {
        this.listMinimumRuleDuration = listMinimumRuleDuration;
        return this;
    }

    public FunctionalAdminIndexationConfiguration getIndexationConfiguration() {
        return this.indexationConfiguration;
    }

    public AdminManagementConfiguration setIndexationConfiguration(FunctionalAdminIndexationConfiguration indexationConfiguration) {
        this.indexationConfiguration = indexationConfiguration;
        return this;
    }

    public Integer getAccessionRegisterSymbolicThreadPoolSize() {
        return this.accessionRegisterSymbolicThreadPoolSize;
    }

    public AdminManagementConfiguration setAccessionRegisterSymbolicThreadPoolSize(Integer accessionRegisterSymbolicThreadPoolSize) {
        this.accessionRegisterSymbolicThreadPoolSize = accessionRegisterSymbolicThreadPoolSize;
        return this;
    }

    public Integer getRuleAuditThreadPoolSize() {
        return this.ruleAuditThreadPoolSize;
    }

    public void setRuleAuditThreadPoolSize(Integer ruleAuditThreadPoolSize) {
        this.ruleAuditThreadPoolSize = ruleAuditThreadPoolSize;
    }

    public int getReconstructionMetricsCacheDurationInMinutes() {
        return this.reconstructionMetricsCacheDurationInMinutes;
    }

    public void setReconstructionMetricsCacheDurationInMinutes(int reconstructionMetricsCacheDurationInMinutes) {
        this.reconstructionMetricsCacheDurationInMinutes = reconstructionMetricsCacheDurationInMinutes;
    }

    public String getElasticsearchConfigurationFile() {
        return this.elasticsearchConfigurationFile;
    }

    public AdminManagementConfiguration setElasticsearchConfigurationFile(String elasticSearchConfigurationFile) {
        this.elasticsearchConfigurationFile = elasticSearchConfigurationFile;
        return this;
    }

    public CustomSearchOnFieldsConfiguration getCustomSearchOnFieldsConfiguration() {
        return this.customSearchOnFieldsConfiguration;
    }

    public AdminManagementConfiguration setCustomSearchOnFieldsConfiguration(CustomSearchOnFieldsConfiguration customSearchOnFieldsConfiguration) {
        this.customSearchOnFieldsConfiguration = customSearchOnFieldsConfiguration;
        return this;
    }
}

